package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Object;
import java.util.Map;

public interface ServiceCAFluent<A extends ServiceCAFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ServiceCAFluent.MetadataNested<A> withNewMetadata();
    public ServiceCAFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ServiceCAFluent.MetadataNested<A> editMetadata();
    public ServiceCAFluent.MetadataNested<A> editOrNewMetadata();
    public ServiceCAFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public ServiceCASpec getSpec();
    public ServiceCASpec buildSpec();
    public A withSpec(ServiceCASpec spec);
    public Boolean hasSpec();
    public ServiceCAFluent.SpecNested<A> withNewSpec();
    public ServiceCAFluent.SpecNested<A> withNewSpecLike(ServiceCASpec item);
    public ServiceCAFluent.SpecNested<A> editSpec();
    public ServiceCAFluent.SpecNested<A> editOrNewSpec();
    public ServiceCAFluent.SpecNested<A> editOrNewSpecLike(ServiceCASpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public ServiceCAStatus getStatus();
    public ServiceCAStatus buildStatus();
    public A withStatus(ServiceCAStatus status);
    public Boolean hasStatus();
    public ServiceCAFluent.StatusNested<A> withNewStatus();
    public ServiceCAFluent.StatusNested<A> withNewStatusLike(ServiceCAStatus item);
    public ServiceCAFluent.StatusNested<A> editStatus();
    public ServiceCAFluent.StatusNested<A> editOrNewStatus();
    public ServiceCAFluent.StatusNested<A> editOrNewStatusLike(ServiceCAStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ServiceCAFluent.MetadataNested<N>> {

        public N and();
        public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCASpecFluent<ServiceCAFluent.SpecNested<N>> {

        public N and();
        public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCAStatusFluent<ServiceCAFluent.StatusNested<N>> {

        public N and();
        public N endStatus();    }


}
