package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class RouteAdmissionPolicyFluentImpl<A extends RouteAdmissionPolicyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RouteAdmissionPolicyFluent<A> {

    private String namespaceOwnership;
    private String wildcardPolicy;

    public RouteAdmissionPolicyFluentImpl() { 
    }


    public RouteAdmissionPolicyFluentImpl(RouteAdmissionPolicy instance) { 
        this.withNamespaceOwnership(instance.getNamespaceOwnership()); 
        this.withWildcardPolicy(instance.getWildcardPolicy()); 
    }


    public String getNamespaceOwnership() {
        return this.namespaceOwnership;
    }

    public A withNamespaceOwnership(String namespaceOwnership) {
        this.namespaceOwnership=namespaceOwnership; return (A) this;
    }

    public Boolean hasNamespaceOwnership() {
        return this.namespaceOwnership != null;
    }

    public A withNewNamespaceOwnership(String arg1) {
        return (A)withNamespaceOwnership(new String(arg1));
    }

    public A withNewNamespaceOwnership(StringBuilder arg1) {
        return (A)withNamespaceOwnership(new String(arg1));
    }

    public A withNewNamespaceOwnership(StringBuffer arg1) {
        return (A)withNamespaceOwnership(new String(arg1));
    }

    public String getWildcardPolicy() {
        return this.wildcardPolicy;
    }

    public A withWildcardPolicy(String wildcardPolicy) {
        this.wildcardPolicy=wildcardPolicy; return (A) this;
    }

    public Boolean hasWildcardPolicy() {
        return this.wildcardPolicy != null;
    }

    public A withNewWildcardPolicy(String arg1) {
        return (A)withWildcardPolicy(new String(arg1));
    }

    public A withNewWildcardPolicy(StringBuilder arg1) {
        return (A)withWildcardPolicy(new String(arg1));
    }

    public A withNewWildcardPolicy(StringBuffer arg1) {
        return (A)withWildcardPolicy(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RouteAdmissionPolicyFluentImpl that = (RouteAdmissionPolicyFluentImpl) o;
        if (namespaceOwnership != null ? !namespaceOwnership.equals(that.namespaceOwnership) :that.namespaceOwnership != null) return false;
        if (wildcardPolicy != null ? !wildcardPolicy.equals(that.wildcardPolicy) :that.wildcardPolicy != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(namespaceOwnership,  wildcardPolicy,  super.hashCode());
    }

}
