package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface ProxyConfigFluent<A extends ProxyConfigFluent<A>> extends Fluent<A> {


    public String getBindAddress();
    public A withBindAddress(String bindAddress);
    public Boolean hasBindAddress();
    public A withNewBindAddress(String arg1);
    public A withNewBindAddress(StringBuilder arg1);
    public A withNewBindAddress(StringBuffer arg1);
    public String getIptablesSyncPeriod();
    public A withIptablesSyncPeriod(String iptablesSyncPeriod);
    public Boolean hasIptablesSyncPeriod();
    public A withNewIptablesSyncPeriod(String arg1);
    public A withNewIptablesSyncPeriod(StringBuilder arg1);
    public A withNewIptablesSyncPeriod(StringBuffer arg1);
    public A addToProxyArguments(String key,ArrayList<String> value);
    public A addToProxyArguments(Map<String,ArrayList<String>> map);
    public A removeFromProxyArguments(String key);
    public A removeFromProxyArguments(Map<String,ArrayList<String>> map);
    public Map<String,ArrayList<String>> getProxyArguments();
    public A withProxyArguments(Map<String,ArrayList<String>> proxyArguments);
    public Boolean hasProxyArguments();
}
