package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Object;
import java.util.Map;
import java.lang.Deprecated;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder;

public interface OpenShiftControllerManagerSpecFluent<A extends OpenShiftControllerManagerSpecFluent<A>> extends Fluent<A> {


    public String getLogLevel();
    public A withLogLevel(String logLevel);
    public Boolean hasLogLevel();
    public A withNewLogLevel(String arg1);
    public A withNewLogLevel(StringBuilder arg1);
    public A withNewLogLevel(StringBuffer arg1);
    public String getManagementState();
    public A withManagementState(String managementState);
    public Boolean hasManagementState();
    public A withNewManagementState(String arg1);
    public A withNewManagementState(StringBuilder arg1);
    public A withNewManagementState(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildObservedConfig instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getObservedConfig();
    public HasMetadata buildObservedConfig();
    public A withObservedConfig(HasMetadata observedConfig);
    public Boolean hasObservedConfig();
    public A withImagePrunerObservedConfig(ImagePruner imagePrunerObservedConfig);
    public OpenShiftControllerManagerSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfig();
    public OpenShiftControllerManagerSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfigLike(ImagePruner item);
    public A withKubeControllerManagerObservedConfig(KubeControllerManager kubeControllerManagerObservedConfig);
    public OpenShiftControllerManagerSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfig();
    public OpenShiftControllerManagerSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfigLike(KubeControllerManager item);
    public A withImageContentSourcePolicyObservedConfig(ImageContentSourcePolicy imageContentSourcePolicyObservedConfig);
    public OpenShiftControllerManagerSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfig();
    public OpenShiftControllerManagerSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfigLike(ImageContentSourcePolicy item);
    public A withServiceCAObservedConfig(ServiceCA serviceCAObservedConfig);
    public OpenShiftControllerManagerSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfig();
    public OpenShiftControllerManagerSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfigLike(ServiceCA item);
    public A withPersistentVolumeClaimObservedConfig(PersistentVolumeClaim persistentVolumeClaimObservedConfig);
    public OpenShiftControllerManagerSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfig();
    public OpenShiftControllerManagerSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfigLike(PersistentVolumeClaim item);
    public A withKubeAPIServerObservedConfig(KubeAPIServer kubeAPIServerObservedConfig);
    public OpenShiftControllerManagerSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfig();
    public OpenShiftControllerManagerSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfigLike(KubeAPIServer item);
    public A withIngressControllerObservedConfig(IngressController ingressControllerObservedConfig);
    public OpenShiftControllerManagerSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfig();
    public OpenShiftControllerManagerSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfigLike(IngressController item);
    public A withKubeStorageVersionMigratorObservedConfig(KubeStorageVersionMigrator kubeStorageVersionMigratorObservedConfig);
    public OpenShiftControllerManagerSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfig();
    public OpenShiftControllerManagerSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfigLike(KubeStorageVersionMigrator item);
    public A withConsoleObservedConfig(Console consoleObservedConfig);
    public OpenShiftControllerManagerSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfig();
    public OpenShiftControllerManagerSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfigLike(Console item);
    public A withOpenShiftControllerManagerObservedConfig(OpenShiftControllerManager openShiftControllerManagerObservedConfig);
    public OpenShiftControllerManagerSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfig();
    public OpenShiftControllerManagerSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfigLike(OpenShiftControllerManager item);
    public A withEtcdObservedConfig(Etcd etcdObservedConfig);
    public OpenShiftControllerManagerSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfig();
    public OpenShiftControllerManagerSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfigLike(Etcd item);
    public A withKubeSchedulerObservedConfig(KubeScheduler kubeSchedulerObservedConfig);
    public OpenShiftControllerManagerSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfig();
    public OpenShiftControllerManagerSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfigLike(KubeScheduler item);
    public A withNetworkObservedConfig(Network networkObservedConfig);
    public OpenShiftControllerManagerSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfig();
    public OpenShiftControllerManagerSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfigLike(Network item);
    public A withServiceCatalogAPIServerObservedConfig(ServiceCatalogAPIServer serviceCatalogAPIServerObservedConfig);
    public OpenShiftControllerManagerSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfig();
    public OpenShiftControllerManagerSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfigLike(ServiceCatalogAPIServer item);
    public A withCSISnapshotControllerObservedConfig(CSISnapshotController cSISnapshotControllerObservedConfig);
    public OpenShiftControllerManagerSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfig();
    public OpenShiftControllerManagerSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfigLike(CSISnapshotController item);
    public A withServiceCatalogControllerManagerObservedConfig(ServiceCatalogControllerManager serviceCatalogControllerManagerObservedConfig);
    public OpenShiftControllerManagerSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfig();
    public OpenShiftControllerManagerSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfigLike(ServiceCatalogControllerManager item);
    public A withDNSObservedConfig(DNS dNSObservedConfig);
    public OpenShiftControllerManagerSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfig();
    public OpenShiftControllerManagerSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfigLike(DNS item);
    public A withDNSRecordObservedConfig(DNSRecord dNSRecordObservedConfig);
    public OpenShiftControllerManagerSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfig();
    public OpenShiftControllerManagerSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfigLike(DNSRecord item);
    public A withOpenShiftAPIServerObservedConfig(OpenShiftAPIServer openShiftAPIServerObservedConfig);
    public OpenShiftControllerManagerSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfig();
    public OpenShiftControllerManagerSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfigLike(OpenShiftAPIServer item);
    public A withAuthenticationObservedConfig(Authentication authenticationObservedConfig);
    public OpenShiftControllerManagerSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfig();
    public OpenShiftControllerManagerSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfigLike(Authentication item);
    public String getOperatorLogLevel();
    public A withOperatorLogLevel(String operatorLogLevel);
    public Boolean hasOperatorLogLevel();
    public A withNewOperatorLogLevel(String arg1);
    public A withNewOperatorLogLevel(StringBuilder arg1);
    public A withNewOperatorLogLevel(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildUnsupportedConfigOverrides instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getUnsupportedConfigOverrides();
    public HasMetadata buildUnsupportedConfigOverrides();
    public A withUnsupportedConfigOverrides(HasMetadata unsupportedConfigOverrides);
    public Boolean hasUnsupportedConfigOverrides();
    public A withImagePrunerUnsupportedConfigOverrides(ImagePruner imagePrunerUnsupportedConfigOverrides);
    public OpenShiftControllerManagerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverrides();
    public OpenShiftControllerManagerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverridesLike(ImagePruner item);
    public A withKubeControllerManagerUnsupportedConfigOverrides(KubeControllerManager kubeControllerManagerUnsupportedConfigOverrides);
    public OpenShiftControllerManagerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverrides();
    public OpenShiftControllerManagerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverridesLike(KubeControllerManager item);
    public A withImageContentSourcePolicyUnsupportedConfigOverrides(ImageContentSourcePolicy imageContentSourcePolicyUnsupportedConfigOverrides);
    public OpenShiftControllerManagerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverrides();
    public OpenShiftControllerManagerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverridesLike(ImageContentSourcePolicy item);
    public A withServiceCAUnsupportedConfigOverrides(ServiceCA serviceCAUnsupportedConfigOverrides);
    public OpenShiftControllerManagerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverrides();
    public OpenShiftControllerManagerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverridesLike(ServiceCA item);
    public A withPersistentVolumeClaimUnsupportedConfigOverrides(PersistentVolumeClaim persistentVolumeClaimUnsupportedConfigOverrides);
    public OpenShiftControllerManagerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverrides();
    public OpenShiftControllerManagerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverridesLike(PersistentVolumeClaim item);
    public A withKubeAPIServerUnsupportedConfigOverrides(KubeAPIServer kubeAPIServerUnsupportedConfigOverrides);
    public OpenShiftControllerManagerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverrides();
    public OpenShiftControllerManagerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverridesLike(KubeAPIServer item);
    public A withIngressControllerUnsupportedConfigOverrides(IngressController ingressControllerUnsupportedConfigOverrides);
    public OpenShiftControllerManagerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverrides();
    public OpenShiftControllerManagerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverridesLike(IngressController item);
    public A withKubeStorageVersionMigratorUnsupportedConfigOverrides(KubeStorageVersionMigrator kubeStorageVersionMigratorUnsupportedConfigOverrides);
    public OpenShiftControllerManagerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverrides();
    public OpenShiftControllerManagerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverridesLike(KubeStorageVersionMigrator item);
    public A withConsoleUnsupportedConfigOverrides(Console consoleUnsupportedConfigOverrides);
    public OpenShiftControllerManagerSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverrides();
    public OpenShiftControllerManagerSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverridesLike(Console item);
    public A withOpenShiftControllerManagerUnsupportedConfigOverrides(OpenShiftControllerManager openShiftControllerManagerUnsupportedConfigOverrides);
    public OpenShiftControllerManagerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverrides();
    public OpenShiftControllerManagerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverridesLike(OpenShiftControllerManager item);
    public A withEtcdUnsupportedConfigOverrides(Etcd etcdUnsupportedConfigOverrides);
    public OpenShiftControllerManagerSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverrides();
    public OpenShiftControllerManagerSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverridesLike(Etcd item);
    public A withKubeSchedulerUnsupportedConfigOverrides(KubeScheduler kubeSchedulerUnsupportedConfigOverrides);
    public OpenShiftControllerManagerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverrides();
    public OpenShiftControllerManagerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverridesLike(KubeScheduler item);
    public A withNetworkUnsupportedConfigOverrides(Network networkUnsupportedConfigOverrides);
    public OpenShiftControllerManagerSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverrides();
    public OpenShiftControllerManagerSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverridesLike(Network item);
    public A withServiceCatalogAPIServerUnsupportedConfigOverrides(ServiceCatalogAPIServer serviceCatalogAPIServerUnsupportedConfigOverrides);
    public OpenShiftControllerManagerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverrides();
    public OpenShiftControllerManagerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverridesLike(ServiceCatalogAPIServer item);
    public A withCSISnapshotControllerUnsupportedConfigOverrides(CSISnapshotController cSISnapshotControllerUnsupportedConfigOverrides);
    public OpenShiftControllerManagerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverrides();
    public OpenShiftControllerManagerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverridesLike(CSISnapshotController item);
    public A withServiceCatalogControllerManagerUnsupportedConfigOverrides(ServiceCatalogControllerManager serviceCatalogControllerManagerUnsupportedConfigOverrides);
    public OpenShiftControllerManagerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverrides();
    public OpenShiftControllerManagerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverridesLike(ServiceCatalogControllerManager item);
    public A withDNSUnsupportedConfigOverrides(DNS dNSUnsupportedConfigOverrides);
    public OpenShiftControllerManagerSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverrides();
    public OpenShiftControllerManagerSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverridesLike(DNS item);
    public A withDNSRecordUnsupportedConfigOverrides(DNSRecord dNSRecordUnsupportedConfigOverrides);
    public OpenShiftControllerManagerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverrides();
    public OpenShiftControllerManagerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverridesLike(DNSRecord item);
    public A withOpenShiftAPIServerUnsupportedConfigOverrides(OpenShiftAPIServer openShiftAPIServerUnsupportedConfigOverrides);
    public OpenShiftControllerManagerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverrides();
    public OpenShiftControllerManagerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverridesLike(OpenShiftAPIServer item);
    public A withAuthenticationUnsupportedConfigOverrides(Authentication authenticationUnsupportedConfigOverrides);
    public OpenShiftControllerManagerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverrides();
    public OpenShiftControllerManagerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverridesLike(Authentication item);
    public interface ImagePrunerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImagePrunerFluent<OpenShiftControllerManagerSpecFluent.ImagePrunerObservedConfigNested<N>> {

        public N and();
        public N endImagePrunerObservedConfig();    }


    public interface KubeControllerManagerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeControllerManagerFluent<OpenShiftControllerManagerSpecFluent.KubeControllerManagerObservedConfigNested<N>> {

        public N and();
        public N endKubeControllerManagerObservedConfig();    }


    public interface ImageContentSourcePolicyObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageContentSourcePolicyFluent<OpenShiftControllerManagerSpecFluent.ImageContentSourcePolicyObservedConfigNested<N>> {

        public N and();
        public N endImageContentSourcePolicyObservedConfig();    }


    public interface ServiceCAObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCAFluent<OpenShiftControllerManagerSpecFluent.ServiceCAObservedConfigNested<N>> {

        public N and();
        public N endServiceCAObservedConfig();    }


    public interface PersistentVolumeClaimObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeClaimFluent<OpenShiftControllerManagerSpecFluent.PersistentVolumeClaimObservedConfigNested<N>> {

        public N and();
        public N endPersistentVolumeClaimObservedConfig();    }


    public interface KubeAPIServerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeAPIServerFluent<OpenShiftControllerManagerSpecFluent.KubeAPIServerObservedConfigNested<N>> {

        public N and();
        public N endKubeAPIServerObservedConfig();    }


    public interface IngressControllerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IngressControllerFluent<OpenShiftControllerManagerSpecFluent.IngressControllerObservedConfigNested<N>> {

        public N and();
        public N endIngressControllerObservedConfig();    }


    public interface KubeStorageVersionMigratorObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeStorageVersionMigratorFluent<OpenShiftControllerManagerSpecFluent.KubeStorageVersionMigratorObservedConfigNested<N>> {

        public N and();
        public N endKubeStorageVersionMigratorObservedConfig();    }


    public interface ConsoleObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConsoleFluent<OpenShiftControllerManagerSpecFluent.ConsoleObservedConfigNested<N>> {

        public N and();
        public N endConsoleObservedConfig();    }


    public interface OpenShiftControllerManagerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OpenShiftControllerManagerFluent<OpenShiftControllerManagerSpecFluent.OpenShiftControllerManagerObservedConfigNested<N>> {

        public N and();
        public N endOpenShiftControllerManagerObservedConfig();    }


    public interface EtcdObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EtcdFluent<OpenShiftControllerManagerSpecFluent.EtcdObservedConfigNested<N>> {

        public N and();
        public N endEtcdObservedConfig();    }


    public interface KubeSchedulerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeSchedulerFluent<OpenShiftControllerManagerSpecFluent.KubeSchedulerObservedConfigNested<N>> {

        public N and();
        public N endKubeSchedulerObservedConfig();    }


    public interface NetworkObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetworkFluent<OpenShiftControllerManagerSpecFluent.NetworkObservedConfigNested<N>> {

        public N and();
        public N endNetworkObservedConfig();    }


    public interface ServiceCatalogAPIServerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCatalogAPIServerFluent<OpenShiftControllerManagerSpecFluent.ServiceCatalogAPIServerObservedConfigNested<N>> {

        public N and();
        public N endServiceCatalogAPIServerObservedConfig();    }


    public interface CSISnapshotControllerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CSISnapshotControllerFluent<OpenShiftControllerManagerSpecFluent.CSISnapshotControllerObservedConfigNested<N>> {

        public N and();
        public N endCSISnapshotControllerObservedConfig();    }


    public interface ServiceCatalogControllerManagerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCatalogControllerManagerFluent<OpenShiftControllerManagerSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<N>> {

        public N and();
        public N endServiceCatalogControllerManagerObservedConfig();    }


    public interface DNSObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DNSFluent<OpenShiftControllerManagerSpecFluent.DNSObservedConfigNested<N>> {

        public N and();
        public N endDNSObservedConfig();    }


    public interface DNSRecordObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DNSRecordFluent<OpenShiftControllerManagerSpecFluent.DNSRecordObservedConfigNested<N>> {

        public N and();
        public N endDNSRecordObservedConfig();    }


    public interface OpenShiftAPIServerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OpenShiftAPIServerFluent<OpenShiftControllerManagerSpecFluent.OpenShiftAPIServerObservedConfigNested<N>> {

        public N and();
        public N endOpenShiftAPIServerObservedConfig();    }


    public interface AuthenticationObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AuthenticationFluent<OpenShiftControllerManagerSpecFluent.AuthenticationObservedConfigNested<N>> {

        public N and();
        public N endAuthenticationObservedConfig();    }


    public interface ImagePrunerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImagePrunerFluent<OpenShiftControllerManagerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endImagePrunerUnsupportedConfigOverrides();    }


    public interface KubeControllerManagerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeControllerManagerFluent<OpenShiftControllerManagerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endKubeControllerManagerUnsupportedConfigOverrides();    }


    public interface ImageContentSourcePolicyUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageContentSourcePolicyFluent<OpenShiftControllerManagerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endImageContentSourcePolicyUnsupportedConfigOverrides();    }


    public interface ServiceCAUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCAFluent<OpenShiftControllerManagerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endServiceCAUnsupportedConfigOverrides();    }


    public interface PersistentVolumeClaimUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeClaimFluent<OpenShiftControllerManagerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endPersistentVolumeClaimUnsupportedConfigOverrides();    }


    public interface KubeAPIServerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeAPIServerFluent<OpenShiftControllerManagerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endKubeAPIServerUnsupportedConfigOverrides();    }


    public interface IngressControllerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IngressControllerFluent<OpenShiftControllerManagerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endIngressControllerUnsupportedConfigOverrides();    }


    public interface KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeStorageVersionMigratorFluent<OpenShiftControllerManagerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endKubeStorageVersionMigratorUnsupportedConfigOverrides();    }


    public interface ConsoleUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConsoleFluent<OpenShiftControllerManagerSpecFluent.ConsoleUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endConsoleUnsupportedConfigOverrides();    }


    public interface OpenShiftControllerManagerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OpenShiftControllerManagerFluent<OpenShiftControllerManagerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endOpenShiftControllerManagerUnsupportedConfigOverrides();    }


    public interface EtcdUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EtcdFluent<OpenShiftControllerManagerSpecFluent.EtcdUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endEtcdUnsupportedConfigOverrides();    }


    public interface KubeSchedulerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeSchedulerFluent<OpenShiftControllerManagerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endKubeSchedulerUnsupportedConfigOverrides();    }


    public interface NetworkUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetworkFluent<OpenShiftControllerManagerSpecFluent.NetworkUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endNetworkUnsupportedConfigOverrides();    }


    public interface ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCatalogAPIServerFluent<OpenShiftControllerManagerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endServiceCatalogAPIServerUnsupportedConfigOverrides();    }


    public interface CSISnapshotControllerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CSISnapshotControllerFluent<OpenShiftControllerManagerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endCSISnapshotControllerUnsupportedConfigOverrides();    }


    public interface ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCatalogControllerManagerFluent<OpenShiftControllerManagerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endServiceCatalogControllerManagerUnsupportedConfigOverrides();    }


    public interface DNSUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DNSFluent<OpenShiftControllerManagerSpecFluent.DNSUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endDNSUnsupportedConfigOverrides();    }


    public interface DNSRecordUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DNSRecordFluent<OpenShiftControllerManagerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endDNSRecordUnsupportedConfigOverrides();    }


    public interface OpenShiftAPIServerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OpenShiftAPIServerFluent<OpenShiftControllerManagerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endOpenShiftAPIServerUnsupportedConfigOverrides();    }


    public interface AuthenticationUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AuthenticationFluent<OpenShiftControllerManagerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endAuthenticationUnsupportedConfigOverrides();    }


}
