package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KuryrConfigBuilder extends KuryrConfigFluentImpl<KuryrConfigBuilder> implements VisitableBuilder<KuryrConfig,KuryrConfigBuilder> {

    KuryrConfigFluent<?> fluent;
    Boolean validationEnabled;

    public KuryrConfigBuilder() { 
        this(true);
    }


    public KuryrConfigBuilder(Boolean validationEnabled) { 
        this(new KuryrConfig(), validationEnabled);
    }


    public KuryrConfigBuilder(KuryrConfigFluent<?> fluent) { 
        this(fluent, true);
    }


    public KuryrConfigBuilder(KuryrConfigFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new KuryrConfig(), validationEnabled);
    }


    public KuryrConfigBuilder(KuryrConfigFluent<?> fluent,KuryrConfig instance) { 
        this(fluent, instance, true);
    }


    public KuryrConfigBuilder(KuryrConfigFluent<?> fluent,KuryrConfig instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withControllerProbesPort(instance.getControllerProbesPort()); 
        fluent.withDaemonProbesPort(instance.getDaemonProbesPort()); 
        fluent.withEnablePortPoolsPrepopulation(instance.getEnablePortPoolsPrepopulation()); 
        fluent.withOpenStackServiceNetwork(instance.getOpenStackServiceNetwork()); 
        fluent.withPoolBatchPorts(instance.getPoolBatchPorts()); 
        fluent.withPoolMaxPorts(instance.getPoolMaxPorts()); 
        fluent.withPoolMinPorts(instance.getPoolMinPorts()); 
        this.validationEnabled = validationEnabled; 
    }


    public KuryrConfigBuilder(KuryrConfig instance) { 
        this(instance,true);
    }


    public KuryrConfigBuilder(KuryrConfig instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withControllerProbesPort(instance.getControllerProbesPort()); 
        this.withDaemonProbesPort(instance.getDaemonProbesPort()); 
        this.withEnablePortPoolsPrepopulation(instance.getEnablePortPoolsPrepopulation()); 
        this.withOpenStackServiceNetwork(instance.getOpenStackServiceNetwork()); 
        this.withPoolBatchPorts(instance.getPoolBatchPorts()); 
        this.withPoolMaxPorts(instance.getPoolMaxPorts()); 
        this.withPoolMinPorts(instance.getPoolMinPorts()); 
        this.validationEnabled = validationEnabled; 
    }


    public KuryrConfig build() {
        KuryrConfig buildable = new KuryrConfig(fluent.getControllerProbesPort(),fluent.getDaemonProbesPort(),fluent.isEnablePortPoolsPrepopulation(),fluent.getOpenStackServiceNetwork(),fluent.getPoolBatchPorts(),fluent.getPoolMaxPorts(),fluent.getPoolMinPorts());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KuryrConfigBuilder that = (KuryrConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
