package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Object;
import java.util.Map;
import java.lang.Deprecated;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Integer;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder;

public interface KubeSchedulerSpecFluent<A extends KubeSchedulerSpecFluent<A>> extends Fluent<A> {


    public Integer getFailedRevisionLimit();
    public A withFailedRevisionLimit(Integer failedRevisionLimit);
    public Boolean hasFailedRevisionLimit();
    public String getForceRedeploymentReason();
    public A withForceRedeploymentReason(String forceRedeploymentReason);
    public Boolean hasForceRedeploymentReason();
    public A withNewForceRedeploymentReason(String arg1);
    public A withNewForceRedeploymentReason(StringBuilder arg1);
    public A withNewForceRedeploymentReason(StringBuffer arg1);
    public String getLogLevel();
    public A withLogLevel(String logLevel);
    public Boolean hasLogLevel();
    public A withNewLogLevel(String arg1);
    public A withNewLogLevel(StringBuilder arg1);
    public A withNewLogLevel(StringBuffer arg1);
    public String getManagementState();
    public A withManagementState(String managementState);
    public Boolean hasManagementState();
    public A withNewManagementState(String arg1);
    public A withNewManagementState(StringBuilder arg1);
    public A withNewManagementState(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildObservedConfig instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getObservedConfig();
    public HasMetadata buildObservedConfig();
    public A withObservedConfig(HasMetadata observedConfig);
    public Boolean hasObservedConfig();
    public A withImagePrunerObservedConfig(ImagePruner imagePrunerObservedConfig);
    public KubeSchedulerSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfig();
    public KubeSchedulerSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfigLike(ImagePruner item);
    public A withKubeControllerManagerObservedConfig(KubeControllerManager kubeControllerManagerObservedConfig);
    public KubeSchedulerSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfig();
    public KubeSchedulerSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfigLike(KubeControllerManager item);
    public A withImageContentSourcePolicyObservedConfig(ImageContentSourcePolicy imageContentSourcePolicyObservedConfig);
    public KubeSchedulerSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfig();
    public KubeSchedulerSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfigLike(ImageContentSourcePolicy item);
    public A withServiceCAObservedConfig(ServiceCA serviceCAObservedConfig);
    public KubeSchedulerSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfig();
    public KubeSchedulerSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfigLike(ServiceCA item);
    public A withPersistentVolumeClaimObservedConfig(PersistentVolumeClaim persistentVolumeClaimObservedConfig);
    public KubeSchedulerSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfig();
    public KubeSchedulerSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfigLike(PersistentVolumeClaim item);
    public A withKubeAPIServerObservedConfig(KubeAPIServer kubeAPIServerObservedConfig);
    public KubeSchedulerSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfig();
    public KubeSchedulerSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfigLike(KubeAPIServer item);
    public A withIngressControllerObservedConfig(IngressController ingressControllerObservedConfig);
    public KubeSchedulerSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfig();
    public KubeSchedulerSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfigLike(IngressController item);
    public A withKubeStorageVersionMigratorObservedConfig(KubeStorageVersionMigrator kubeStorageVersionMigratorObservedConfig);
    public KubeSchedulerSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfig();
    public KubeSchedulerSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfigLike(KubeStorageVersionMigrator item);
    public A withConsoleObservedConfig(Console consoleObservedConfig);
    public KubeSchedulerSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfig();
    public KubeSchedulerSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfigLike(Console item);
    public A withOpenShiftControllerManagerObservedConfig(OpenShiftControllerManager openShiftControllerManagerObservedConfig);
    public KubeSchedulerSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfig();
    public KubeSchedulerSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfigLike(OpenShiftControllerManager item);
    public A withEtcdObservedConfig(Etcd etcdObservedConfig);
    public KubeSchedulerSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfig();
    public KubeSchedulerSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfigLike(Etcd item);
    public A withKubeSchedulerObservedConfig(KubeScheduler kubeSchedulerObservedConfig);
    public KubeSchedulerSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfig();
    public KubeSchedulerSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfigLike(KubeScheduler item);
    public A withNetworkObservedConfig(Network networkObservedConfig);
    public KubeSchedulerSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfig();
    public KubeSchedulerSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfigLike(Network item);
    public A withServiceCatalogAPIServerObservedConfig(ServiceCatalogAPIServer serviceCatalogAPIServerObservedConfig);
    public KubeSchedulerSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfig();
    public KubeSchedulerSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfigLike(ServiceCatalogAPIServer item);
    public A withCSISnapshotControllerObservedConfig(CSISnapshotController cSISnapshotControllerObservedConfig);
    public KubeSchedulerSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfig();
    public KubeSchedulerSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfigLike(CSISnapshotController item);
    public A withServiceCatalogControllerManagerObservedConfig(ServiceCatalogControllerManager serviceCatalogControllerManagerObservedConfig);
    public KubeSchedulerSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfig();
    public KubeSchedulerSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfigLike(ServiceCatalogControllerManager item);
    public A withDNSObservedConfig(DNS dNSObservedConfig);
    public KubeSchedulerSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfig();
    public KubeSchedulerSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfigLike(DNS item);
    public A withDNSRecordObservedConfig(DNSRecord dNSRecordObservedConfig);
    public KubeSchedulerSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfig();
    public KubeSchedulerSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfigLike(DNSRecord item);
    public A withOpenShiftAPIServerObservedConfig(OpenShiftAPIServer openShiftAPIServerObservedConfig);
    public KubeSchedulerSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfig();
    public KubeSchedulerSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfigLike(OpenShiftAPIServer item);
    public A withAuthenticationObservedConfig(Authentication authenticationObservedConfig);
    public KubeSchedulerSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfig();
    public KubeSchedulerSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfigLike(Authentication item);
    public String getOperatorLogLevel();
    public A withOperatorLogLevel(String operatorLogLevel);
    public Boolean hasOperatorLogLevel();
    public A withNewOperatorLogLevel(String arg1);
    public A withNewOperatorLogLevel(StringBuilder arg1);
    public A withNewOperatorLogLevel(StringBuffer arg1);
    public Integer getSucceededRevisionLimit();
    public A withSucceededRevisionLimit(Integer succeededRevisionLimit);
    public Boolean hasSucceededRevisionLimit();
    
/**
 * This method has been deprecated, please use method buildUnsupportedConfigOverrides instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getUnsupportedConfigOverrides();
    public HasMetadata buildUnsupportedConfigOverrides();
    public A withUnsupportedConfigOverrides(HasMetadata unsupportedConfigOverrides);
    public Boolean hasUnsupportedConfigOverrides();
    public A withImagePrunerUnsupportedConfigOverrides(ImagePruner imagePrunerUnsupportedConfigOverrides);
    public KubeSchedulerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverrides();
    public KubeSchedulerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverridesLike(ImagePruner item);
    public A withKubeControllerManagerUnsupportedConfigOverrides(KubeControllerManager kubeControllerManagerUnsupportedConfigOverrides);
    public KubeSchedulerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverrides();
    public KubeSchedulerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverridesLike(KubeControllerManager item);
    public A withImageContentSourcePolicyUnsupportedConfigOverrides(ImageContentSourcePolicy imageContentSourcePolicyUnsupportedConfigOverrides);
    public KubeSchedulerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverrides();
    public KubeSchedulerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverridesLike(ImageContentSourcePolicy item);
    public A withServiceCAUnsupportedConfigOverrides(ServiceCA serviceCAUnsupportedConfigOverrides);
    public KubeSchedulerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverrides();
    public KubeSchedulerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverridesLike(ServiceCA item);
    public A withPersistentVolumeClaimUnsupportedConfigOverrides(PersistentVolumeClaim persistentVolumeClaimUnsupportedConfigOverrides);
    public KubeSchedulerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverrides();
    public KubeSchedulerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverridesLike(PersistentVolumeClaim item);
    public A withKubeAPIServerUnsupportedConfigOverrides(KubeAPIServer kubeAPIServerUnsupportedConfigOverrides);
    public KubeSchedulerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverrides();
    public KubeSchedulerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverridesLike(KubeAPIServer item);
    public A withIngressControllerUnsupportedConfigOverrides(IngressController ingressControllerUnsupportedConfigOverrides);
    public KubeSchedulerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverrides();
    public KubeSchedulerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverridesLike(IngressController item);
    public A withKubeStorageVersionMigratorUnsupportedConfigOverrides(KubeStorageVersionMigrator kubeStorageVersionMigratorUnsupportedConfigOverrides);
    public KubeSchedulerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverrides();
    public KubeSchedulerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverridesLike(KubeStorageVersionMigrator item);
    public A withConsoleUnsupportedConfigOverrides(Console consoleUnsupportedConfigOverrides);
    public KubeSchedulerSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverrides();
    public KubeSchedulerSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverridesLike(Console item);
    public A withOpenShiftControllerManagerUnsupportedConfigOverrides(OpenShiftControllerManager openShiftControllerManagerUnsupportedConfigOverrides);
    public KubeSchedulerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverrides();
    public KubeSchedulerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverridesLike(OpenShiftControllerManager item);
    public A withEtcdUnsupportedConfigOverrides(Etcd etcdUnsupportedConfigOverrides);
    public KubeSchedulerSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverrides();
    public KubeSchedulerSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverridesLike(Etcd item);
    public A withKubeSchedulerUnsupportedConfigOverrides(KubeScheduler kubeSchedulerUnsupportedConfigOverrides);
    public KubeSchedulerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverrides();
    public KubeSchedulerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverridesLike(KubeScheduler item);
    public A withNetworkUnsupportedConfigOverrides(Network networkUnsupportedConfigOverrides);
    public KubeSchedulerSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverrides();
    public KubeSchedulerSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverridesLike(Network item);
    public A withServiceCatalogAPIServerUnsupportedConfigOverrides(ServiceCatalogAPIServer serviceCatalogAPIServerUnsupportedConfigOverrides);
    public KubeSchedulerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverrides();
    public KubeSchedulerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverridesLike(ServiceCatalogAPIServer item);
    public A withCSISnapshotControllerUnsupportedConfigOverrides(CSISnapshotController cSISnapshotControllerUnsupportedConfigOverrides);
    public KubeSchedulerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverrides();
    public KubeSchedulerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverridesLike(CSISnapshotController item);
    public A withServiceCatalogControllerManagerUnsupportedConfigOverrides(ServiceCatalogControllerManager serviceCatalogControllerManagerUnsupportedConfigOverrides);
    public KubeSchedulerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverrides();
    public KubeSchedulerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverridesLike(ServiceCatalogControllerManager item);
    public A withDNSUnsupportedConfigOverrides(DNS dNSUnsupportedConfigOverrides);
    public KubeSchedulerSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverrides();
    public KubeSchedulerSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverridesLike(DNS item);
    public A withDNSRecordUnsupportedConfigOverrides(DNSRecord dNSRecordUnsupportedConfigOverrides);
    public KubeSchedulerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverrides();
    public KubeSchedulerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverridesLike(DNSRecord item);
    public A withOpenShiftAPIServerUnsupportedConfigOverrides(OpenShiftAPIServer openShiftAPIServerUnsupportedConfigOverrides);
    public KubeSchedulerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverrides();
    public KubeSchedulerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverridesLike(OpenShiftAPIServer item);
    public A withAuthenticationUnsupportedConfigOverrides(Authentication authenticationUnsupportedConfigOverrides);
    public KubeSchedulerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverrides();
    public KubeSchedulerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverridesLike(Authentication item);
    public interface ImagePrunerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImagePrunerFluent<KubeSchedulerSpecFluent.ImagePrunerObservedConfigNested<N>> {

        public N and();
        public N endImagePrunerObservedConfig();    }


    public interface KubeControllerManagerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeControllerManagerFluent<KubeSchedulerSpecFluent.KubeControllerManagerObservedConfigNested<N>> {

        public N and();
        public N endKubeControllerManagerObservedConfig();    }


    public interface ImageContentSourcePolicyObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageContentSourcePolicyFluent<KubeSchedulerSpecFluent.ImageContentSourcePolicyObservedConfigNested<N>> {

        public N and();
        public N endImageContentSourcePolicyObservedConfig();    }


    public interface ServiceCAObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCAFluent<KubeSchedulerSpecFluent.ServiceCAObservedConfigNested<N>> {

        public N and();
        public N endServiceCAObservedConfig();    }


    public interface PersistentVolumeClaimObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeClaimFluent<KubeSchedulerSpecFluent.PersistentVolumeClaimObservedConfigNested<N>> {

        public N and();
        public N endPersistentVolumeClaimObservedConfig();    }


    public interface KubeAPIServerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeAPIServerFluent<KubeSchedulerSpecFluent.KubeAPIServerObservedConfigNested<N>> {

        public N and();
        public N endKubeAPIServerObservedConfig();    }


    public interface IngressControllerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IngressControllerFluent<KubeSchedulerSpecFluent.IngressControllerObservedConfigNested<N>> {

        public N and();
        public N endIngressControllerObservedConfig();    }


    public interface KubeStorageVersionMigratorObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeStorageVersionMigratorFluent<KubeSchedulerSpecFluent.KubeStorageVersionMigratorObservedConfigNested<N>> {

        public N and();
        public N endKubeStorageVersionMigratorObservedConfig();    }


    public interface ConsoleObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConsoleFluent<KubeSchedulerSpecFluent.ConsoleObservedConfigNested<N>> {

        public N and();
        public N endConsoleObservedConfig();    }


    public interface OpenShiftControllerManagerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OpenShiftControllerManagerFluent<KubeSchedulerSpecFluent.OpenShiftControllerManagerObservedConfigNested<N>> {

        public N and();
        public N endOpenShiftControllerManagerObservedConfig();    }


    public interface EtcdObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EtcdFluent<KubeSchedulerSpecFluent.EtcdObservedConfigNested<N>> {

        public N and();
        public N endEtcdObservedConfig();    }


    public interface KubeSchedulerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeSchedulerFluent<KubeSchedulerSpecFluent.KubeSchedulerObservedConfigNested<N>> {

        public N and();
        public N endKubeSchedulerObservedConfig();    }


    public interface NetworkObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetworkFluent<KubeSchedulerSpecFluent.NetworkObservedConfigNested<N>> {

        public N and();
        public N endNetworkObservedConfig();    }


    public interface ServiceCatalogAPIServerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCatalogAPIServerFluent<KubeSchedulerSpecFluent.ServiceCatalogAPIServerObservedConfigNested<N>> {

        public N and();
        public N endServiceCatalogAPIServerObservedConfig();    }


    public interface CSISnapshotControllerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CSISnapshotControllerFluent<KubeSchedulerSpecFluent.CSISnapshotControllerObservedConfigNested<N>> {

        public N and();
        public N endCSISnapshotControllerObservedConfig();    }


    public interface ServiceCatalogControllerManagerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCatalogControllerManagerFluent<KubeSchedulerSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<N>> {

        public N and();
        public N endServiceCatalogControllerManagerObservedConfig();    }


    public interface DNSObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DNSFluent<KubeSchedulerSpecFluent.DNSObservedConfigNested<N>> {

        public N and();
        public N endDNSObservedConfig();    }


    public interface DNSRecordObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DNSRecordFluent<KubeSchedulerSpecFluent.DNSRecordObservedConfigNested<N>> {

        public N and();
        public N endDNSRecordObservedConfig();    }


    public interface OpenShiftAPIServerObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OpenShiftAPIServerFluent<KubeSchedulerSpecFluent.OpenShiftAPIServerObservedConfigNested<N>> {

        public N and();
        public N endOpenShiftAPIServerObservedConfig();    }


    public interface AuthenticationObservedConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AuthenticationFluent<KubeSchedulerSpecFluent.AuthenticationObservedConfigNested<N>> {

        public N and();
        public N endAuthenticationObservedConfig();    }


    public interface ImagePrunerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImagePrunerFluent<KubeSchedulerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endImagePrunerUnsupportedConfigOverrides();    }


    public interface KubeControllerManagerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeControllerManagerFluent<KubeSchedulerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endKubeControllerManagerUnsupportedConfigOverrides();    }


    public interface ImageContentSourcePolicyUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageContentSourcePolicyFluent<KubeSchedulerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endImageContentSourcePolicyUnsupportedConfigOverrides();    }


    public interface ServiceCAUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCAFluent<KubeSchedulerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endServiceCAUnsupportedConfigOverrides();    }


    public interface PersistentVolumeClaimUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeClaimFluent<KubeSchedulerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endPersistentVolumeClaimUnsupportedConfigOverrides();    }


    public interface KubeAPIServerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeAPIServerFluent<KubeSchedulerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endKubeAPIServerUnsupportedConfigOverrides();    }


    public interface IngressControllerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IngressControllerFluent<KubeSchedulerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endIngressControllerUnsupportedConfigOverrides();    }


    public interface KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeStorageVersionMigratorFluent<KubeSchedulerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endKubeStorageVersionMigratorUnsupportedConfigOverrides();    }


    public interface ConsoleUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConsoleFluent<KubeSchedulerSpecFluent.ConsoleUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endConsoleUnsupportedConfigOverrides();    }


    public interface OpenShiftControllerManagerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OpenShiftControllerManagerFluent<KubeSchedulerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endOpenShiftControllerManagerUnsupportedConfigOverrides();    }


    public interface EtcdUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EtcdFluent<KubeSchedulerSpecFluent.EtcdUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endEtcdUnsupportedConfigOverrides();    }


    public interface KubeSchedulerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeSchedulerFluent<KubeSchedulerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endKubeSchedulerUnsupportedConfigOverrides();    }


    public interface NetworkUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetworkFluent<KubeSchedulerSpecFluent.NetworkUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endNetworkUnsupportedConfigOverrides();    }


    public interface ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCatalogAPIServerFluent<KubeSchedulerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endServiceCatalogAPIServerUnsupportedConfigOverrides();    }


    public interface CSISnapshotControllerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CSISnapshotControllerFluent<KubeSchedulerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endCSISnapshotControllerUnsupportedConfigOverrides();    }


    public interface ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ServiceCatalogControllerManagerFluent<KubeSchedulerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endServiceCatalogControllerManagerUnsupportedConfigOverrides();    }


    public interface DNSUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DNSFluent<KubeSchedulerSpecFluent.DNSUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endDNSUnsupportedConfigOverrides();    }


    public interface DNSRecordUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DNSRecordFluent<KubeSchedulerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endDNSRecordUnsupportedConfigOverrides();    }


    public interface OpenShiftAPIServerUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OpenShiftAPIServerFluent<KubeSchedulerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endOpenShiftAPIServerUnsupportedConfigOverrides();    }


    public interface AuthenticationUnsupportedConfigOverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AuthenticationFluent<KubeSchedulerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<N>> {

        public N and();
        public N endAuthenticationUnsupportedConfigOverrides();    }


}
