package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubeControllerManagerSpecBuilder extends KubeControllerManagerSpecFluentImpl<KubeControllerManagerSpecBuilder> implements VisitableBuilder<KubeControllerManagerSpec,KubeControllerManagerSpecBuilder> {

    KubeControllerManagerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KubeControllerManagerSpecBuilder() { 
        this(true);
    }


    public KubeControllerManagerSpecBuilder(Boolean validationEnabled) { 
        this(new KubeControllerManagerSpec(), validationEnabled);
    }


    public KubeControllerManagerSpecBuilder(KubeControllerManagerSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public KubeControllerManagerSpecBuilder(KubeControllerManagerSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new KubeControllerManagerSpec(), validationEnabled);
    }


    public KubeControllerManagerSpecBuilder(KubeControllerManagerSpecFluent<?> fluent,KubeControllerManagerSpec instance) { 
        this(fluent, instance, true);
    }


    public KubeControllerManagerSpecBuilder(KubeControllerManagerSpecFluent<?> fluent,KubeControllerManagerSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withFailedRevisionLimit(instance.getFailedRevisionLimit()); 
        fluent.withForceRedeploymentReason(instance.getForceRedeploymentReason()); 
        fluent.withLogLevel(instance.getLogLevel()); 
        fluent.withManagementState(instance.getManagementState()); 
        fluent.withObservedConfig(instance.getObservedConfig()); 
        fluent.withOperatorLogLevel(instance.getOperatorLogLevel()); 
        fluent.withSucceededRevisionLimit(instance.getSucceededRevisionLimit()); 
        fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
        this.validationEnabled = validationEnabled; 
    }


    public KubeControllerManagerSpecBuilder(KubeControllerManagerSpec instance) { 
        this(instance,true);
    }


    public KubeControllerManagerSpecBuilder(KubeControllerManagerSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withFailedRevisionLimit(instance.getFailedRevisionLimit()); 
        this.withForceRedeploymentReason(instance.getForceRedeploymentReason()); 
        this.withLogLevel(instance.getLogLevel()); 
        this.withManagementState(instance.getManagementState()); 
        this.withObservedConfig(instance.getObservedConfig()); 
        this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
        this.withSucceededRevisionLimit(instance.getSucceededRevisionLimit()); 
        this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
        this.validationEnabled = validationEnabled; 
    }


    public KubeControllerManagerSpec build() {
        KubeControllerManagerSpec buildable = new KubeControllerManagerSpec(fluent.getFailedRevisionLimit(),fluent.getForceRedeploymentReason(),fluent.getLogLevel(),fluent.getManagementState(),fluent.getObservedConfig(),fluent.getOperatorLogLevel(),fluent.getSucceededRevisionLimit(),fluent.getUnsupportedConfigOverrides());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KubeControllerManagerSpecBuilder that = (KubeControllerManagerSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
