package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface KubeAPIServerListFluent<A extends KubeAPIServerListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,KubeAPIServer item);
    public A setToItems(int index,KubeAPIServer item);
    public A addToItems(KubeAPIServer... items);
    public A addAllToItems(Collection<KubeAPIServer> items);
    public A removeFromItems(KubeAPIServer... items);
    public A removeAllFromItems(Collection<KubeAPIServer> items);
    public A removeMatchingFromItems(Predicate<KubeAPIServerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<KubeAPIServer> getItems();
    public List<KubeAPIServer> buildItems();
    public KubeAPIServer buildItem(int index);
    public KubeAPIServer buildFirstItem();
    public KubeAPIServer buildLastItem();
    public KubeAPIServer buildMatchingItem(Predicate<KubeAPIServerBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<KubeAPIServerBuilder> predicate);
    public A withItems(List<KubeAPIServer> items);
    public A withItems(KubeAPIServer... items);
    public Boolean hasItems();
    public KubeAPIServerListFluent.ItemsNested<A> addNewItem();
    public KubeAPIServerListFluent.ItemsNested<A> addNewItemLike(KubeAPIServer item);
    public KubeAPIServerListFluent.ItemsNested<A> setNewItemLike(int index,KubeAPIServer item);
    public KubeAPIServerListFluent.ItemsNested<A> editItem(int index);
    public KubeAPIServerListFluent.ItemsNested<A> editFirstItem();
    public KubeAPIServerListFluent.ItemsNested<A> editLastItem();
    public KubeAPIServerListFluent.ItemsNested<A> editMatchingItem(Predicate<KubeAPIServerBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeAPIServerFluent<KubeAPIServerListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
