
package io.fabric8.openshift.api.model.operator.v1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.openshift.api.model.TLSProfileSpec;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "availableReplicas",
    "conditions",
    "domain",
    "endpointPublishingStrategy",
    "observedGeneration",
    "selector",
    "tlsProfile"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class IngressControllerStatus implements KubernetesResource
{

    /**
     * 
     */
    @JsonProperty("availableReplicas")
    @JsonPropertyDescription("")
    private Integer availableReplicas;
    /**
     * 
     */
    @JsonProperty("conditions")
    @JsonPropertyDescription("")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<OperatorCondition> conditions = new ArrayList<OperatorCondition>();
    /**
     * 
     */
    @JsonProperty("domain")
    @JsonPropertyDescription("")
    private String domain;
    /**
     * 
     */
    @JsonProperty("endpointPublishingStrategy")
    @JsonPropertyDescription("")
    private EndpointPublishingStrategy endpointPublishingStrategy;
    /**
     * 
     */
    @JsonProperty("observedGeneration")
    @JsonPropertyDescription("")
    private Long observedGeneration;
    /**
     * 
     */
    @JsonProperty("selector")
    @JsonPropertyDescription("")
    private String selector;
    /**
     * 
     */
    @JsonProperty("tlsProfile")
    @JsonPropertyDescription("")
    private TLSProfileSpec tlsProfile;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public IngressControllerStatus() {
    }

    /**
     * 
     * @param domain
     * @param endpointPublishingStrategy
     * @param selector
     * @param tlsProfile
     * @param conditions
     * @param availableReplicas
     * @param observedGeneration
     */
    public IngressControllerStatus(Integer availableReplicas, List<OperatorCondition> conditions, String domain, EndpointPublishingStrategy endpointPublishingStrategy, Long observedGeneration, String selector, TLSProfileSpec tlsProfile) {
        super();
        this.availableReplicas = availableReplicas;
        this.conditions = conditions;
        this.domain = domain;
        this.endpointPublishingStrategy = endpointPublishingStrategy;
        this.observedGeneration = observedGeneration;
        this.selector = selector;
        this.tlsProfile = tlsProfile;
    }

    /**
     * 
     */
    @JsonProperty("availableReplicas")
    public Integer getAvailableReplicas() {
        return availableReplicas;
    }

    /**
     * 
     */
    @JsonProperty("availableReplicas")
    public void setAvailableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
    }

    /**
     * 
     */
    @JsonProperty("conditions")
    public List<OperatorCondition> getConditions() {
        return conditions;
    }

    /**
     * 
     */
    @JsonProperty("conditions")
    public void setConditions(List<OperatorCondition> conditions) {
        this.conditions = conditions;
    }

    /**
     * 
     */
    @JsonProperty("domain")
    public String getDomain() {
        return domain;
    }

    /**
     * 
     */
    @JsonProperty("domain")
    public void setDomain(String domain) {
        this.domain = domain;
    }

    /**
     * 
     */
    @JsonProperty("endpointPublishingStrategy")
    public EndpointPublishingStrategy getEndpointPublishingStrategy() {
        return endpointPublishingStrategy;
    }

    /**
     * 
     */
    @JsonProperty("endpointPublishingStrategy")
    public void setEndpointPublishingStrategy(EndpointPublishingStrategy endpointPublishingStrategy) {
        this.endpointPublishingStrategy = endpointPublishingStrategy;
    }

    /**
     * 
     */
    @JsonProperty("observedGeneration")
    public Long getObservedGeneration() {
        return observedGeneration;
    }

    /**
     * 
     */
    @JsonProperty("observedGeneration")
    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    /**
     * 
     */
    @JsonProperty("selector")
    public String getSelector() {
        return selector;
    }

    /**
     * 
     */
    @JsonProperty("selector")
    public void setSelector(String selector) {
        this.selector = selector;
    }

    /**
     * 
     */
    @JsonProperty("tlsProfile")
    public TLSProfileSpec getTlsProfile() {
        return tlsProfile;
    }

    /**
     * 
     */
    @JsonProperty("tlsProfile")
    public void setTlsProfile(TLSProfileSpec tlsProfile) {
        this.tlsProfile = tlsProfile;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
