package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Object;
import java.util.Map;

public interface IngressControllerFluent<A extends IngressControllerFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public IngressControllerFluent.MetadataNested<A> withNewMetadata();
    public IngressControllerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public IngressControllerFluent.MetadataNested<A> editMetadata();
    public IngressControllerFluent.MetadataNested<A> editOrNewMetadata();
    public IngressControllerFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public IngressControllerSpec getSpec();
    public IngressControllerSpec buildSpec();
    public A withSpec(IngressControllerSpec spec);
    public Boolean hasSpec();
    public IngressControllerFluent.SpecNested<A> withNewSpec();
    public IngressControllerFluent.SpecNested<A> withNewSpecLike(IngressControllerSpec item);
    public IngressControllerFluent.SpecNested<A> editSpec();
    public IngressControllerFluent.SpecNested<A> editOrNewSpec();
    public IngressControllerFluent.SpecNested<A> editOrNewSpecLike(IngressControllerSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public IngressControllerStatus getStatus();
    public IngressControllerStatus buildStatus();
    public A withStatus(IngressControllerStatus status);
    public Boolean hasStatus();
    public IngressControllerFluent.StatusNested<A> withNewStatus();
    public IngressControllerFluent.StatusNested<A> withNewStatusLike(IngressControllerStatus item);
    public IngressControllerFluent.StatusNested<A> editStatus();
    public IngressControllerFluent.StatusNested<A> editOrNewStatus();
    public IngressControllerFluent.StatusNested<A> editOrNewStatusLike(IngressControllerStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<IngressControllerFluent.MetadataNested<N>> {

        public N and();
        public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IngressControllerSpecFluent<IngressControllerFluent.SpecNested<N>> {

        public N and();
        public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IngressControllerStatusFluent<IngressControllerFluent.StatusNested<N>> {

        public N and();
        public N endStatus();    }


}
