package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class HybridOverlayConfigFluentImpl<A extends HybridOverlayConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements HybridOverlayConfigFluent<A> {

    private List<ClusterNetworkEntryBuilder> hybridClusterNetwork =  new ArrayList<ClusterNetworkEntryBuilder>();
    private Integer hybridOverlayVXLANPort;

    public HybridOverlayConfigFluentImpl() { 
    }


    public HybridOverlayConfigFluentImpl(HybridOverlayConfig instance) { 
        this.withHybridClusterNetwork(instance.getHybridClusterNetwork()); 
        this.withHybridOverlayVXLANPort(instance.getHybridOverlayVXLANPort()); 
    }


    public A addToHybridClusterNetwork(int index,ClusterNetworkEntry item) {
        if (this.hybridClusterNetwork == null) {this.hybridClusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("hybridClusterNetwork").add(index >= 0 ? index : _visitables.get("hybridClusterNetwork").size(), builder);this.hybridClusterNetwork.add(index >= 0 ? index : hybridClusterNetwork.size(), builder); return (A)this;
    }

    public A setToHybridClusterNetwork(int index,ClusterNetworkEntry item) {
        if (this.hybridClusterNetwork == null) {this.hybridClusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= _visitables.get("hybridClusterNetwork").size()) { _visitables.get("hybridClusterNetwork").add(builder); } else { _visitables.get("hybridClusterNetwork").set(index, builder);}
        if (index < 0 || index >= hybridClusterNetwork.size()) { hybridClusterNetwork.add(builder); } else { hybridClusterNetwork.set(index, builder);}
         return (A)this;
    }

    public A addToHybridClusterNetwork(ClusterNetworkEntry... items) {
        if (this.hybridClusterNetwork == null) {this.hybridClusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
        for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("hybridClusterNetwork").add(builder);this.hybridClusterNetwork.add(builder);} return (A)this;
    }

    public A addAllToHybridClusterNetwork(Collection<ClusterNetworkEntry> items) {
        if (this.hybridClusterNetwork == null) {this.hybridClusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
        for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("hybridClusterNetwork").add(builder);this.hybridClusterNetwork.add(builder);} return (A)this;
    }

    public A removeFromHybridClusterNetwork(ClusterNetworkEntry... items) {
        for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("hybridClusterNetwork").remove(builder);if (this.hybridClusterNetwork != null) {this.hybridClusterNetwork.remove(builder);}} return (A)this;
    }

    public A removeAllFromHybridClusterNetwork(Collection<ClusterNetworkEntry> items) {
        for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("hybridClusterNetwork").remove(builder);if (this.hybridClusterNetwork != null) {this.hybridClusterNetwork.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromHybridClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        if (hybridClusterNetwork == null) return (A) this;
        final Iterator<ClusterNetworkEntryBuilder> each = hybridClusterNetwork.iterator();
        final List visitables = _visitables.get("hybridClusterNetwork");
        while (each.hasNext()) {
          ClusterNetworkEntryBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildHybridClusterNetwork instead.
 * @return The buildable object.
 */
@Deprecated public List<ClusterNetworkEntry> getHybridClusterNetwork() {
        return build(hybridClusterNetwork);
    }

    public List<ClusterNetworkEntry> buildHybridClusterNetwork() {
        return build(hybridClusterNetwork);
    }

    public ClusterNetworkEntry buildHybridClusterNetwork(int index) {
        return this.hybridClusterNetwork.get(index).build();
    }

    public ClusterNetworkEntry buildFirstHybridClusterNetwork() {
        return this.hybridClusterNetwork.get(0).build();
    }

    public ClusterNetworkEntry buildLastHybridClusterNetwork() {
        return this.hybridClusterNetwork.get(hybridClusterNetwork.size() - 1).build();
    }

    public ClusterNetworkEntry buildMatchingHybridClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item: hybridClusterNetwork) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingHybridClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item: hybridClusterNetwork) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withHybridClusterNetwork(List<ClusterNetworkEntry> hybridClusterNetwork) {
        if (this.hybridClusterNetwork != null) { _visitables.get("hybridClusterNetwork").removeAll(this.hybridClusterNetwork);}
        if (hybridClusterNetwork != null) {this.hybridClusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>(); for (ClusterNetworkEntry item : hybridClusterNetwork){this.addToHybridClusterNetwork(item);}} else { this.hybridClusterNetwork = null;} return (A) this;
    }

    public A withHybridClusterNetwork(ClusterNetworkEntry... hybridClusterNetwork) {
        if (this.hybridClusterNetwork != null) {this.hybridClusterNetwork.clear();}
        if (hybridClusterNetwork != null) {for (ClusterNetworkEntry item :hybridClusterNetwork){ this.addToHybridClusterNetwork(item);}} return (A) this;
    }

    public Boolean hasHybridClusterNetwork() {
        return hybridClusterNetwork != null && !hybridClusterNetwork.isEmpty();
    }

    public A addNewHybridClusterNetwork(String cidr,Integer hostPrefix) {
        return (A)addToHybridClusterNetwork(new ClusterNetworkEntry(cidr, hostPrefix));
    }

    public HybridOverlayConfigFluent.HybridClusterNetworkNested<A> addNewHybridClusterNetwork() {
        return new HybridClusterNetworkNestedImpl();
    }

    public HybridOverlayConfigFluent.HybridClusterNetworkNested<A> addNewHybridClusterNetworkLike(ClusterNetworkEntry item) {
        return new HybridClusterNetworkNestedImpl(-1, item);
    }

    public HybridOverlayConfigFluent.HybridClusterNetworkNested<A> setNewHybridClusterNetworkLike(int index,ClusterNetworkEntry item) {
        return new HybridClusterNetworkNestedImpl(index, item);
    }

    public HybridOverlayConfigFluent.HybridClusterNetworkNested<A> editHybridClusterNetwork(int index) {
        if (hybridClusterNetwork.size() <= index) throw new RuntimeException("Can't edit hybridClusterNetwork. Index exceeds size.");
        return setNewHybridClusterNetworkLike(index, buildHybridClusterNetwork(index));
    }

    public HybridOverlayConfigFluent.HybridClusterNetworkNested<A> editFirstHybridClusterNetwork() {
        if (hybridClusterNetwork.size() == 0) throw new RuntimeException("Can't edit first hybridClusterNetwork. The list is empty.");
        return setNewHybridClusterNetworkLike(0, buildHybridClusterNetwork(0));
    }

    public HybridOverlayConfigFluent.HybridClusterNetworkNested<A> editLastHybridClusterNetwork() {
        int index = hybridClusterNetwork.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last hybridClusterNetwork. The list is empty.");
        return setNewHybridClusterNetworkLike(index, buildHybridClusterNetwork(index));
    }

    public HybridOverlayConfigFluent.HybridClusterNetworkNested<A> editMatchingHybridClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        int index = -1;
        for (int i=0;i<hybridClusterNetwork.size();i++) { 
        if (predicate.test(hybridClusterNetwork.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching hybridClusterNetwork. No match found.");
        return setNewHybridClusterNetworkLike(index, buildHybridClusterNetwork(index));
    }

    public Integer getHybridOverlayVXLANPort() {
        return this.hybridOverlayVXLANPort;
    }

    public A withHybridOverlayVXLANPort(Integer hybridOverlayVXLANPort) {
        this.hybridOverlayVXLANPort=hybridOverlayVXLANPort; return (A) this;
    }

    public Boolean hasHybridOverlayVXLANPort() {
        return this.hybridOverlayVXLANPort != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        HybridOverlayConfigFluentImpl that = (HybridOverlayConfigFluentImpl) o;
        if (hybridClusterNetwork != null ? !hybridClusterNetwork.equals(that.hybridClusterNetwork) :that.hybridClusterNetwork != null) return false;
        if (hybridOverlayVXLANPort != null ? !hybridOverlayVXLANPort.equals(that.hybridOverlayVXLANPort) :that.hybridOverlayVXLANPort != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(hybridClusterNetwork,  hybridOverlayVXLANPort,  super.hashCode());
    }

    public class HybridClusterNetworkNestedImpl<N> extends ClusterNetworkEntryFluentImpl<HybridOverlayConfigFluent.HybridClusterNetworkNested<N>> implements HybridOverlayConfigFluent.HybridClusterNetworkNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ClusterNetworkEntryBuilder builder;
        private final int index;

        HybridClusterNetworkNestedImpl(int index,ClusterNetworkEntry item) {
            this.index = index;
            this.builder = new ClusterNetworkEntryBuilder(this, item);
        }

        HybridClusterNetworkNestedImpl() {
            this.index = -1;
            this.builder = new ClusterNetworkEntryBuilder(this);
        }

        public N and() {
             return (N) HybridOverlayConfigFluentImpl.this.setToHybridClusterNetwork(index,builder.build());
        }

        public N endHybridClusterNetwork() {
             return and();
        }
    }


}
