package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface EtcdListFluent<A extends EtcdListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Etcd item);
    public A setToItems(int index,Etcd item);
    public A addToItems(Etcd... items);
    public A addAllToItems(Collection<Etcd> items);
    public A removeFromItems(Etcd... items);
    public A removeAllFromItems(Collection<Etcd> items);
    public A removeMatchingFromItems(Predicate<EtcdBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Etcd> getItems();
    public List<Etcd> buildItems();
    public Etcd buildItem(int index);
    public Etcd buildFirstItem();
    public Etcd buildLastItem();
    public Etcd buildMatchingItem(Predicate<EtcdBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<EtcdBuilder> predicate);
    public A withItems(List<Etcd> items);
    public A withItems(Etcd... items);
    public Boolean hasItems();
    public EtcdListFluent.ItemsNested<A> addNewItem();
    public EtcdListFluent.ItemsNested<A> addNewItemLike(Etcd item);
    public EtcdListFluent.ItemsNested<A> setNewItemLike(int index,Etcd item);
    public EtcdListFluent.ItemsNested<A> editItem(int index);
    public EtcdListFluent.ItemsNested<A> editFirstItem();
    public EtcdListFluent.ItemsNested<A> editLastItem();
    public EtcdListFluent.ItemsNested<A> editMatchingItem(Predicate<EtcdBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EtcdFluent<EtcdListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
