package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class SecretNameReferenceFluentImpl<A extends SecretNameReferenceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SecretNameReferenceFluent<A> {

    private String name;

    public SecretNameReferenceFluentImpl() { 
    }


    public SecretNameReferenceFluentImpl(SecretNameReference instance) { 
        this.withName(instance.getName()); 
    }


    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SecretNameReferenceFluentImpl that = (SecretNameReferenceFluentImpl) o;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(name,  super.hashCode());
    }

}
