
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.version.Info;
import io.fabric8.openshift.api.model.ConfigMapFileReference;
import io.fabric8.openshift.api.model.SecretNameReference;
import io.fabric8.openshift.api.model.operator.v1.Authentication;
import io.fabric8.openshift.api.model.operator.v1.AuthenticationList;
import io.fabric8.openshift.api.model.operator.v1.CSISnapshotController;
import io.fabric8.openshift.api.model.operator.v1.CSISnapshotControllerList;
import io.fabric8.openshift.api.model.operator.v1.Console;
import io.fabric8.openshift.api.model.operator.v1.ConsoleList;
import io.fabric8.openshift.api.model.operator.v1.DNS;
import io.fabric8.openshift.api.model.operator.v1.DNSList;
import io.fabric8.openshift.api.model.operator.v1.DNSRecord;
import io.fabric8.openshift.api.model.operator.v1.DNSRecordList;
import io.fabric8.openshift.api.model.operator.v1.Etcd;
import io.fabric8.openshift.api.model.operator.v1.EtcdList;
import io.fabric8.openshift.api.model.operator.v1.ImagePruner;
import io.fabric8.openshift.api.model.operator.v1.ImagePrunerList;
import io.fabric8.openshift.api.model.operator.v1.IngressController;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerList;
import io.fabric8.openshift.api.model.operator.v1.KubeAPIServer;
import io.fabric8.openshift.api.model.operator.v1.KubeAPIServerList;
import io.fabric8.openshift.api.model.operator.v1.KubeControllerManager;
import io.fabric8.openshift.api.model.operator.v1.KubeControllerManagerList;
import io.fabric8.openshift.api.model.operator.v1.KubeScheduler;
import io.fabric8.openshift.api.model.operator.v1.KubeSchedulerList;
import io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigrator;
import io.fabric8.openshift.api.model.operator.v1.KubeStorageVersionMigratorList;
import io.fabric8.openshift.api.model.operator.v1.Network;
import io.fabric8.openshift.api.model.operator.v1.NetworkList;
import io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServer;
import io.fabric8.openshift.api.model.operator.v1.OpenShiftAPIServerList;
import io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManager;
import io.fabric8.openshift.api.model.operator.v1.OpenShiftControllerManagerList;
import io.fabric8.openshift.api.model.operator.v1.ServiceCA;
import io.fabric8.openshift.api.model.operator.v1.ServiceCAList;
import io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServer;
import io.fabric8.openshift.api.model.operator.v1.ServiceCatalogAPIServerList;
import io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManager;
import io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerList;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyList;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "APIGroup",
    "APIGroupList",
    "Authentication",
    "AuthenticationList",
    "BaseKubernetesList",
    "CSISnapshotController",
    "CSISnapshotControllerList",
    "ConfigMapFileReference",
    "Console",
    "ConsoleList",
    "DNS",
    "DNSList",
    "DNSRecord",
    "DNSRecordList",
    "Etcd",
    "EtcdList",
    "ImageContentSourcePolicy",
    "ImageContentSourcePolicyList",
    "ImagePruner",
    "ImagePrunerList",
    "Info",
    "IngressController",
    "IngressControllerList",
    "KubeAPIServer",
    "KubeAPIServerList",
    "KubeControllerManager",
    "KubeControllerManagerList",
    "KubeScheduler",
    "KubeSchedulerList",
    "KubeStorageVersionMigrator",
    "KubeStorageVersionMigratorList",
    "Network",
    "NetworkList",
    "ObjectMeta",
    "OpenShiftAPIServer",
    "OpenShiftAPIServerList",
    "OpenShiftContollerManager",
    "OpenShiftControllerManagerList",
    "Patch",
    "Quantity",
    "SecretNameReference",
    "ServiceCA",
    "ServiceCAList",
    "ServiceCatalogAPIServer",
    "ServiceCatalogAPIServerList",
    "ServiceCatalogControllerManager",
    "ServiceCatalogControllerManagerList",
    "Status",
    "Time",
    "TypeMeta"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(io.fabric8.kubernetes.api.model.ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class KubeSchema {

    /**
     * 
     */
    @JsonProperty("APIGroup")
    @JsonPropertyDescription("")
    private APIGroup aPIGroup;
    /**
     * 
     */
    @JsonProperty("APIGroupList")
    @JsonPropertyDescription("")
    private APIGroupList aPIGroupList;
    /**
     * 
     */
    @JsonProperty("Authentication")
    @JsonPropertyDescription("")
    private Authentication authentication;
    /**
     * 
     */
    @JsonProperty("AuthenticationList")
    @JsonPropertyDescription("")
    private AuthenticationList authenticationList;
    /**
     * 
     */
    @JsonProperty("BaseKubernetesList")
    @JsonPropertyDescription("")
    private BaseKubernetesList baseKubernetesList;
    /**
     * 
     */
    @JsonProperty("CSISnapshotController")
    @JsonPropertyDescription("")
    private CSISnapshotController cSISnapshotController;
    /**
     * 
     */
    @JsonProperty("CSISnapshotControllerList")
    @JsonPropertyDescription("")
    private CSISnapshotControllerList cSISnapshotControllerList;
    /**
     * 
     */
    @JsonProperty("ConfigMapFileReference")
    @JsonPropertyDescription("")
    private ConfigMapFileReference configMapFileReference;
    /**
     * 
     */
    @JsonProperty("Console")
    @JsonPropertyDescription("")
    private Console console;
    /**
     * 
     */
    @JsonProperty("ConsoleList")
    @JsonPropertyDescription("")
    private ConsoleList consoleList;
    /**
     * 
     */
    @JsonProperty("DNS")
    @JsonPropertyDescription("")
    private DNS dns;
    /**
     * 
     */
    @JsonProperty("DNSList")
    @JsonPropertyDescription("")
    private DNSList dNSList;
    /**
     * 
     */
    @JsonProperty("DNSRecord")
    @JsonPropertyDescription("")
    private DNSRecord dNSRecord;
    /**
     * 
     */
    @JsonProperty("DNSRecordList")
    @JsonPropertyDescription("")
    private DNSRecordList dNSRecordList;
    /**
     * 
     */
    @JsonProperty("Etcd")
    @JsonPropertyDescription("")
    private Etcd etcd;
    /**
     * 
     */
    @JsonProperty("EtcdList")
    @JsonPropertyDescription("")
    private EtcdList etcdList;
    /**
     * 
     */
    @JsonProperty("ImageContentSourcePolicy")
    @JsonPropertyDescription("")
    private ImageContentSourcePolicy imageContentSourcePolicy;
    /**
     * 
     */
    @JsonProperty("ImageContentSourcePolicyList")
    @JsonPropertyDescription("")
    private ImageContentSourcePolicyList imageContentSourcePolicyList;
    /**
     * 
     */
    @JsonProperty("ImagePruner")
    @JsonPropertyDescription("")
    private ImagePruner imagePruner;
    /**
     * 
     */
    @JsonProperty("ImagePrunerList")
    @JsonPropertyDescription("")
    private ImagePrunerList imagePrunerList;
    /**
     * 
     */
    @JsonProperty("Info")
    @JsonPropertyDescription("")
    private Info info;
    /**
     * 
     */
    @JsonProperty("IngressController")
    @JsonPropertyDescription("")
    private IngressController ingressController;
    /**
     * 
     */
    @JsonProperty("IngressControllerList")
    @JsonPropertyDescription("")
    private IngressControllerList ingressControllerList;
    /**
     * 
     */
    @JsonProperty("KubeAPIServer")
    @JsonPropertyDescription("")
    private KubeAPIServer kubeAPIServer;
    /**
     * 
     */
    @JsonProperty("KubeAPIServerList")
    @JsonPropertyDescription("")
    private KubeAPIServerList kubeAPIServerList;
    /**
     * 
     */
    @JsonProperty("KubeControllerManager")
    @JsonPropertyDescription("")
    private KubeControllerManager kubeControllerManager;
    /**
     * 
     */
    @JsonProperty("KubeControllerManagerList")
    @JsonPropertyDescription("")
    private KubeControllerManagerList kubeControllerManagerList;
    /**
     * 
     */
    @JsonProperty("KubeScheduler")
    @JsonPropertyDescription("")
    private KubeScheduler kubeScheduler;
    /**
     * 
     */
    @JsonProperty("KubeSchedulerList")
    @JsonPropertyDescription("")
    private KubeSchedulerList kubeSchedulerList;
    /**
     * 
     */
    @JsonProperty("KubeStorageVersionMigrator")
    @JsonPropertyDescription("")
    private KubeStorageVersionMigrator kubeStorageVersionMigrator;
    /**
     * 
     */
    @JsonProperty("KubeStorageVersionMigratorList")
    @JsonPropertyDescription("")
    private KubeStorageVersionMigratorList kubeStorageVersionMigratorList;
    /**
     * 
     */
    @JsonProperty("Network")
    @JsonPropertyDescription("")
    private Network network;
    /**
     * 
     */
    @JsonProperty("NetworkList")
    @JsonPropertyDescription("")
    private NetworkList networkList;
    /**
     * 
     */
    @JsonProperty("ObjectMeta")
    @JsonPropertyDescription("")
    private io.fabric8.kubernetes.api.model.ObjectMeta objectMeta;
    /**
     * 
     */
    @JsonProperty("OpenShiftAPIServer")
    @JsonPropertyDescription("")
    private OpenShiftAPIServer openShiftAPIServer;
    /**
     * 
     */
    @JsonProperty("OpenShiftAPIServerList")
    @JsonPropertyDescription("")
    private OpenShiftAPIServerList openShiftAPIServerList;
    /**
     * 
     */
    @JsonProperty("OpenShiftContollerManager")
    @JsonPropertyDescription("")
    private OpenShiftControllerManager openShiftContollerManager;
    /**
     * 
     */
    @JsonProperty("OpenShiftControllerManagerList")
    @JsonPropertyDescription("")
    private OpenShiftControllerManagerList openShiftControllerManagerList;
    /**
     * 
     */
    @JsonProperty("Patch")
    @JsonPropertyDescription("")
    private Patch patch;
    /**
     * 
     */
    @JsonProperty("Quantity")
    @JsonPropertyDescription("")
    private Quantity quantity;
    /**
     * 
     */
    @JsonProperty("SecretNameReference")
    @JsonPropertyDescription("")
    private SecretNameReference secretNameReference;
    /**
     * 
     */
    @JsonProperty("ServiceCA")
    @JsonPropertyDescription("")
    private ServiceCA serviceCA;
    /**
     * 
     */
    @JsonProperty("ServiceCAList")
    @JsonPropertyDescription("")
    private ServiceCAList serviceCAList;
    /**
     * 
     */
    @JsonProperty("ServiceCatalogAPIServer")
    @JsonPropertyDescription("")
    private ServiceCatalogAPIServer serviceCatalogAPIServer;
    /**
     * 
     */
    @JsonProperty("ServiceCatalogAPIServerList")
    @JsonPropertyDescription("")
    private ServiceCatalogAPIServerList serviceCatalogAPIServerList;
    /**
     * 
     */
    @JsonProperty("ServiceCatalogControllerManager")
    @JsonPropertyDescription("")
    private ServiceCatalogControllerManager serviceCatalogControllerManager;
    /**
     * 
     */
    @JsonProperty("ServiceCatalogControllerManagerList")
    @JsonPropertyDescription("")
    private ServiceCatalogControllerManagerList serviceCatalogControllerManagerList;
    /**
     * 
     */
    @JsonProperty("Status")
    @JsonPropertyDescription("")
    private Status status;
    /**
     * 
     */
    @JsonProperty("Time")
    @JsonPropertyDescription("")
    private String time;
    /**
     * 
     */
    @JsonProperty("TypeMeta")
    @JsonPropertyDescription("")
    private TypeMeta typeMeta;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public KubeSchema() {
    }

    /**
     * 
     * @param secretNameReference
     * @param aPIGroupList
     * @param kubeControllerManager
     * @param cSISnapshotControllerList
     * @param serviceCatalogControllerManager
     * @param dNSRecordList
     * @param kubeSchedulerList
     * @param authenticationList
     * @param patch
     * @param ingressControllerList
     * @param kubeAPIServer
     * @param openShiftAPIServer
     * @param info
     * @param openShiftContollerManager
     * @param kubeStorageVersionMigratorList
     * @param dns
     * @param imagePruner
     * @param kubeAPIServerList
     * @param etcdList
     * @param configMapFileReference
     * @param kubeControllerManagerList
     * @param serviceCAList
     * @param networkList
     * @param openShiftAPIServerList
     * @param consoleList
     * @param serviceCA
     * @param status
     * @param ingressController
     * @param serviceCatalogAPIServer
     * @param baseKubernetesList
     * @param cSISnapshotController
     * @param imageContentSourcePolicyList
     * @param imagePrunerList
     * @param network
     * @param serviceCatalogControllerManagerList
     * @param kubeScheduler
     * @param dNSList
     * @param kubeStorageVersionMigrator
     * @param authentication
     * @param console
     * @param quantity
     * @param imageContentSourcePolicy
     * @param aPIGroup
     * @param typeMeta
     * @param objectMeta
     * @param serviceCatalogAPIServerList
     * @param time
     * @param dNSRecord
     * @param openShiftControllerManagerList
     * @param etcd
     */
    public KubeSchema(APIGroup aPIGroup, APIGroupList aPIGroupList, Authentication authentication, AuthenticationList authenticationList, BaseKubernetesList baseKubernetesList, CSISnapshotController cSISnapshotController, CSISnapshotControllerList cSISnapshotControllerList, ConfigMapFileReference configMapFileReference, Console console, ConsoleList consoleList, DNS dns, DNSList dNSList, DNSRecord dNSRecord, DNSRecordList dNSRecordList, Etcd etcd, EtcdList etcdList, ImageContentSourcePolicy imageContentSourcePolicy, ImageContentSourcePolicyList imageContentSourcePolicyList, ImagePruner imagePruner, ImagePrunerList imagePrunerList, Info info, IngressController ingressController, IngressControllerList ingressControllerList, KubeAPIServer kubeAPIServer, KubeAPIServerList kubeAPIServerList, KubeControllerManager kubeControllerManager, KubeControllerManagerList kubeControllerManagerList, KubeScheduler kubeScheduler, KubeSchedulerList kubeSchedulerList, KubeStorageVersionMigrator kubeStorageVersionMigrator, KubeStorageVersionMigratorList kubeStorageVersionMigratorList, Network network, NetworkList networkList, io.fabric8.kubernetes.api.model.ObjectMeta objectMeta, OpenShiftAPIServer openShiftAPIServer, OpenShiftAPIServerList openShiftAPIServerList, OpenShiftControllerManager openShiftContollerManager, OpenShiftControllerManagerList openShiftControllerManagerList, Patch patch, Quantity quantity, SecretNameReference secretNameReference, ServiceCA serviceCA, ServiceCAList serviceCAList, ServiceCatalogAPIServer serviceCatalogAPIServer, ServiceCatalogAPIServerList serviceCatalogAPIServerList, ServiceCatalogControllerManager serviceCatalogControllerManager, ServiceCatalogControllerManagerList serviceCatalogControllerManagerList, Status status, String time, TypeMeta typeMeta) {
        super();
        this.aPIGroup = aPIGroup;
        this.aPIGroupList = aPIGroupList;
        this.authentication = authentication;
        this.authenticationList = authenticationList;
        this.baseKubernetesList = baseKubernetesList;
        this.cSISnapshotController = cSISnapshotController;
        this.cSISnapshotControllerList = cSISnapshotControllerList;
        this.configMapFileReference = configMapFileReference;
        this.console = console;
        this.consoleList = consoleList;
        this.dns = dns;
        this.dNSList = dNSList;
        this.dNSRecord = dNSRecord;
        this.dNSRecordList = dNSRecordList;
        this.etcd = etcd;
        this.etcdList = etcdList;
        this.imageContentSourcePolicy = imageContentSourcePolicy;
        this.imageContentSourcePolicyList = imageContentSourcePolicyList;
        this.imagePruner = imagePruner;
        this.imagePrunerList = imagePrunerList;
        this.info = info;
        this.ingressController = ingressController;
        this.ingressControllerList = ingressControllerList;
        this.kubeAPIServer = kubeAPIServer;
        this.kubeAPIServerList = kubeAPIServerList;
        this.kubeControllerManager = kubeControllerManager;
        this.kubeControllerManagerList = kubeControllerManagerList;
        this.kubeScheduler = kubeScheduler;
        this.kubeSchedulerList = kubeSchedulerList;
        this.kubeStorageVersionMigrator = kubeStorageVersionMigrator;
        this.kubeStorageVersionMigratorList = kubeStorageVersionMigratorList;
        this.network = network;
        this.networkList = networkList;
        this.objectMeta = objectMeta;
        this.openShiftAPIServer = openShiftAPIServer;
        this.openShiftAPIServerList = openShiftAPIServerList;
        this.openShiftContollerManager = openShiftContollerManager;
        this.openShiftControllerManagerList = openShiftControllerManagerList;
        this.patch = patch;
        this.quantity = quantity;
        this.secretNameReference = secretNameReference;
        this.serviceCA = serviceCA;
        this.serviceCAList = serviceCAList;
        this.serviceCatalogAPIServer = serviceCatalogAPIServer;
        this.serviceCatalogAPIServerList = serviceCatalogAPIServerList;
        this.serviceCatalogControllerManager = serviceCatalogControllerManager;
        this.serviceCatalogControllerManagerList = serviceCatalogControllerManagerList;
        this.status = status;
        this.time = time;
        this.typeMeta = typeMeta;
    }

    /**
     * 
     */
    @JsonProperty("APIGroup")
    public APIGroup getAPIGroup() {
        return aPIGroup;
    }

    /**
     * 
     */
    @JsonProperty("APIGroup")
    public void setAPIGroup(APIGroup aPIGroup) {
        this.aPIGroup = aPIGroup;
    }

    /**
     * 
     */
    @JsonProperty("APIGroupList")
    public APIGroupList getAPIGroupList() {
        return aPIGroupList;
    }

    /**
     * 
     */
    @JsonProperty("APIGroupList")
    public void setAPIGroupList(APIGroupList aPIGroupList) {
        this.aPIGroupList = aPIGroupList;
    }

    /**
     * 
     */
    @JsonProperty("Authentication")
    public Authentication getAuthentication() {
        return authentication;
    }

    /**
     * 
     */
    @JsonProperty("Authentication")
    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    /**
     * 
     */
    @JsonProperty("AuthenticationList")
    public AuthenticationList getAuthenticationList() {
        return authenticationList;
    }

    /**
     * 
     */
    @JsonProperty("AuthenticationList")
    public void setAuthenticationList(AuthenticationList authenticationList) {
        this.authenticationList = authenticationList;
    }

    /**
     * 
     */
    @JsonProperty("BaseKubernetesList")
    public BaseKubernetesList getBaseKubernetesList() {
        return baseKubernetesList;
    }

    /**
     * 
     */
    @JsonProperty("BaseKubernetesList")
    public void setBaseKubernetesList(BaseKubernetesList baseKubernetesList) {
        this.baseKubernetesList = baseKubernetesList;
    }

    /**
     * 
     */
    @JsonProperty("CSISnapshotController")
    public CSISnapshotController getCSISnapshotController() {
        return cSISnapshotController;
    }

    /**
     * 
     */
    @JsonProperty("CSISnapshotController")
    public void setCSISnapshotController(CSISnapshotController cSISnapshotController) {
        this.cSISnapshotController = cSISnapshotController;
    }

    /**
     * 
     */
    @JsonProperty("CSISnapshotControllerList")
    public CSISnapshotControllerList getCSISnapshotControllerList() {
        return cSISnapshotControllerList;
    }

    /**
     * 
     */
    @JsonProperty("CSISnapshotControllerList")
    public void setCSISnapshotControllerList(CSISnapshotControllerList cSISnapshotControllerList) {
        this.cSISnapshotControllerList = cSISnapshotControllerList;
    }

    /**
     * 
     */
    @JsonProperty("ConfigMapFileReference")
    public ConfigMapFileReference getConfigMapFileReference() {
        return configMapFileReference;
    }

    /**
     * 
     */
    @JsonProperty("ConfigMapFileReference")
    public void setConfigMapFileReference(ConfigMapFileReference configMapFileReference) {
        this.configMapFileReference = configMapFileReference;
    }

    /**
     * 
     */
    @JsonProperty("Console")
    public Console getConsole() {
        return console;
    }

    /**
     * 
     */
    @JsonProperty("Console")
    public void setConsole(Console console) {
        this.console = console;
    }

    /**
     * 
     */
    @JsonProperty("ConsoleList")
    public ConsoleList getConsoleList() {
        return consoleList;
    }

    /**
     * 
     */
    @JsonProperty("ConsoleList")
    public void setConsoleList(ConsoleList consoleList) {
        this.consoleList = consoleList;
    }

    /**
     * 
     */
    @JsonProperty("DNS")
    public DNS getDns() {
        return dns;
    }

    /**
     * 
     */
    @JsonProperty("DNS")
    public void setDns(DNS dns) {
        this.dns = dns;
    }

    /**
     * 
     */
    @JsonProperty("DNSList")
    public DNSList getDNSList() {
        return dNSList;
    }

    /**
     * 
     */
    @JsonProperty("DNSList")
    public void setDNSList(DNSList dNSList) {
        this.dNSList = dNSList;
    }

    /**
     * 
     */
    @JsonProperty("DNSRecord")
    public DNSRecord getDNSRecord() {
        return dNSRecord;
    }

    /**
     * 
     */
    @JsonProperty("DNSRecord")
    public void setDNSRecord(DNSRecord dNSRecord) {
        this.dNSRecord = dNSRecord;
    }

    /**
     * 
     */
    @JsonProperty("DNSRecordList")
    public DNSRecordList getDNSRecordList() {
        return dNSRecordList;
    }

    /**
     * 
     */
    @JsonProperty("DNSRecordList")
    public void setDNSRecordList(DNSRecordList dNSRecordList) {
        this.dNSRecordList = dNSRecordList;
    }

    /**
     * 
     */
    @JsonProperty("Etcd")
    public Etcd getEtcd() {
        return etcd;
    }

    /**
     * 
     */
    @JsonProperty("Etcd")
    public void setEtcd(Etcd etcd) {
        this.etcd = etcd;
    }

    /**
     * 
     */
    @JsonProperty("EtcdList")
    public EtcdList getEtcdList() {
        return etcdList;
    }

    /**
     * 
     */
    @JsonProperty("EtcdList")
    public void setEtcdList(EtcdList etcdList) {
        this.etcdList = etcdList;
    }

    /**
     * 
     */
    @JsonProperty("ImageContentSourcePolicy")
    public ImageContentSourcePolicy getImageContentSourcePolicy() {
        return imageContentSourcePolicy;
    }

    /**
     * 
     */
    @JsonProperty("ImageContentSourcePolicy")
    public void setImageContentSourcePolicy(ImageContentSourcePolicy imageContentSourcePolicy) {
        this.imageContentSourcePolicy = imageContentSourcePolicy;
    }

    /**
     * 
     */
    @JsonProperty("ImageContentSourcePolicyList")
    public ImageContentSourcePolicyList getImageContentSourcePolicyList() {
        return imageContentSourcePolicyList;
    }

    /**
     * 
     */
    @JsonProperty("ImageContentSourcePolicyList")
    public void setImageContentSourcePolicyList(ImageContentSourcePolicyList imageContentSourcePolicyList) {
        this.imageContentSourcePolicyList = imageContentSourcePolicyList;
    }

    /**
     * 
     */
    @JsonProperty("ImagePruner")
    public ImagePruner getImagePruner() {
        return imagePruner;
    }

    /**
     * 
     */
    @JsonProperty("ImagePruner")
    public void setImagePruner(ImagePruner imagePruner) {
        this.imagePruner = imagePruner;
    }

    /**
     * 
     */
    @JsonProperty("ImagePrunerList")
    public ImagePrunerList getImagePrunerList() {
        return imagePrunerList;
    }

    /**
     * 
     */
    @JsonProperty("ImagePrunerList")
    public void setImagePrunerList(ImagePrunerList imagePrunerList) {
        this.imagePrunerList = imagePrunerList;
    }

    /**
     * 
     */
    @JsonProperty("Info")
    public Info getInfo() {
        return info;
    }

    /**
     * 
     */
    @JsonProperty("Info")
    public void setInfo(Info info) {
        this.info = info;
    }

    /**
     * 
     */
    @JsonProperty("IngressController")
    public IngressController getIngressController() {
        return ingressController;
    }

    /**
     * 
     */
    @JsonProperty("IngressController")
    public void setIngressController(IngressController ingressController) {
        this.ingressController = ingressController;
    }

    /**
     * 
     */
    @JsonProperty("IngressControllerList")
    public IngressControllerList getIngressControllerList() {
        return ingressControllerList;
    }

    /**
     * 
     */
    @JsonProperty("IngressControllerList")
    public void setIngressControllerList(IngressControllerList ingressControllerList) {
        this.ingressControllerList = ingressControllerList;
    }

    /**
     * 
     */
    @JsonProperty("KubeAPIServer")
    public KubeAPIServer getKubeAPIServer() {
        return kubeAPIServer;
    }

    /**
     * 
     */
    @JsonProperty("KubeAPIServer")
    public void setKubeAPIServer(KubeAPIServer kubeAPIServer) {
        this.kubeAPIServer = kubeAPIServer;
    }

    /**
     * 
     */
    @JsonProperty("KubeAPIServerList")
    public KubeAPIServerList getKubeAPIServerList() {
        return kubeAPIServerList;
    }

    /**
     * 
     */
    @JsonProperty("KubeAPIServerList")
    public void setKubeAPIServerList(KubeAPIServerList kubeAPIServerList) {
        this.kubeAPIServerList = kubeAPIServerList;
    }

    /**
     * 
     */
    @JsonProperty("KubeControllerManager")
    public KubeControllerManager getKubeControllerManager() {
        return kubeControllerManager;
    }

    /**
     * 
     */
    @JsonProperty("KubeControllerManager")
    public void setKubeControllerManager(KubeControllerManager kubeControllerManager) {
        this.kubeControllerManager = kubeControllerManager;
    }

    /**
     * 
     */
    @JsonProperty("KubeControllerManagerList")
    public KubeControllerManagerList getKubeControllerManagerList() {
        return kubeControllerManagerList;
    }

    /**
     * 
     */
    @JsonProperty("KubeControllerManagerList")
    public void setKubeControllerManagerList(KubeControllerManagerList kubeControllerManagerList) {
        this.kubeControllerManagerList = kubeControllerManagerList;
    }

    /**
     * 
     */
    @JsonProperty("KubeScheduler")
    public KubeScheduler getKubeScheduler() {
        return kubeScheduler;
    }

    /**
     * 
     */
    @JsonProperty("KubeScheduler")
    public void setKubeScheduler(KubeScheduler kubeScheduler) {
        this.kubeScheduler = kubeScheduler;
    }

    /**
     * 
     */
    @JsonProperty("KubeSchedulerList")
    public KubeSchedulerList getKubeSchedulerList() {
        return kubeSchedulerList;
    }

    /**
     * 
     */
    @JsonProperty("KubeSchedulerList")
    public void setKubeSchedulerList(KubeSchedulerList kubeSchedulerList) {
        this.kubeSchedulerList = kubeSchedulerList;
    }

    /**
     * 
     */
    @JsonProperty("KubeStorageVersionMigrator")
    public KubeStorageVersionMigrator getKubeStorageVersionMigrator() {
        return kubeStorageVersionMigrator;
    }

    /**
     * 
     */
    @JsonProperty("KubeStorageVersionMigrator")
    public void setKubeStorageVersionMigrator(KubeStorageVersionMigrator kubeStorageVersionMigrator) {
        this.kubeStorageVersionMigrator = kubeStorageVersionMigrator;
    }

    /**
     * 
     */
    @JsonProperty("KubeStorageVersionMigratorList")
    public KubeStorageVersionMigratorList getKubeStorageVersionMigratorList() {
        return kubeStorageVersionMigratorList;
    }

    /**
     * 
     */
    @JsonProperty("KubeStorageVersionMigratorList")
    public void setKubeStorageVersionMigratorList(KubeStorageVersionMigratorList kubeStorageVersionMigratorList) {
        this.kubeStorageVersionMigratorList = kubeStorageVersionMigratorList;
    }

    /**
     * 
     */
    @JsonProperty("Network")
    public Network getNetwork() {
        return network;
    }

    /**
     * 
     */
    @JsonProperty("Network")
    public void setNetwork(Network network) {
        this.network = network;
    }

    /**
     * 
     */
    @JsonProperty("NetworkList")
    public NetworkList getNetworkList() {
        return networkList;
    }

    /**
     * 
     */
    @JsonProperty("NetworkList")
    public void setNetworkList(NetworkList networkList) {
        this.networkList = networkList;
    }

    /**
     * 
     */
    @JsonProperty("ObjectMeta")
    public io.fabric8.kubernetes.api.model.ObjectMeta getObjectMeta() {
        return objectMeta;
    }

    /**
     * 
     */
    @JsonProperty("ObjectMeta")
    public void setObjectMeta(io.fabric8.kubernetes.api.model.ObjectMeta objectMeta) {
        this.objectMeta = objectMeta;
    }

    /**
     * 
     */
    @JsonProperty("OpenShiftAPIServer")
    public OpenShiftAPIServer getOpenShiftAPIServer() {
        return openShiftAPIServer;
    }

    /**
     * 
     */
    @JsonProperty("OpenShiftAPIServer")
    public void setOpenShiftAPIServer(OpenShiftAPIServer openShiftAPIServer) {
        this.openShiftAPIServer = openShiftAPIServer;
    }

    /**
     * 
     */
    @JsonProperty("OpenShiftAPIServerList")
    public OpenShiftAPIServerList getOpenShiftAPIServerList() {
        return openShiftAPIServerList;
    }

    /**
     * 
     */
    @JsonProperty("OpenShiftAPIServerList")
    public void setOpenShiftAPIServerList(OpenShiftAPIServerList openShiftAPIServerList) {
        this.openShiftAPIServerList = openShiftAPIServerList;
    }

    /**
     * 
     */
    @JsonProperty("OpenShiftContollerManager")
    public OpenShiftControllerManager getOpenShiftContollerManager() {
        return openShiftContollerManager;
    }

    /**
     * 
     */
    @JsonProperty("OpenShiftContollerManager")
    public void setOpenShiftContollerManager(OpenShiftControllerManager openShiftContollerManager) {
        this.openShiftContollerManager = openShiftContollerManager;
    }

    /**
     * 
     */
    @JsonProperty("OpenShiftControllerManagerList")
    public OpenShiftControllerManagerList getOpenShiftControllerManagerList() {
        return openShiftControllerManagerList;
    }

    /**
     * 
     */
    @JsonProperty("OpenShiftControllerManagerList")
    public void setOpenShiftControllerManagerList(OpenShiftControllerManagerList openShiftControllerManagerList) {
        this.openShiftControllerManagerList = openShiftControllerManagerList;
    }

    /**
     * 
     */
    @JsonProperty("Patch")
    public Patch getPatch() {
        return patch;
    }

    /**
     * 
     */
    @JsonProperty("Patch")
    public void setPatch(Patch patch) {
        this.patch = patch;
    }

    /**
     * 
     */
    @JsonProperty("Quantity")
    public Quantity getQuantity() {
        return quantity;
    }

    /**
     * 
     */
    @JsonProperty("Quantity")
    public void setQuantity(Quantity quantity) {
        this.quantity = quantity;
    }

    /**
     * 
     */
    @JsonProperty("SecretNameReference")
    public SecretNameReference getSecretNameReference() {
        return secretNameReference;
    }

    /**
     * 
     */
    @JsonProperty("SecretNameReference")
    public void setSecretNameReference(SecretNameReference secretNameReference) {
        this.secretNameReference = secretNameReference;
    }

    /**
     * 
     */
    @JsonProperty("ServiceCA")
    public ServiceCA getServiceCA() {
        return serviceCA;
    }

    /**
     * 
     */
    @JsonProperty("ServiceCA")
    public void setServiceCA(ServiceCA serviceCA) {
        this.serviceCA = serviceCA;
    }

    /**
     * 
     */
    @JsonProperty("ServiceCAList")
    public ServiceCAList getServiceCAList() {
        return serviceCAList;
    }

    /**
     * 
     */
    @JsonProperty("ServiceCAList")
    public void setServiceCAList(ServiceCAList serviceCAList) {
        this.serviceCAList = serviceCAList;
    }

    /**
     * 
     */
    @JsonProperty("ServiceCatalogAPIServer")
    public ServiceCatalogAPIServer getServiceCatalogAPIServer() {
        return serviceCatalogAPIServer;
    }

    /**
     * 
     */
    @JsonProperty("ServiceCatalogAPIServer")
    public void setServiceCatalogAPIServer(ServiceCatalogAPIServer serviceCatalogAPIServer) {
        this.serviceCatalogAPIServer = serviceCatalogAPIServer;
    }

    /**
     * 
     */
    @JsonProperty("ServiceCatalogAPIServerList")
    public ServiceCatalogAPIServerList getServiceCatalogAPIServerList() {
        return serviceCatalogAPIServerList;
    }

    /**
     * 
     */
    @JsonProperty("ServiceCatalogAPIServerList")
    public void setServiceCatalogAPIServerList(ServiceCatalogAPIServerList serviceCatalogAPIServerList) {
        this.serviceCatalogAPIServerList = serviceCatalogAPIServerList;
    }

    /**
     * 
     */
    @JsonProperty("ServiceCatalogControllerManager")
    public ServiceCatalogControllerManager getServiceCatalogControllerManager() {
        return serviceCatalogControllerManager;
    }

    /**
     * 
     */
    @JsonProperty("ServiceCatalogControllerManager")
    public void setServiceCatalogControllerManager(ServiceCatalogControllerManager serviceCatalogControllerManager) {
        this.serviceCatalogControllerManager = serviceCatalogControllerManager;
    }

    /**
     * 
     */
    @JsonProperty("ServiceCatalogControllerManagerList")
    public ServiceCatalogControllerManagerList getServiceCatalogControllerManagerList() {
        return serviceCatalogControllerManagerList;
    }

    /**
     * 
     */
    @JsonProperty("ServiceCatalogControllerManagerList")
    public void setServiceCatalogControllerManagerList(ServiceCatalogControllerManagerList serviceCatalogControllerManagerList) {
        this.serviceCatalogControllerManagerList = serviceCatalogControllerManagerList;
    }

    /**
     * 
     */
    @JsonProperty("Status")
    public Status getStatus() {
        return status;
    }

    /**
     * 
     */
    @JsonProperty("Status")
    public void setStatus(Status status) {
        this.status = status;
    }

    /**
     * 
     */
    @JsonProperty("Time")
    public String getTime() {
        return time;
    }

    /**
     * 
     */
    @JsonProperty("Time")
    public void setTime(String time) {
        this.time = time;
    }

    /**
     * 
     */
    @JsonProperty("TypeMeta")
    public TypeMeta getTypeMeta() {
        return typeMeta;
    }

    /**
     * 
     */
    @JsonProperty("TypeMeta")
    public void setTypeMeta(TypeMeta typeMeta) {
        this.typeMeta = typeMeta;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
