package io.fabric8.openshift.api.model.operator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ImageContentSourcePolicySpecBuilder extends ImageContentSourcePolicySpecFluentImpl<ImageContentSourcePolicySpecBuilder> implements VisitableBuilder<ImageContentSourcePolicySpec,ImageContentSourcePolicySpecBuilder> {

    ImageContentSourcePolicySpecFluent<?> fluent;
    Boolean validationEnabled;

    public ImageContentSourcePolicySpecBuilder() { 
        this(true);
    }


    public ImageContentSourcePolicySpecBuilder(Boolean validationEnabled) { 
        this(new ImageContentSourcePolicySpec(), validationEnabled);
    }


    public ImageContentSourcePolicySpecBuilder(ImageContentSourcePolicySpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public ImageContentSourcePolicySpecBuilder(ImageContentSourcePolicySpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ImageContentSourcePolicySpec(), validationEnabled);
    }


    public ImageContentSourcePolicySpecBuilder(ImageContentSourcePolicySpecFluent<?> fluent,ImageContentSourcePolicySpec instance) { 
        this(fluent, instance, true);
    }


    public ImageContentSourcePolicySpecBuilder(ImageContentSourcePolicySpecFluent<?> fluent,ImageContentSourcePolicySpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withRepositoryDigestMirrors(instance.getRepositoryDigestMirrors()); 
        this.validationEnabled = validationEnabled; 
    }


    public ImageContentSourcePolicySpecBuilder(ImageContentSourcePolicySpec instance) { 
        this(instance,true);
    }


    public ImageContentSourcePolicySpecBuilder(ImageContentSourcePolicySpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withRepositoryDigestMirrors(instance.getRepositoryDigestMirrors()); 
        this.validationEnabled = validationEnabled; 
    }


    public ImageContentSourcePolicySpec build() {
        ImageContentSourcePolicySpec buildable = new ImageContentSourcePolicySpec(fluent.getRepositoryDigestMirrors());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ImageContentSourcePolicySpecBuilder that = (ImageContentSourcePolicySpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
