package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class ProxyConfigFluentImpl<A extends ProxyConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ProxyConfigFluent<A> {

    private String bindAddress;
    private String iptablesSyncPeriod;
    private Map<String,ArrayList<String>> proxyArguments;

    public ProxyConfigFluentImpl() { 
    }


    public ProxyConfigFluentImpl(ProxyConfig instance) { 
        this.withBindAddress(instance.getBindAddress()); 
        this.withIptablesSyncPeriod(instance.getIptablesSyncPeriod()); 
        this.withProxyArguments(instance.getProxyArguments()); 
    }


    public String getBindAddress() {
        return this.bindAddress;
    }

    public A withBindAddress(String bindAddress) {
        this.bindAddress=bindAddress; return (A) this;
    }

    public Boolean hasBindAddress() {
        return this.bindAddress != null;
    }

    public A withNewBindAddress(String arg1) {
        return (A)withBindAddress(new String(arg1));
    }

    public A withNewBindAddress(StringBuilder arg1) {
        return (A)withBindAddress(new String(arg1));
    }

    public A withNewBindAddress(StringBuffer arg1) {
        return (A)withBindAddress(new String(arg1));
    }

    public String getIptablesSyncPeriod() {
        return this.iptablesSyncPeriod;
    }

    public A withIptablesSyncPeriod(String iptablesSyncPeriod) {
        this.iptablesSyncPeriod=iptablesSyncPeriod; return (A) this;
    }

    public Boolean hasIptablesSyncPeriod() {
        return this.iptablesSyncPeriod != null;
    }

    public A withNewIptablesSyncPeriod(String arg1) {
        return (A)withIptablesSyncPeriod(new String(arg1));
    }

    public A withNewIptablesSyncPeriod(StringBuilder arg1) {
        return (A)withIptablesSyncPeriod(new String(arg1));
    }

    public A withNewIptablesSyncPeriod(StringBuffer arg1) {
        return (A)withIptablesSyncPeriod(new String(arg1));
    }

    public A addToProxyArguments(String key,ArrayList<String> value) {
        if(this.proxyArguments == null && key != null && value != null) { this.proxyArguments = new LinkedHashMap<String,ArrayList<String>>(); }
        if(key != null && value != null) {this.proxyArguments.put(key, value);} return (A)this;
    }

    public A addToProxyArguments(Map<String,ArrayList<String>> map) {
        if(this.proxyArguments == null && map != null) { this.proxyArguments = new LinkedHashMap<String,ArrayList<String>>(); }
        if(map != null) { this.proxyArguments.putAll(map);} return (A)this;
    }

    public A removeFromProxyArguments(String key) {
        if(this.proxyArguments == null) { return (A) this; }
        if(key != null && this.proxyArguments != null) {this.proxyArguments.remove(key);} return (A)this;
    }

    public A removeFromProxyArguments(Map<String,ArrayList<String>> map) {
        if(this.proxyArguments == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.proxyArguments != null){this.proxyArguments.remove(key);}}} return (A)this;
    }

    public Map<String,ArrayList<String>> getProxyArguments() {
        return this.proxyArguments;
    }

    public A withProxyArguments(Map<String,ArrayList<String>> proxyArguments) {
        if (proxyArguments == null) { this.proxyArguments =  null;} else {this.proxyArguments = new LinkedHashMap<String,ArrayList<String>>(proxyArguments);} return (A) this;
    }

    public Boolean hasProxyArguments() {
        return this.proxyArguments != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ProxyConfigFluentImpl that = (ProxyConfigFluentImpl) o;
        if (bindAddress != null ? !bindAddress.equals(that.bindAddress) :that.bindAddress != null) return false;
        if (iptablesSyncPeriod != null ? !iptablesSyncPeriod.equals(that.iptablesSyncPeriod) :that.iptablesSyncPeriod != null) return false;
        if (proxyArguments != null ? !proxyArguments.equals(that.proxyArguments) :that.proxyArguments != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(bindAddress,  iptablesSyncPeriod,  proxyArguments,  super.hashCode());
    }

}
