package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ProviderLoadBalancerParametersBuilder extends ProviderLoadBalancerParametersFluentImpl<ProviderLoadBalancerParametersBuilder> implements VisitableBuilder<ProviderLoadBalancerParameters,ProviderLoadBalancerParametersBuilder> {

    ProviderLoadBalancerParametersFluent<?> fluent;
    Boolean validationEnabled;

    public ProviderLoadBalancerParametersBuilder() { 
        this(true);
    }


    public ProviderLoadBalancerParametersBuilder(Boolean validationEnabled) { 
        this(new ProviderLoadBalancerParameters(), validationEnabled);
    }


    public ProviderLoadBalancerParametersBuilder(ProviderLoadBalancerParametersFluent<?> fluent) { 
        this(fluent, true);
    }


    public ProviderLoadBalancerParametersBuilder(ProviderLoadBalancerParametersFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ProviderLoadBalancerParameters(), validationEnabled);
    }


    public ProviderLoadBalancerParametersBuilder(ProviderLoadBalancerParametersFluent<?> fluent,ProviderLoadBalancerParameters instance) { 
        this(fluent, instance, true);
    }


    public ProviderLoadBalancerParametersBuilder(ProviderLoadBalancerParametersFluent<?> fluent,ProviderLoadBalancerParameters instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAws(instance.getAws()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }


    public ProviderLoadBalancerParametersBuilder(ProviderLoadBalancerParameters instance) { 
        this(instance,true);
    }


    public ProviderLoadBalancerParametersBuilder(ProviderLoadBalancerParameters instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAws(instance.getAws()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }


    public ProviderLoadBalancerParameters build() {
        ProviderLoadBalancerParameters buildable = new ProviderLoadBalancerParameters(fluent.getAws(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ProviderLoadBalancerParametersBuilder that = (ProviderLoadBalancerParametersBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
