package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OpenShiftSDNConfigBuilder extends OpenShiftSDNConfigFluentImpl<OpenShiftSDNConfigBuilder> implements VisitableBuilder<OpenShiftSDNConfig,OpenShiftSDNConfigBuilder> {

    OpenShiftSDNConfigFluent<?> fluent;
    Boolean validationEnabled;

    public OpenShiftSDNConfigBuilder() { 
        this(true);
    }


    public OpenShiftSDNConfigBuilder(Boolean validationEnabled) { 
        this(new OpenShiftSDNConfig(), validationEnabled);
    }


    public OpenShiftSDNConfigBuilder(OpenShiftSDNConfigFluent<?> fluent) { 
        this(fluent, true);
    }


    public OpenShiftSDNConfigBuilder(OpenShiftSDNConfigFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new OpenShiftSDNConfig(), validationEnabled);
    }


    public OpenShiftSDNConfigBuilder(OpenShiftSDNConfigFluent<?> fluent,OpenShiftSDNConfig instance) { 
        this(fluent, instance, true);
    }


    public OpenShiftSDNConfigBuilder(OpenShiftSDNConfigFluent<?> fluent,OpenShiftSDNConfig instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withEnableUnidling(instance.getEnableUnidling()); 
        fluent.withMode(instance.getMode()); 
        fluent.withMtu(instance.getMtu()); 
        fluent.withUseExternalOpenvswitch(instance.getUseExternalOpenvswitch()); 
        fluent.withVxlanPort(instance.getVxlanPort()); 
        this.validationEnabled = validationEnabled; 
    }


    public OpenShiftSDNConfigBuilder(OpenShiftSDNConfig instance) { 
        this(instance,true);
    }


    public OpenShiftSDNConfigBuilder(OpenShiftSDNConfig instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withEnableUnidling(instance.getEnableUnidling()); 
        this.withMode(instance.getMode()); 
        this.withMtu(instance.getMtu()); 
        this.withUseExternalOpenvswitch(instance.getUseExternalOpenvswitch()); 
        this.withVxlanPort(instance.getVxlanPort()); 
        this.validationEnabled = validationEnabled; 
    }


    public OpenShiftSDNConfig build() {
        OpenShiftSDNConfig buildable = new OpenShiftSDNConfig(fluent.isEnableUnidling(),fluent.getMode(),fluent.getMtu(),fluent.isUseExternalOpenvswitch(),fluent.getVxlanPort());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OpenShiftSDNConfigBuilder that = (OpenShiftSDNConfigBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
