package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class NetworkSpecFluentImpl<A extends NetworkSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements NetworkSpecFluent<A> {

    private List<AdditionalNetworkDefinitionBuilder> additionalNetworks =  new ArrayList<AdditionalNetworkDefinitionBuilder>();
    private List<ClusterNetworkEntryBuilder> clusterNetwork =  new ArrayList<ClusterNetworkEntryBuilder>();
    private DefaultNetworkDefinitionBuilder defaultNetwork;
    private Boolean deployKubeProxy;
    private Boolean disableMultiNetwork;
    private ProxyConfigBuilder kubeProxyConfig;
    private String logLevel;
    private List<String> serviceNetwork = new ArrayList<String>();

    public NetworkSpecFluentImpl() { 
    }


    public NetworkSpecFluentImpl(NetworkSpec instance) { 
        this.withAdditionalNetworks(instance.getAdditionalNetworks()); 
        this.withClusterNetwork(instance.getClusterNetwork()); 
        this.withDefaultNetwork(instance.getDefaultNetwork()); 
        this.withDeployKubeProxy(instance.getDeployKubeProxy()); 
        this.withDisableMultiNetwork(instance.getDisableMultiNetwork()); 
        this.withKubeProxyConfig(instance.getKubeProxyConfig()); 
        this.withLogLevel(instance.getLogLevel()); 
        this.withServiceNetwork(instance.getServiceNetwork()); 
    }


    public A addToAdditionalNetworks(int index,AdditionalNetworkDefinition item) {
        if (this.additionalNetworks == null) {this.additionalNetworks = new ArrayList<AdditionalNetworkDefinitionBuilder>();}
        AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").add(index >= 0 ? index : _visitables.get("additionalNetworks").size(), builder);this.additionalNetworks.add(index >= 0 ? index : additionalNetworks.size(), builder); return (A)this;
    }

    public A setToAdditionalNetworks(int index,AdditionalNetworkDefinition item) {
        if (this.additionalNetworks == null) {this.additionalNetworks = new ArrayList<AdditionalNetworkDefinitionBuilder>();}
        AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);
        if (index < 0 || index >= _visitables.get("additionalNetworks").size()) { _visitables.get("additionalNetworks").add(builder); } else { _visitables.get("additionalNetworks").set(index, builder);}
        if (index < 0 || index >= additionalNetworks.size()) { additionalNetworks.add(builder); } else { additionalNetworks.set(index, builder);}
         return (A)this;
    }

    public A addToAdditionalNetworks(AdditionalNetworkDefinition... items) {
        if (this.additionalNetworks == null) {this.additionalNetworks = new ArrayList<AdditionalNetworkDefinitionBuilder>();}
        for (AdditionalNetworkDefinition item : items) {AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").add(builder);this.additionalNetworks.add(builder);} return (A)this;
    }

    public A addAllToAdditionalNetworks(Collection<AdditionalNetworkDefinition> items) {
        if (this.additionalNetworks == null) {this.additionalNetworks = new ArrayList<AdditionalNetworkDefinitionBuilder>();}
        for (AdditionalNetworkDefinition item : items) {AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").add(builder);this.additionalNetworks.add(builder);} return (A)this;
    }

    public A removeFromAdditionalNetworks(AdditionalNetworkDefinition... items) {
        for (AdditionalNetworkDefinition item : items) {AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").remove(builder);if (this.additionalNetworks != null) {this.additionalNetworks.remove(builder);}} return (A)this;
    }

    public A removeAllFromAdditionalNetworks(Collection<AdditionalNetworkDefinition> items) {
        for (AdditionalNetworkDefinition item : items) {AdditionalNetworkDefinitionBuilder builder = new AdditionalNetworkDefinitionBuilder(item);_visitables.get("additionalNetworks").remove(builder);if (this.additionalNetworks != null) {this.additionalNetworks.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromAdditionalNetworks(Predicate<AdditionalNetworkDefinitionBuilder> predicate) {
        if (additionalNetworks == null) return (A) this;
        final Iterator<AdditionalNetworkDefinitionBuilder> each = additionalNetworks.iterator();
        final List visitables = _visitables.get("additionalNetworks");
        while (each.hasNext()) {
          AdditionalNetworkDefinitionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildAdditionalNetworks instead.
 * @return The buildable object.
 */
@Deprecated public List<AdditionalNetworkDefinition> getAdditionalNetworks() {
        return build(additionalNetworks);
    }

    public List<AdditionalNetworkDefinition> buildAdditionalNetworks() {
        return build(additionalNetworks);
    }

    public AdditionalNetworkDefinition buildAdditionalNetwork(int index) {
        return this.additionalNetworks.get(index).build();
    }

    public AdditionalNetworkDefinition buildFirstAdditionalNetwork() {
        return this.additionalNetworks.get(0).build();
    }

    public AdditionalNetworkDefinition buildLastAdditionalNetwork() {
        return this.additionalNetworks.get(additionalNetworks.size() - 1).build();
    }

    public AdditionalNetworkDefinition buildMatchingAdditionalNetwork(Predicate<AdditionalNetworkDefinitionBuilder> predicate) {
        for (AdditionalNetworkDefinitionBuilder item: additionalNetworks) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingAdditionalNetwork(Predicate<AdditionalNetworkDefinitionBuilder> predicate) {
        for (AdditionalNetworkDefinitionBuilder item: additionalNetworks) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withAdditionalNetworks(List<AdditionalNetworkDefinition> additionalNetworks) {
        if (this.additionalNetworks != null) { _visitables.get("additionalNetworks").removeAll(this.additionalNetworks);}
        if (additionalNetworks != null) {this.additionalNetworks = new ArrayList<AdditionalNetworkDefinitionBuilder>(); for (AdditionalNetworkDefinition item : additionalNetworks){this.addToAdditionalNetworks(item);}} else { this.additionalNetworks = null;} return (A) this;
    }

    public A withAdditionalNetworks(AdditionalNetworkDefinition... additionalNetworks) {
        if (this.additionalNetworks != null) {this.additionalNetworks.clear();}
        if (additionalNetworks != null) {for (AdditionalNetworkDefinition item :additionalNetworks){ this.addToAdditionalNetworks(item);}} return (A) this;
    }

    public Boolean hasAdditionalNetworks() {
        return additionalNetworks != null && !additionalNetworks.isEmpty();
    }

    public NetworkSpecFluent.AdditionalNetworksNested<A> addNewAdditionalNetwork() {
        return new AdditionalNetworksNestedImpl();
    }

    public NetworkSpecFluent.AdditionalNetworksNested<A> addNewAdditionalNetworkLike(AdditionalNetworkDefinition item) {
        return new AdditionalNetworksNestedImpl(-1, item);
    }

    public NetworkSpecFluent.AdditionalNetworksNested<A> setNewAdditionalNetworkLike(int index,AdditionalNetworkDefinition item) {
        return new AdditionalNetworksNestedImpl(index, item);
    }

    public NetworkSpecFluent.AdditionalNetworksNested<A> editAdditionalNetwork(int index) {
        if (additionalNetworks.size() <= index) throw new RuntimeException("Can't edit additionalNetworks. Index exceeds size.");
        return setNewAdditionalNetworkLike(index, buildAdditionalNetwork(index));
    }

    public NetworkSpecFluent.AdditionalNetworksNested<A> editFirstAdditionalNetwork() {
        if (additionalNetworks.size() == 0) throw new RuntimeException("Can't edit first additionalNetworks. The list is empty.");
        return setNewAdditionalNetworkLike(0, buildAdditionalNetwork(0));
    }

    public NetworkSpecFluent.AdditionalNetworksNested<A> editLastAdditionalNetwork() {
        int index = additionalNetworks.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last additionalNetworks. The list is empty.");
        return setNewAdditionalNetworkLike(index, buildAdditionalNetwork(index));
    }

    public NetworkSpecFluent.AdditionalNetworksNested<A> editMatchingAdditionalNetwork(Predicate<AdditionalNetworkDefinitionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<additionalNetworks.size();i++) { 
        if (predicate.test(additionalNetworks.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching additionalNetworks. No match found.");
        return setNewAdditionalNetworkLike(index, buildAdditionalNetwork(index));
    }

    public A addToClusterNetwork(int index,ClusterNetworkEntry item) {
        if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(index >= 0 ? index : _visitables.get("clusterNetwork").size(), builder);this.clusterNetwork.add(index >= 0 ? index : clusterNetwork.size(), builder); return (A)this;
    }

    public A setToClusterNetwork(int index,ClusterNetworkEntry item) {
        if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= _visitables.get("clusterNetwork").size()) { _visitables.get("clusterNetwork").add(builder); } else { _visitables.get("clusterNetwork").set(index, builder);}
        if (index < 0 || index >= clusterNetwork.size()) { clusterNetwork.add(builder); } else { clusterNetwork.set(index, builder);}
         return (A)this;
    }

    public A addToClusterNetwork(ClusterNetworkEntry... items) {
        if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
        for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(builder);this.clusterNetwork.add(builder);} return (A)this;
    }

    public A addAllToClusterNetwork(Collection<ClusterNetworkEntry> items) {
        if (this.clusterNetwork == null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();}
        for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").add(builder);this.clusterNetwork.add(builder);} return (A)this;
    }

    public A removeFromClusterNetwork(ClusterNetworkEntry... items) {
        for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").remove(builder);if (this.clusterNetwork != null) {this.clusterNetwork.remove(builder);}} return (A)this;
    }

    public A removeAllFromClusterNetwork(Collection<ClusterNetworkEntry> items) {
        for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetwork").remove(builder);if (this.clusterNetwork != null) {this.clusterNetwork.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        if (clusterNetwork == null) return (A) this;
        final Iterator<ClusterNetworkEntryBuilder> each = clusterNetwork.iterator();
        final List visitables = _visitables.get("clusterNetwork");
        while (each.hasNext()) {
          ClusterNetworkEntryBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildClusterNetwork instead.
 * @return The buildable object.
 */
@Deprecated public List<ClusterNetworkEntry> getClusterNetwork() {
        return build(clusterNetwork);
    }

    public List<ClusterNetworkEntry> buildClusterNetwork() {
        return build(clusterNetwork);
    }

    public ClusterNetworkEntry buildClusterNetwork(int index) {
        return this.clusterNetwork.get(index).build();
    }

    public ClusterNetworkEntry buildFirstClusterNetwork() {
        return this.clusterNetwork.get(0).build();
    }

    public ClusterNetworkEntry buildLastClusterNetwork() {
        return this.clusterNetwork.get(clusterNetwork.size() - 1).build();
    }

    public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item: clusterNetwork) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item: clusterNetwork) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withClusterNetwork(List<ClusterNetworkEntry> clusterNetwork) {
        if (this.clusterNetwork != null) { _visitables.get("clusterNetwork").removeAll(this.clusterNetwork);}
        if (clusterNetwork != null) {this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>(); for (ClusterNetworkEntry item : clusterNetwork){this.addToClusterNetwork(item);}} else { this.clusterNetwork = null;} return (A) this;
    }

    public A withClusterNetwork(ClusterNetworkEntry... clusterNetwork) {
        if (this.clusterNetwork != null) {this.clusterNetwork.clear();}
        if (clusterNetwork != null) {for (ClusterNetworkEntry item :clusterNetwork){ this.addToClusterNetwork(item);}} return (A) this;
    }

    public Boolean hasClusterNetwork() {
        return clusterNetwork != null && !clusterNetwork.isEmpty();
    }

    public A addNewClusterNetwork(String cidr,Integer hostPrefix) {
        return (A)addToClusterNetwork(new ClusterNetworkEntry(cidr, hostPrefix));
    }

    public NetworkSpecFluent.ClusterNetworkNested<A> addNewClusterNetwork() {
        return new ClusterNetworkNestedImpl();
    }

    public NetworkSpecFluent.ClusterNetworkNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item) {
        return new ClusterNetworkNestedImpl(-1, item);
    }

    public NetworkSpecFluent.ClusterNetworkNested<A> setNewClusterNetworkLike(int index,ClusterNetworkEntry item) {
        return new ClusterNetworkNestedImpl(index, item);
    }

    public NetworkSpecFluent.ClusterNetworkNested<A> editClusterNetwork(int index) {
        if (clusterNetwork.size() <= index) throw new RuntimeException("Can't edit clusterNetwork. Index exceeds size.");
        return setNewClusterNetworkLike(index, buildClusterNetwork(index));
    }

    public NetworkSpecFluent.ClusterNetworkNested<A> editFirstClusterNetwork() {
        if (clusterNetwork.size() == 0) throw new RuntimeException("Can't edit first clusterNetwork. The list is empty.");
        return setNewClusterNetworkLike(0, buildClusterNetwork(0));
    }

    public NetworkSpecFluent.ClusterNetworkNested<A> editLastClusterNetwork() {
        int index = clusterNetwork.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last clusterNetwork. The list is empty.");
        return setNewClusterNetworkLike(index, buildClusterNetwork(index));
    }

    public NetworkSpecFluent.ClusterNetworkNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        int index = -1;
        for (int i=0;i<clusterNetwork.size();i++) { 
        if (predicate.test(clusterNetwork.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching clusterNetwork. No match found.");
        return setNewClusterNetworkLike(index, buildClusterNetwork(index));
    }

    
/**
 * This method has been deprecated, please use method buildDefaultNetwork instead.
 * @return The buildable object.
 */
@Deprecated public DefaultNetworkDefinition getDefaultNetwork() {
        return this.defaultNetwork!=null?this.defaultNetwork.build():null;
    }

    public DefaultNetworkDefinition buildDefaultNetwork() {
        return this.defaultNetwork!=null?this.defaultNetwork.build():null;
    }

    public A withDefaultNetwork(DefaultNetworkDefinition defaultNetwork) {
        _visitables.get("defaultNetwork").remove(this.defaultNetwork);
        if (defaultNetwork!=null){ this.defaultNetwork= new DefaultNetworkDefinitionBuilder(defaultNetwork); _visitables.get("defaultNetwork").add(this.defaultNetwork);} return (A) this;
    }

    public Boolean hasDefaultNetwork() {
        return this.defaultNetwork != null;
    }

    public NetworkSpecFluent.DefaultNetworkNested<A> withNewDefaultNetwork() {
        return new DefaultNetworkNestedImpl();
    }

    public NetworkSpecFluent.DefaultNetworkNested<A> withNewDefaultNetworkLike(DefaultNetworkDefinition item) {
        return new DefaultNetworkNestedImpl(item);
    }

    public NetworkSpecFluent.DefaultNetworkNested<A> editDefaultNetwork() {
        return withNewDefaultNetworkLike(getDefaultNetwork());
    }

    public NetworkSpecFluent.DefaultNetworkNested<A> editOrNewDefaultNetwork() {
        return withNewDefaultNetworkLike(getDefaultNetwork() != null ? getDefaultNetwork(): new DefaultNetworkDefinitionBuilder().build());
    }

    public NetworkSpecFluent.DefaultNetworkNested<A> editOrNewDefaultNetworkLike(DefaultNetworkDefinition item) {
        return withNewDefaultNetworkLike(getDefaultNetwork() != null ? getDefaultNetwork(): item);
    }

    public Boolean isDeployKubeProxy() {
        return this.deployKubeProxy;
    }

    public A withDeployKubeProxy(Boolean deployKubeProxy) {
        this.deployKubeProxy=deployKubeProxy; return (A) this;
    }

    public Boolean hasDeployKubeProxy() {
        return this.deployKubeProxy != null;
    }

    public A withNewDeployKubeProxy(String arg1) {
        return (A)withDeployKubeProxy(new Boolean(arg1));
    }

    public A withNewDeployKubeProxy(boolean arg1) {
        return (A)withDeployKubeProxy(new Boolean(arg1));
    }

    public Boolean isDisableMultiNetwork() {
        return this.disableMultiNetwork;
    }

    public A withDisableMultiNetwork(Boolean disableMultiNetwork) {
        this.disableMultiNetwork=disableMultiNetwork; return (A) this;
    }

    public Boolean hasDisableMultiNetwork() {
        return this.disableMultiNetwork != null;
    }

    public A withNewDisableMultiNetwork(String arg1) {
        return (A)withDisableMultiNetwork(new Boolean(arg1));
    }

    public A withNewDisableMultiNetwork(boolean arg1) {
        return (A)withDisableMultiNetwork(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildKubeProxyConfig instead.
 * @return The buildable object.
 */
@Deprecated public ProxyConfig getKubeProxyConfig() {
        return this.kubeProxyConfig!=null?this.kubeProxyConfig.build():null;
    }

    public ProxyConfig buildKubeProxyConfig() {
        return this.kubeProxyConfig!=null?this.kubeProxyConfig.build():null;
    }

    public A withKubeProxyConfig(ProxyConfig kubeProxyConfig) {
        _visitables.get("kubeProxyConfig").remove(this.kubeProxyConfig);
        if (kubeProxyConfig!=null){ this.kubeProxyConfig= new ProxyConfigBuilder(kubeProxyConfig); _visitables.get("kubeProxyConfig").add(this.kubeProxyConfig);} return (A) this;
    }

    public Boolean hasKubeProxyConfig() {
        return this.kubeProxyConfig != null;
    }

    public NetworkSpecFluent.KubeProxyConfigNested<A> withNewKubeProxyConfig() {
        return new KubeProxyConfigNestedImpl();
    }

    public NetworkSpecFluent.KubeProxyConfigNested<A> withNewKubeProxyConfigLike(ProxyConfig item) {
        return new KubeProxyConfigNestedImpl(item);
    }

    public NetworkSpecFluent.KubeProxyConfigNested<A> editKubeProxyConfig() {
        return withNewKubeProxyConfigLike(getKubeProxyConfig());
    }

    public NetworkSpecFluent.KubeProxyConfigNested<A> editOrNewKubeProxyConfig() {
        return withNewKubeProxyConfigLike(getKubeProxyConfig() != null ? getKubeProxyConfig(): new ProxyConfigBuilder().build());
    }

    public NetworkSpecFluent.KubeProxyConfigNested<A> editOrNewKubeProxyConfigLike(ProxyConfig item) {
        return withNewKubeProxyConfigLike(getKubeProxyConfig() != null ? getKubeProxyConfig(): item);
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public A withLogLevel(String logLevel) {
        this.logLevel=logLevel; return (A) this;
    }

    public Boolean hasLogLevel() {
        return this.logLevel != null;
    }

    public A withNewLogLevel(String arg1) {
        return (A)withLogLevel(new String(arg1));
    }

    public A withNewLogLevel(StringBuilder arg1) {
        return (A)withLogLevel(new String(arg1));
    }

    public A withNewLogLevel(StringBuffer arg1) {
        return (A)withLogLevel(new String(arg1));
    }

    public A addToServiceNetwork(int index,String item) {
        if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
        this.serviceNetwork.add(index, item);
        return (A)this;
    }

    public A setToServiceNetwork(int index,String item) {
        if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
        this.serviceNetwork.set(index, item); return (A)this;
    }

    public A addToServiceNetwork(String... items) {
        if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
        for (String item : items) {this.serviceNetwork.add(item);} return (A)this;
    }

    public A addAllToServiceNetwork(Collection<String> items) {
        if (this.serviceNetwork == null) {this.serviceNetwork = new ArrayList<String>();}
        for (String item : items) {this.serviceNetwork.add(item);} return (A)this;
    }

    public A removeFromServiceNetwork(String... items) {
        for (String item : items) {if (this.serviceNetwork!= null){ this.serviceNetwork.remove(item);}} return (A)this;
    }

    public A removeAllFromServiceNetwork(Collection<String> items) {
        for (String item : items) {if (this.serviceNetwork!= null){ this.serviceNetwork.remove(item);}} return (A)this;
    }

    public List<String> getServiceNetwork() {
        return this.serviceNetwork;
    }

    public String getServiceNetwork(int index) {
        return this.serviceNetwork.get(index);
    }

    public String getFirstServiceNetwork() {
        return this.serviceNetwork.get(0);
    }

    public String getLastServiceNetwork() {
        return this.serviceNetwork.get(serviceNetwork.size() - 1);
    }

    public String getMatchingServiceNetwork(Predicate<String> predicate) {
        for (String item: serviceNetwork) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingServiceNetwork(Predicate<String> predicate) {
        for (String item: serviceNetwork) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withServiceNetwork(List<String> serviceNetwork) {
        if (this.serviceNetwork != null) { _visitables.get("serviceNetwork").removeAll(this.serviceNetwork);}
        if (serviceNetwork != null) {this.serviceNetwork = new ArrayList<String>(); for (String item : serviceNetwork){this.addToServiceNetwork(item);}} else { this.serviceNetwork = null;} return (A) this;
    }

    public A withServiceNetwork(String... serviceNetwork) {
        if (this.serviceNetwork != null) {this.serviceNetwork.clear();}
        if (serviceNetwork != null) {for (String item :serviceNetwork){ this.addToServiceNetwork(item);}} return (A) this;
    }

    public Boolean hasServiceNetwork() {
        return serviceNetwork != null && !serviceNetwork.isEmpty();
    }

    public A addNewServiceNetwork(String arg1) {
        return (A)addToServiceNetwork(new String(arg1));
    }

    public A addNewServiceNetwork(StringBuilder arg1) {
        return (A)addToServiceNetwork(new String(arg1));
    }

    public A addNewServiceNetwork(StringBuffer arg1) {
        return (A)addToServiceNetwork(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NetworkSpecFluentImpl that = (NetworkSpecFluentImpl) o;
        if (additionalNetworks != null ? !additionalNetworks.equals(that.additionalNetworks) :that.additionalNetworks != null) return false;
        if (clusterNetwork != null ? !clusterNetwork.equals(that.clusterNetwork) :that.clusterNetwork != null) return false;
        if (defaultNetwork != null ? !defaultNetwork.equals(that.defaultNetwork) :that.defaultNetwork != null) return false;
        if (deployKubeProxy != null ? !deployKubeProxy.equals(that.deployKubeProxy) :that.deployKubeProxy != null) return false;
        if (disableMultiNetwork != null ? !disableMultiNetwork.equals(that.disableMultiNetwork) :that.disableMultiNetwork != null) return false;
        if (kubeProxyConfig != null ? !kubeProxyConfig.equals(that.kubeProxyConfig) :that.kubeProxyConfig != null) return false;
        if (logLevel != null ? !logLevel.equals(that.logLevel) :that.logLevel != null) return false;
        if (serviceNetwork != null ? !serviceNetwork.equals(that.serviceNetwork) :that.serviceNetwork != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(additionalNetworks,  clusterNetwork,  defaultNetwork,  deployKubeProxy,  disableMultiNetwork,  kubeProxyConfig,  logLevel,  serviceNetwork,  super.hashCode());
    }

    public class AdditionalNetworksNestedImpl<N> extends AdditionalNetworkDefinitionFluentImpl<NetworkSpecFluent.AdditionalNetworksNested<N>> implements NetworkSpecFluent.AdditionalNetworksNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AdditionalNetworkDefinitionBuilder builder;
        private final int index;

        AdditionalNetworksNestedImpl(int index,AdditionalNetworkDefinition item) {
            this.index = index;
            this.builder = new AdditionalNetworkDefinitionBuilder(this, item);
        }

        AdditionalNetworksNestedImpl() {
            this.index = -1;
            this.builder = new AdditionalNetworkDefinitionBuilder(this);
        }

        public N and() {
             return (N) NetworkSpecFluentImpl.this.setToAdditionalNetworks(index,builder.build());
        }

        public N endAdditionalNetwork() {
             return and();
        }
    }


    public class ClusterNetworkNestedImpl<N> extends ClusterNetworkEntryFluentImpl<NetworkSpecFluent.ClusterNetworkNested<N>> implements NetworkSpecFluent.ClusterNetworkNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ClusterNetworkEntryBuilder builder;
        private final int index;

        ClusterNetworkNestedImpl(int index,ClusterNetworkEntry item) {
            this.index = index;
            this.builder = new ClusterNetworkEntryBuilder(this, item);
        }

        ClusterNetworkNestedImpl() {
            this.index = -1;
            this.builder = new ClusterNetworkEntryBuilder(this);
        }

        public N and() {
             return (N) NetworkSpecFluentImpl.this.setToClusterNetwork(index,builder.build());
        }

        public N endClusterNetwork() {
             return and();
        }
    }


    public class DefaultNetworkNestedImpl<N> extends DefaultNetworkDefinitionFluentImpl<NetworkSpecFluent.DefaultNetworkNested<N>> implements NetworkSpecFluent.DefaultNetworkNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DefaultNetworkDefinitionBuilder builder;

        DefaultNetworkNestedImpl(DefaultNetworkDefinition item) {
            this.builder = new DefaultNetworkDefinitionBuilder(this, item);
        }

        DefaultNetworkNestedImpl() {
            this.builder = new DefaultNetworkDefinitionBuilder(this);
        }

        public N and() {
             return (N) NetworkSpecFluentImpl.this.withDefaultNetwork(builder.build());
        }

        public N endDefaultNetwork() {
             return and();
        }
    }


    public class KubeProxyConfigNestedImpl<N> extends ProxyConfigFluentImpl<NetworkSpecFluent.KubeProxyConfigNested<N>> implements NetworkSpecFluent.KubeProxyConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ProxyConfigBuilder builder;

        KubeProxyConfigNestedImpl(ProxyConfig item) {
            this.builder = new ProxyConfigBuilder(this, item);
        }

        KubeProxyConfigNestedImpl() {
            this.builder = new ProxyConfigBuilder(this);
        }

        public N and() {
             return (N) NetworkSpecFluentImpl.this.withKubeProxyConfig(builder.build());
        }

        public N endKubeProxyConfig() {
             return and();
        }
    }


}
