package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface NetworkListFluent<A extends NetworkListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Network item);
    public A setToItems(int index,Network item);
    public A addToItems(Network... items);
    public A addAllToItems(Collection<Network> items);
    public A removeFromItems(Network... items);
    public A removeAllFromItems(Collection<Network> items);
    public A removeMatchingFromItems(Predicate<NetworkBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Network> getItems();
    public List<Network> buildItems();
    public Network buildItem(int index);
    public Network buildFirstItem();
    public Network buildLastItem();
    public Network buildMatchingItem(Predicate<NetworkBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<NetworkBuilder> predicate);
    public A withItems(List<Network> items);
    public A withItems(Network... items);
    public Boolean hasItems();
    public NetworkListFluent.ItemsNested<A> addNewItem();
    public NetworkListFluent.ItemsNested<A> addNewItemLike(Network item);
    public NetworkListFluent.ItemsNested<A> setNewItemLike(int index,Network item);
    public NetworkListFluent.ItemsNested<A> editItem(int index);
    public NetworkListFluent.ItemsNested<A> editFirstItem();
    public NetworkListFluent.ItemsNested<A> editLastItem();
    public NetworkListFluent.ItemsNested<A> editMatchingItem(Predicate<NetworkBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetworkFluent<NetworkListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
