package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class LoadBalancerStrategyFluentImpl<A extends LoadBalancerStrategyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements LoadBalancerStrategyFluent<A> {

    private ProviderLoadBalancerParametersBuilder providerParameters;
    private String scope;

    public LoadBalancerStrategyFluentImpl() { 
    }


    public LoadBalancerStrategyFluentImpl(LoadBalancerStrategy instance) { 
        this.withProviderParameters(instance.getProviderParameters()); 
        this.withScope(instance.getScope()); 
    }


    
/**
 * This method has been deprecated, please use method buildProviderParameters instead.
 * @return The buildable object.
 */
@Deprecated public ProviderLoadBalancerParameters getProviderParameters() {
        return this.providerParameters!=null?this.providerParameters.build():null;
    }

    public ProviderLoadBalancerParameters buildProviderParameters() {
        return this.providerParameters!=null?this.providerParameters.build():null;
    }

    public A withProviderParameters(ProviderLoadBalancerParameters providerParameters) {
        _visitables.get("providerParameters").remove(this.providerParameters);
        if (providerParameters!=null){ this.providerParameters= new ProviderLoadBalancerParametersBuilder(providerParameters); _visitables.get("providerParameters").add(this.providerParameters);} return (A) this;
    }

    public Boolean hasProviderParameters() {
        return this.providerParameters != null;
    }

    public LoadBalancerStrategyFluent.ProviderParametersNested<A> withNewProviderParameters() {
        return new ProviderParametersNestedImpl();
    }

    public LoadBalancerStrategyFluent.ProviderParametersNested<A> withNewProviderParametersLike(ProviderLoadBalancerParameters item) {
        return new ProviderParametersNestedImpl(item);
    }

    public LoadBalancerStrategyFluent.ProviderParametersNested<A> editProviderParameters() {
        return withNewProviderParametersLike(getProviderParameters());
    }

    public LoadBalancerStrategyFluent.ProviderParametersNested<A> editOrNewProviderParameters() {
        return withNewProviderParametersLike(getProviderParameters() != null ? getProviderParameters(): new ProviderLoadBalancerParametersBuilder().build());
    }

    public LoadBalancerStrategyFluent.ProviderParametersNested<A> editOrNewProviderParametersLike(ProviderLoadBalancerParameters item) {
        return withNewProviderParametersLike(getProviderParameters() != null ? getProviderParameters(): item);
    }

    public String getScope() {
        return this.scope;
    }

    public A withScope(String scope) {
        this.scope=scope; return (A) this;
    }

    public Boolean hasScope() {
        return this.scope != null;
    }

    public A withNewScope(String arg1) {
        return (A)withScope(new String(arg1));
    }

    public A withNewScope(StringBuilder arg1) {
        return (A)withScope(new String(arg1));
    }

    public A withNewScope(StringBuffer arg1) {
        return (A)withScope(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LoadBalancerStrategyFluentImpl that = (LoadBalancerStrategyFluentImpl) o;
        if (providerParameters != null ? !providerParameters.equals(that.providerParameters) :that.providerParameters != null) return false;
        if (scope != null ? !scope.equals(that.scope) :that.scope != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(providerParameters,  scope,  super.hashCode());
    }

    public class ProviderParametersNestedImpl<N> extends ProviderLoadBalancerParametersFluentImpl<LoadBalancerStrategyFluent.ProviderParametersNested<N>> implements LoadBalancerStrategyFluent.ProviderParametersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ProviderLoadBalancerParametersBuilder builder;

        ProviderParametersNestedImpl(ProviderLoadBalancerParameters item) {
            this.builder = new ProviderLoadBalancerParametersBuilder(this, item);
        }

        ProviderParametersNestedImpl() {
            this.builder = new ProviderLoadBalancerParametersBuilder(this);
        }

        public N and() {
             return (N) LoadBalancerStrategyFluentImpl.this.withProviderParameters(builder.build());
        }

        public N endProviderParameters() {
             return and();
        }
    }


}
