package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface KubeControllerManagerListFluent<A extends KubeControllerManagerListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,KubeControllerManager item);
    public A setToItems(int index,KubeControllerManager item);
    public A addToItems(KubeControllerManager... items);
    public A addAllToItems(Collection<KubeControllerManager> items);
    public A removeFromItems(KubeControllerManager... items);
    public A removeAllFromItems(Collection<KubeControllerManager> items);
    public A removeMatchingFromItems(Predicate<KubeControllerManagerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<KubeControllerManager> getItems();
    public List<KubeControllerManager> buildItems();
    public KubeControllerManager buildItem(int index);
    public KubeControllerManager buildFirstItem();
    public KubeControllerManager buildLastItem();
    public KubeControllerManager buildMatchingItem(Predicate<KubeControllerManagerBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<KubeControllerManagerBuilder> predicate);
    public A withItems(List<KubeControllerManager> items);
    public A withItems(KubeControllerManager... items);
    public Boolean hasItems();
    public KubeControllerManagerListFluent.ItemsNested<A> addNewItem();
    public KubeControllerManagerListFluent.ItemsNested<A> addNewItemLike(KubeControllerManager item);
    public KubeControllerManagerListFluent.ItemsNested<A> setNewItemLike(int index,KubeControllerManager item);
    public KubeControllerManagerListFluent.ItemsNested<A> editItem(int index);
    public KubeControllerManagerListFluent.ItemsNested<A> editFirstItem();
    public KubeControllerManagerListFluent.ItemsNested<A> editLastItem();
    public KubeControllerManagerListFluent.ItemsNested<A> editMatchingItem(Predicate<KubeControllerManagerBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeControllerManagerFluent<KubeControllerManagerListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
