package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Object;
import java.util.Map;

public interface KubeControllerManagerFluent<A extends KubeControllerManagerFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public KubeControllerManagerFluent.MetadataNested<A> withNewMetadata();
    public KubeControllerManagerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public KubeControllerManagerFluent.MetadataNested<A> editMetadata();
    public KubeControllerManagerFluent.MetadataNested<A> editOrNewMetadata();
    public KubeControllerManagerFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public KubeControllerManagerSpec getSpec();
    public KubeControllerManagerSpec buildSpec();
    public A withSpec(KubeControllerManagerSpec spec);
    public Boolean hasSpec();
    public KubeControllerManagerFluent.SpecNested<A> withNewSpec();
    public KubeControllerManagerFluent.SpecNested<A> withNewSpecLike(KubeControllerManagerSpec item);
    public KubeControllerManagerFluent.SpecNested<A> editSpec();
    public KubeControllerManagerFluent.SpecNested<A> editOrNewSpec();
    public KubeControllerManagerFluent.SpecNested<A> editOrNewSpecLike(KubeControllerManagerSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public KubeControllerManagerStatus getStatus();
    public KubeControllerManagerStatus buildStatus();
    public A withStatus(KubeControllerManagerStatus status);
    public Boolean hasStatus();
    public KubeControllerManagerFluent.StatusNested<A> withNewStatus();
    public KubeControllerManagerFluent.StatusNested<A> withNewStatusLike(KubeControllerManagerStatus item);
    public KubeControllerManagerFluent.StatusNested<A> editStatus();
    public KubeControllerManagerFluent.StatusNested<A> editOrNewStatus();
    public KubeControllerManagerFluent.StatusNested<A> editOrNewStatusLike(KubeControllerManagerStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<KubeControllerManagerFluent.MetadataNested<N>> {

        public N and();
        public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeControllerManagerSpecFluent<KubeControllerManagerFluent.SpecNested<N>> {

        public N and();
        public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubeControllerManagerStatusFluent<KubeControllerManagerFluent.StatusNested<N>> {

        public N and();
        public N endStatus();    }


}
