package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubeAPIServerStatusBuilder extends KubeAPIServerStatusFluentImpl<KubeAPIServerStatusBuilder> implements VisitableBuilder<KubeAPIServerStatus,KubeAPIServerStatusBuilder> {

    KubeAPIServerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public KubeAPIServerStatusBuilder() { 
        this(true);
    }


    public KubeAPIServerStatusBuilder(Boolean validationEnabled) { 
        this(new KubeAPIServerStatus(), validationEnabled);
    }


    public KubeAPIServerStatusBuilder(KubeAPIServerStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public KubeAPIServerStatusBuilder(KubeAPIServerStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new KubeAPIServerStatus(), validationEnabled);
    }


    public KubeAPIServerStatusBuilder(KubeAPIServerStatusFluent<?> fluent,KubeAPIServerStatus instance) { 
        this(fluent, instance, true);
    }


    public KubeAPIServerStatusBuilder(KubeAPIServerStatusFluent<?> fluent,KubeAPIServerStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withConditions(instance.getConditions()); 
        fluent.withGenerations(instance.getGenerations()); 
        fluent.withLatestAvailableRevision(instance.getLatestAvailableRevision()); 
        fluent.withLatestAvailableRevisionReason(instance.getLatestAvailableRevisionReason()); 
        fluent.withNodeStatuses(instance.getNodeStatuses()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withReadyReplicas(instance.getReadyReplicas()); 
        fluent.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }


    public KubeAPIServerStatusBuilder(KubeAPIServerStatus instance) { 
        this(instance,true);
    }


    public KubeAPIServerStatusBuilder(KubeAPIServerStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withConditions(instance.getConditions()); 
        this.withGenerations(instance.getGenerations()); 
        this.withLatestAvailableRevision(instance.getLatestAvailableRevision()); 
        this.withLatestAvailableRevisionReason(instance.getLatestAvailableRevisionReason()); 
        this.withNodeStatuses(instance.getNodeStatuses()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withReadyReplicas(instance.getReadyReplicas()); 
        this.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }


    public KubeAPIServerStatus build() {
        KubeAPIServerStatus buildable = new KubeAPIServerStatus(fluent.getConditions(),fluent.getGenerations(),fluent.getLatestAvailableRevision(),fluent.getLatestAvailableRevisionReason(),fluent.getNodeStatuses(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KubeAPIServerStatusBuilder that = (KubeAPIServerStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
