package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Object;

public class EtcdFluentImpl<A extends EtcdFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EtcdFluent<A> {

    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private EtcdSpecBuilder spec;
    private EtcdStatusBuilder status;

    public EtcdFluentImpl() { 
    }


    public EtcdFluentImpl(Etcd instance) { 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
    }


    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public EtcdFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public EtcdFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    public EtcdFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public EtcdFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public EtcdFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public EtcdSpec getSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public EtcdSpec buildSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(EtcdSpec spec) {
        _visitables.get("spec").remove(this.spec);
        if (spec!=null){ this.spec= new EtcdSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec() {
        return this.spec != null;
    }

    public EtcdFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    public EtcdFluent.SpecNested<A> withNewSpecLike(EtcdSpec item) {
        return new SpecNestedImpl(item);
    }

    public EtcdFluent.SpecNested<A> editSpec() {
        return withNewSpecLike(getSpec());
    }

    public EtcdFluent.SpecNested<A> editOrNewSpec() {
        return withNewSpecLike(getSpec() != null ? getSpec(): new EtcdSpecBuilder().build());
    }

    public EtcdFluent.SpecNested<A> editOrNewSpecLike(EtcdSpec item) {
        return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public EtcdStatus getStatus() {
        return this.status!=null?this.status.build():null;
    }

    public EtcdStatus buildStatus() {
        return this.status!=null?this.status.build():null;
    }

    public A withStatus(EtcdStatus status) {
        _visitables.get("status").remove(this.status);
        if (status!=null){ this.status= new EtcdStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus() {
        return this.status != null;
    }

    public EtcdFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    public EtcdFluent.StatusNested<A> withNewStatusLike(EtcdStatus item) {
        return new StatusNestedImpl(item);
    }

    public EtcdFluent.StatusNested<A> editStatus() {
        return withNewStatusLike(getStatus());
    }

    public EtcdFluent.StatusNested<A> editOrNewStatus() {
        return withNewStatusLike(getStatus() != null ? getStatus(): new EtcdStatusBuilder().build());
    }

    public EtcdFluent.StatusNested<A> editOrNewStatusLike(EtcdStatus item) {
        return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EtcdFluentImpl that = (EtcdFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<EtcdFluent.MetadataNested<N>> implements EtcdFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        public N and() {
             return (N) EtcdFluentImpl.this.withMetadata(builder.build());
        }

        public N endMetadata() {
             return and();
        }
    }


    public class SpecNestedImpl<N> extends EtcdSpecFluentImpl<EtcdFluent.SpecNested<N>> implements EtcdFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EtcdSpecBuilder builder;

        SpecNestedImpl(EtcdSpec item) {
            this.builder = new EtcdSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new EtcdSpecBuilder(this);
        }

        public N and() {
             return (N) EtcdFluentImpl.this.withSpec(builder.build());
        }

        public N endSpec() {
             return and();
        }
    }


    public class StatusNestedImpl<N> extends EtcdStatusFluentImpl<EtcdFluent.StatusNested<N>> implements EtcdFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EtcdStatusBuilder builder;

        StatusNestedImpl(EtcdStatus item) {
            this.builder = new EtcdStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new EtcdStatusBuilder(this);
        }

        public N and() {
             return (N) EtcdFluentImpl.this.withStatus(builder.build());
        }

        public N endStatus() {
             return and();
        }
    }


}
