package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.DNSZoneBuilder;
import io.fabric8.openshift.api.model.DNSZone;
import io.fabric8.openshift.api.model.DNSZoneFluentImpl;
import java.util.Collection;
import java.lang.Object;

public class DNSZoneStatusFluentImpl<A extends DNSZoneStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DNSZoneStatusFluent<A> {

    private List<DNSZoneConditionBuilder> conditions =  new ArrayList<DNSZoneConditionBuilder>();
    private DNSZoneBuilder dnsZone;

    public DNSZoneStatusFluentImpl() { 
    }


    public DNSZoneStatusFluentImpl(DNSZoneStatus instance) { 
        this.withConditions(instance.getConditions()); 
        this.withDnsZone(instance.getDnsZone()); 
    }


    public A addToConditions(int index,DNSZoneCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<DNSZoneConditionBuilder>();}
        DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,DNSZoneCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<DNSZoneConditionBuilder>();}
        DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(DNSZoneCondition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<DNSZoneConditionBuilder>();}
        for (DNSZoneCondition item : items) {DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<DNSZoneCondition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<DNSZoneConditionBuilder>();}
        for (DNSZoneCondition item : items) {DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(DNSZoneCondition... items) {
        for (DNSZoneCondition item : items) {DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<DNSZoneCondition> items) {
        for (DNSZoneCondition item : items) {DNSZoneConditionBuilder builder = new DNSZoneConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<DNSZoneConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<DNSZoneConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          DNSZoneConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<DNSZoneCondition> getConditions() {
        return build(conditions);
    }

    public List<DNSZoneCondition> buildConditions() {
        return build(conditions);
    }

    public DNSZoneCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public DNSZoneCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public DNSZoneCondition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public DNSZoneCondition buildMatchingCondition(Predicate<DNSZoneConditionBuilder> predicate) {
        for (DNSZoneConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(Predicate<DNSZoneConditionBuilder> predicate) {
        for (DNSZoneConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(List<DNSZoneCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<DNSZoneConditionBuilder>(); for (DNSZoneCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(DNSZoneCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (DNSZoneCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
        return (A)addToConditions(new DNSZoneCondition(lastTransitionTime, message, reason, status, type));
    }

    public DNSZoneStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    public DNSZoneStatusFluent.ConditionsNested<A> addNewConditionLike(DNSZoneCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    public DNSZoneStatusFluent.ConditionsNested<A> setNewConditionLike(int index,DNSZoneCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    public DNSZoneStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public DNSZoneStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public DNSZoneStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public DNSZoneStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<DNSZoneConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    
/**
 * This method has been deprecated, please use method buildDnsZone instead.
 * @return The buildable object.
 */
@Deprecated public DNSZone getDnsZone() {
        return this.dnsZone!=null?this.dnsZone.build():null;
    }

    public DNSZone buildDnsZone() {
        return this.dnsZone!=null?this.dnsZone.build():null;
    }

    public A withDnsZone(DNSZone dnsZone) {
        _visitables.get("dnsZone").remove(this.dnsZone);
        if (dnsZone!=null){ this.dnsZone= new DNSZoneBuilder(dnsZone); _visitables.get("dnsZone").add(this.dnsZone);} return (A) this;
    }

    public Boolean hasDnsZone() {
        return this.dnsZone != null;
    }

    public DNSZoneStatusFluent.DnsZoneNested<A> withNewDnsZone() {
        return new DnsZoneNestedImpl();
    }

    public DNSZoneStatusFluent.DnsZoneNested<A> withNewDnsZoneLike(DNSZone item) {
        return new DnsZoneNestedImpl(item);
    }

    public DNSZoneStatusFluent.DnsZoneNested<A> editDnsZone() {
        return withNewDnsZoneLike(getDnsZone());
    }

    public DNSZoneStatusFluent.DnsZoneNested<A> editOrNewDnsZone() {
        return withNewDnsZoneLike(getDnsZone() != null ? getDnsZone(): new DNSZoneBuilder().build());
    }

    public DNSZoneStatusFluent.DnsZoneNested<A> editOrNewDnsZoneLike(DNSZone item) {
        return withNewDnsZoneLike(getDnsZone() != null ? getDnsZone(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DNSZoneStatusFluentImpl that = (DNSZoneStatusFluentImpl) o;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (dnsZone != null ? !dnsZone.equals(that.dnsZone) :that.dnsZone != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(conditions,  dnsZone,  super.hashCode());
    }

    public class ConditionsNestedImpl<N> extends DNSZoneConditionFluentImpl<DNSZoneStatusFluent.ConditionsNested<N>> implements DNSZoneStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DNSZoneConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index,DNSZoneCondition item) {
            this.index = index;
            this.builder = new DNSZoneConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new DNSZoneConditionBuilder(this);
        }

        public N and() {
             return (N) DNSZoneStatusFluentImpl.this.setToConditions(index,builder.build());
        }

        public N endCondition() {
             return and();
        }
    }


    public class DnsZoneNestedImpl<N> extends DNSZoneFluentImpl<DNSZoneStatusFluent.DnsZoneNested<N>> implements DNSZoneStatusFluent.DnsZoneNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DNSZoneBuilder builder;

        DnsZoneNestedImpl(DNSZone item) {
            this.builder = new DNSZoneBuilder(this, item);
        }

        DnsZoneNestedImpl() {
            this.builder = new DNSZoneBuilder(this);
        }

        public N and() {
             return (N) DNSZoneStatusFluentImpl.this.withDnsZone(builder.build());
        }

        public N endDnsZone() {
             return and();
        }
    }


}
