package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Object;
import java.util.Map;

public interface DNSRecordFluent<A extends DNSRecordFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public DNSRecordFluent.MetadataNested<A> withNewMetadata();
    public DNSRecordFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public DNSRecordFluent.MetadataNested<A> editMetadata();
    public DNSRecordFluent.MetadataNested<A> editOrNewMetadata();
    public DNSRecordFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public DNSRecordSpec getSpec();
    public DNSRecordSpec buildSpec();
    public A withSpec(DNSRecordSpec spec);
    public Boolean hasSpec();
    public DNSRecordFluent.SpecNested<A> withNewSpec();
    public DNSRecordFluent.SpecNested<A> withNewSpecLike(DNSRecordSpec item);
    public DNSRecordFluent.SpecNested<A> editSpec();
    public DNSRecordFluent.SpecNested<A> editOrNewSpec();
    public DNSRecordFluent.SpecNested<A> editOrNewSpecLike(DNSRecordSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public DNSRecordStatus getStatus();
    public DNSRecordStatus buildStatus();
    public A withStatus(DNSRecordStatus status);
    public Boolean hasStatus();
    public DNSRecordFluent.StatusNested<A> withNewStatus();
    public DNSRecordFluent.StatusNested<A> withNewStatusLike(DNSRecordStatus item);
    public DNSRecordFluent.StatusNested<A> editStatus();
    public DNSRecordFluent.StatusNested<A> editOrNewStatus();
    public DNSRecordFluent.StatusNested<A> editOrNewStatusLike(DNSRecordStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<DNSRecordFluent.MetadataNested<N>> {

        public N and();
        public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DNSRecordSpecFluent<DNSRecordFluent.SpecNested<N>> {

        public N and();
        public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DNSRecordStatusFluent<DNSRecordFluent.StatusNested<N>> {

        public N and();
        public N endStatus();    }


}
