package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Object;
import java.util.Map;

public interface DNSFluent<A extends DNSFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public DNSFluent.MetadataNested<A> withNewMetadata();
    public DNSFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public DNSFluent.MetadataNested<A> editMetadata();
    public DNSFluent.MetadataNested<A> editOrNewMetadata();
    public DNSFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public DNSSpec getSpec();
    public DNSSpec buildSpec();
    public A withSpec(DNSSpec spec);
    public Boolean hasSpec();
    public DNSFluent.SpecNested<A> withNewSpec();
    public DNSFluent.SpecNested<A> withNewSpecLike(DNSSpec item);
    public DNSFluent.SpecNested<A> editSpec();
    public DNSFluent.SpecNested<A> editOrNewSpec();
    public DNSFluent.SpecNested<A> editOrNewSpecLike(DNSSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public DNSStatus getStatus();
    public DNSStatus buildStatus();
    public A withStatus(DNSStatus status);
    public Boolean hasStatus();
    public DNSFluent.StatusNested<A> withNewStatus();
    public DNSFluent.StatusNested<A> withNewStatusLike(DNSStatus item);
    public DNSFluent.StatusNested<A> editStatus();
    public DNSFluent.StatusNested<A> editOrNewStatus();
    public DNSFluent.StatusNested<A> editOrNewStatusLike(DNSStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<DNSFluent.MetadataNested<N>> {

        public N and();
        public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DNSSpecFluent<DNSFluent.SpecNested<N>> {

        public N and();
        public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DNSStatusFluent<DNSFluent.StatusNested<N>> {

        public N and();
        public N endStatus();    }


}
