package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleStatusBuilder extends ConsoleStatusFluentImpl<ConsoleStatusBuilder> implements VisitableBuilder<ConsoleStatus,ConsoleStatusBuilder> {

    ConsoleStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ConsoleStatusBuilder() { 
        this(true);
    }


    public ConsoleStatusBuilder(Boolean validationEnabled) { 
        this(new ConsoleStatus(), validationEnabled);
    }


    public ConsoleStatusBuilder(ConsoleStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public ConsoleStatusBuilder(ConsoleStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ConsoleStatus(), validationEnabled);
    }


    public ConsoleStatusBuilder(ConsoleStatusFluent<?> fluent,ConsoleStatus instance) { 
        this(fluent, instance, true);
    }


    public ConsoleStatusBuilder(ConsoleStatusFluent<?> fluent,ConsoleStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withConditions(instance.getConditions()); 
        fluent.withGenerations(instance.getGenerations()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withReadyReplicas(instance.getReadyReplicas()); 
        fluent.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }


    public ConsoleStatusBuilder(ConsoleStatus instance) { 
        this(instance,true);
    }


    public ConsoleStatusBuilder(ConsoleStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withConditions(instance.getConditions()); 
        this.withGenerations(instance.getGenerations()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withReadyReplicas(instance.getReadyReplicas()); 
        this.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }


    public ConsoleStatus build() {
        ConsoleStatus buildable = new ConsoleStatus(fluent.getConditions(),fluent.getGenerations(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConsoleStatusBuilder that = (ConsoleStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
