package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface CSISnapshotControllerListFluent<A extends CSISnapshotControllerListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,CSISnapshotController item);
    public A setToItems(int index,CSISnapshotController item);
    public A addToItems(CSISnapshotController... items);
    public A addAllToItems(Collection<CSISnapshotController> items);
    public A removeFromItems(CSISnapshotController... items);
    public A removeAllFromItems(Collection<CSISnapshotController> items);
    public A removeMatchingFromItems(Predicate<CSISnapshotControllerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<CSISnapshotController> getItems();
    public List<CSISnapshotController> buildItems();
    public CSISnapshotController buildItem(int index);
    public CSISnapshotController buildFirstItem();
    public CSISnapshotController buildLastItem();
    public CSISnapshotController buildMatchingItem(Predicate<CSISnapshotControllerBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<CSISnapshotControllerBuilder> predicate);
    public A withItems(List<CSISnapshotController> items);
    public A withItems(CSISnapshotController... items);
    public Boolean hasItems();
    public CSISnapshotControllerListFluent.ItemsNested<A> addNewItem();
    public CSISnapshotControllerListFluent.ItemsNested<A> addNewItemLike(CSISnapshotController item);
    public CSISnapshotControllerListFluent.ItemsNested<A> setNewItemLike(int index,CSISnapshotController item);
    public CSISnapshotControllerListFluent.ItemsNested<A> editItem(int index);
    public CSISnapshotControllerListFluent.ItemsNested<A> editFirstItem();
    public CSISnapshotControllerListFluent.ItemsNested<A> editLastItem();
    public CSISnapshotControllerListFluent.ItemsNested<A> editMatchingItem(Predicate<CSISnapshotControllerBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CSISnapshotControllerFluent<CSISnapshotControllerListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
