package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class AdditionalNetworkDefinitionFluentImpl<A extends AdditionalNetworkDefinitionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AdditionalNetworkDefinitionFluent<A> {

    private String name;
    private String namespace;
    private String rawCNIConfig;
    private SimpleMacvlanConfigBuilder simpleMacvlanConfig;
    private String type;

    public AdditionalNetworkDefinitionFluentImpl() { 
    }


    public AdditionalNetworkDefinitionFluentImpl(AdditionalNetworkDefinition instance) { 
        this.withName(instance.getName()); 
        this.withNamespace(instance.getNamespace()); 
        this.withRawCNIConfig(instance.getRawCNIConfig()); 
        this.withSimpleMacvlanConfig(instance.getSimpleMacvlanConfig()); 
        this.withType(instance.getType()); 
    }


    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace=namespace; return (A) this;
    }

    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    public A withNewNamespace(String arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuilder arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public A withNewNamespace(StringBuffer arg1) {
        return (A)withNamespace(new String(arg1));
    }

    public String getRawCNIConfig() {
        return this.rawCNIConfig;
    }

    public A withRawCNIConfig(String rawCNIConfig) {
        this.rawCNIConfig=rawCNIConfig; return (A) this;
    }

    public Boolean hasRawCNIConfig() {
        return this.rawCNIConfig != null;
    }

    public A withNewRawCNIConfig(String arg1) {
        return (A)withRawCNIConfig(new String(arg1));
    }

    public A withNewRawCNIConfig(StringBuilder arg1) {
        return (A)withRawCNIConfig(new String(arg1));
    }

    public A withNewRawCNIConfig(StringBuffer arg1) {
        return (A)withRawCNIConfig(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSimpleMacvlanConfig instead.
 * @return The buildable object.
 */
@Deprecated public SimpleMacvlanConfig getSimpleMacvlanConfig() {
        return this.simpleMacvlanConfig!=null?this.simpleMacvlanConfig.build():null;
    }

    public SimpleMacvlanConfig buildSimpleMacvlanConfig() {
        return this.simpleMacvlanConfig!=null?this.simpleMacvlanConfig.build():null;
    }

    public A withSimpleMacvlanConfig(SimpleMacvlanConfig simpleMacvlanConfig) {
        _visitables.get("simpleMacvlanConfig").remove(this.simpleMacvlanConfig);
        if (simpleMacvlanConfig!=null){ this.simpleMacvlanConfig= new SimpleMacvlanConfigBuilder(simpleMacvlanConfig); _visitables.get("simpleMacvlanConfig").add(this.simpleMacvlanConfig);} return (A) this;
    }

    public Boolean hasSimpleMacvlanConfig() {
        return this.simpleMacvlanConfig != null;
    }

    public AdditionalNetworkDefinitionFluent.SimpleMacvlanConfigNested<A> withNewSimpleMacvlanConfig() {
        return new SimpleMacvlanConfigNestedImpl();
    }

    public AdditionalNetworkDefinitionFluent.SimpleMacvlanConfigNested<A> withNewSimpleMacvlanConfigLike(SimpleMacvlanConfig item) {
        return new SimpleMacvlanConfigNestedImpl(item);
    }

    public AdditionalNetworkDefinitionFluent.SimpleMacvlanConfigNested<A> editSimpleMacvlanConfig() {
        return withNewSimpleMacvlanConfigLike(getSimpleMacvlanConfig());
    }

    public AdditionalNetworkDefinitionFluent.SimpleMacvlanConfigNested<A> editOrNewSimpleMacvlanConfig() {
        return withNewSimpleMacvlanConfigLike(getSimpleMacvlanConfig() != null ? getSimpleMacvlanConfig(): new SimpleMacvlanConfigBuilder().build());
    }

    public AdditionalNetworkDefinitionFluent.SimpleMacvlanConfigNested<A> editOrNewSimpleMacvlanConfigLike(SimpleMacvlanConfig item) {
        return withNewSimpleMacvlanConfigLike(getSimpleMacvlanConfig() != null ? getSimpleMacvlanConfig(): item);
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AdditionalNetworkDefinitionFluentImpl that = (AdditionalNetworkDefinitionFluentImpl) o;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
        if (rawCNIConfig != null ? !rawCNIConfig.equals(that.rawCNIConfig) :that.rawCNIConfig != null) return false;
        if (simpleMacvlanConfig != null ? !simpleMacvlanConfig.equals(that.simpleMacvlanConfig) :that.simpleMacvlanConfig != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(name,  namespace,  rawCNIConfig,  simpleMacvlanConfig,  type,  super.hashCode());
    }

    public class SimpleMacvlanConfigNestedImpl<N> extends SimpleMacvlanConfigFluentImpl<AdditionalNetworkDefinitionFluent.SimpleMacvlanConfigNested<N>> implements AdditionalNetworkDefinitionFluent.SimpleMacvlanConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SimpleMacvlanConfigBuilder builder;

        SimpleMacvlanConfigNestedImpl(SimpleMacvlanConfig item) {
            this.builder = new SimpleMacvlanConfigBuilder(this, item);
        }

        SimpleMacvlanConfigNestedImpl() {
            this.builder = new SimpleMacvlanConfigBuilder(this);
        }

        public N and() {
             return (N) AdditionalNetworkDefinitionFluentImpl.this.withSimpleMacvlanConfig(builder.build());
        }

        public N endSimpleMacvlanConfig() {
             return and();
        }
    }


}
