package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class AccessLoggingFluentImpl<A extends AccessLoggingFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AccessLoggingFluent<A> {

    private LoggingDestinationBuilder destination;
    private List<IngressControllerCaptureHTTPCookieBuilder> httpCaptureCookies =  new ArrayList<IngressControllerCaptureHTTPCookieBuilder>();
    private IngressControllerCaptureHTTPHeadersBuilder httpCaptureHeaders;
    private String httpLogFormat;

    public AccessLoggingFluentImpl() { 
    }


    public AccessLoggingFluentImpl(AccessLogging instance) { 
        this.withDestination(instance.getDestination()); 
        this.withHttpCaptureCookies(instance.getHttpCaptureCookies()); 
        this.withHttpCaptureHeaders(instance.getHttpCaptureHeaders()); 
        this.withHttpLogFormat(instance.getHttpLogFormat()); 
    }


    
/**
 * This method has been deprecated, please use method buildDestination instead.
 * @return The buildable object.
 */
@Deprecated public LoggingDestination getDestination() {
        return this.destination!=null?this.destination.build():null;
    }

    public LoggingDestination buildDestination() {
        return this.destination!=null?this.destination.build():null;
    }

    public A withDestination(LoggingDestination destination) {
        _visitables.get("destination").remove(this.destination);
        if (destination!=null){ this.destination= new LoggingDestinationBuilder(destination); _visitables.get("destination").add(this.destination);} return (A) this;
    }

    public Boolean hasDestination() {
        return this.destination != null;
    }

    public AccessLoggingFluent.DestinationNested<A> withNewDestination() {
        return new DestinationNestedImpl();
    }

    public AccessLoggingFluent.DestinationNested<A> withNewDestinationLike(LoggingDestination item) {
        return new DestinationNestedImpl(item);
    }

    public AccessLoggingFluent.DestinationNested<A> editDestination() {
        return withNewDestinationLike(getDestination());
    }

    public AccessLoggingFluent.DestinationNested<A> editOrNewDestination() {
        return withNewDestinationLike(getDestination() != null ? getDestination(): new LoggingDestinationBuilder().build());
    }

    public AccessLoggingFluent.DestinationNested<A> editOrNewDestinationLike(LoggingDestination item) {
        return withNewDestinationLike(getDestination() != null ? getDestination(): item);
    }

    public A addToHttpCaptureCookies(int index,IngressControllerCaptureHTTPCookie item) {
        if (this.httpCaptureCookies == null) {this.httpCaptureCookies = new ArrayList<IngressControllerCaptureHTTPCookieBuilder>();}
        IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);_visitables.get("httpCaptureCookies").add(index >= 0 ? index : _visitables.get("httpCaptureCookies").size(), builder);this.httpCaptureCookies.add(index >= 0 ? index : httpCaptureCookies.size(), builder); return (A)this;
    }

    public A setToHttpCaptureCookies(int index,IngressControllerCaptureHTTPCookie item) {
        if (this.httpCaptureCookies == null) {this.httpCaptureCookies = new ArrayList<IngressControllerCaptureHTTPCookieBuilder>();}
        IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);
        if (index < 0 || index >= _visitables.get("httpCaptureCookies").size()) { _visitables.get("httpCaptureCookies").add(builder); } else { _visitables.get("httpCaptureCookies").set(index, builder);}
        if (index < 0 || index >= httpCaptureCookies.size()) { httpCaptureCookies.add(builder); } else { httpCaptureCookies.set(index, builder);}
         return (A)this;
    }

    public A addToHttpCaptureCookies(IngressControllerCaptureHTTPCookie... items) {
        if (this.httpCaptureCookies == null) {this.httpCaptureCookies = new ArrayList<IngressControllerCaptureHTTPCookieBuilder>();}
        for (IngressControllerCaptureHTTPCookie item : items) {IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);_visitables.get("httpCaptureCookies").add(builder);this.httpCaptureCookies.add(builder);} return (A)this;
    }

    public A addAllToHttpCaptureCookies(Collection<IngressControllerCaptureHTTPCookie> items) {
        if (this.httpCaptureCookies == null) {this.httpCaptureCookies = new ArrayList<IngressControllerCaptureHTTPCookieBuilder>();}
        for (IngressControllerCaptureHTTPCookie item : items) {IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);_visitables.get("httpCaptureCookies").add(builder);this.httpCaptureCookies.add(builder);} return (A)this;
    }

    public A removeFromHttpCaptureCookies(IngressControllerCaptureHTTPCookie... items) {
        for (IngressControllerCaptureHTTPCookie item : items) {IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);_visitables.get("httpCaptureCookies").remove(builder);if (this.httpCaptureCookies != null) {this.httpCaptureCookies.remove(builder);}} return (A)this;
    }

    public A removeAllFromHttpCaptureCookies(Collection<IngressControllerCaptureHTTPCookie> items) {
        for (IngressControllerCaptureHTTPCookie item : items) {IngressControllerCaptureHTTPCookieBuilder builder = new IngressControllerCaptureHTTPCookieBuilder(item);_visitables.get("httpCaptureCookies").remove(builder);if (this.httpCaptureCookies != null) {this.httpCaptureCookies.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromHttpCaptureCookies(Predicate<IngressControllerCaptureHTTPCookieBuilder> predicate) {
        if (httpCaptureCookies == null) return (A) this;
        final Iterator<IngressControllerCaptureHTTPCookieBuilder> each = httpCaptureCookies.iterator();
        final List visitables = _visitables.get("httpCaptureCookies");
        while (each.hasNext()) {
          IngressControllerCaptureHTTPCookieBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildHttpCaptureCookies instead.
 * @return The buildable object.
 */
@Deprecated public List<IngressControllerCaptureHTTPCookie> getHttpCaptureCookies() {
        return build(httpCaptureCookies);
    }

    public List<IngressControllerCaptureHTTPCookie> buildHttpCaptureCookies() {
        return build(httpCaptureCookies);
    }

    public IngressControllerCaptureHTTPCookie buildHttpCaptureCooky(int index) {
        return this.httpCaptureCookies.get(index).build();
    }

    public IngressControllerCaptureHTTPCookie buildFirstHttpCaptureCooky() {
        return this.httpCaptureCookies.get(0).build();
    }

    public IngressControllerCaptureHTTPCookie buildLastHttpCaptureCooky() {
        return this.httpCaptureCookies.get(httpCaptureCookies.size() - 1).build();
    }

    public IngressControllerCaptureHTTPCookie buildMatchingHttpCaptureCooky(Predicate<IngressControllerCaptureHTTPCookieBuilder> predicate) {
        for (IngressControllerCaptureHTTPCookieBuilder item: httpCaptureCookies) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingHttpCaptureCooky(Predicate<IngressControllerCaptureHTTPCookieBuilder> predicate) {
        for (IngressControllerCaptureHTTPCookieBuilder item: httpCaptureCookies) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withHttpCaptureCookies(List<IngressControllerCaptureHTTPCookie> httpCaptureCookies) {
        if (this.httpCaptureCookies != null) { _visitables.get("httpCaptureCookies").removeAll(this.httpCaptureCookies);}
        if (httpCaptureCookies != null) {this.httpCaptureCookies = new ArrayList<IngressControllerCaptureHTTPCookieBuilder>(); for (IngressControllerCaptureHTTPCookie item : httpCaptureCookies){this.addToHttpCaptureCookies(item);}} else { this.httpCaptureCookies = null;} return (A) this;
    }

    public A withHttpCaptureCookies(IngressControllerCaptureHTTPCookie... httpCaptureCookies) {
        if (this.httpCaptureCookies != null) {this.httpCaptureCookies.clear();}
        if (httpCaptureCookies != null) {for (IngressControllerCaptureHTTPCookie item :httpCaptureCookies){ this.addToHttpCaptureCookies(item);}} return (A) this;
    }

    public Boolean hasHttpCaptureCookies() {
        return httpCaptureCookies != null && !httpCaptureCookies.isEmpty();
    }

    public A addNewHttpCaptureCooky(String matchType,Integer maxLength,String name,String namePrefix) {
        return (A)addToHttpCaptureCookies(new IngressControllerCaptureHTTPCookie(matchType, maxLength, name, namePrefix));
    }

    public AccessLoggingFluent.HttpCaptureCookiesNested<A> addNewHttpCaptureCooky() {
        return new HttpCaptureCookiesNestedImpl();
    }

    public AccessLoggingFluent.HttpCaptureCookiesNested<A> addNewHttpCaptureCookyLike(IngressControllerCaptureHTTPCookie item) {
        return new HttpCaptureCookiesNestedImpl(-1, item);
    }

    public AccessLoggingFluent.HttpCaptureCookiesNested<A> setNewHttpCaptureCookyLike(int index,IngressControllerCaptureHTTPCookie item) {
        return new HttpCaptureCookiesNestedImpl(index, item);
    }

    public AccessLoggingFluent.HttpCaptureCookiesNested<A> editHttpCaptureCooky(int index) {
        if (httpCaptureCookies.size() <= index) throw new RuntimeException("Can't edit httpCaptureCookies. Index exceeds size.");
        return setNewHttpCaptureCookyLike(index, buildHttpCaptureCooky(index));
    }

    public AccessLoggingFluent.HttpCaptureCookiesNested<A> editFirstHttpCaptureCooky() {
        if (httpCaptureCookies.size() == 0) throw new RuntimeException("Can't edit first httpCaptureCookies. The list is empty.");
        return setNewHttpCaptureCookyLike(0, buildHttpCaptureCooky(0));
    }

    public AccessLoggingFluent.HttpCaptureCookiesNested<A> editLastHttpCaptureCooky() {
        int index = httpCaptureCookies.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last httpCaptureCookies. The list is empty.");
        return setNewHttpCaptureCookyLike(index, buildHttpCaptureCooky(index));
    }

    public AccessLoggingFluent.HttpCaptureCookiesNested<A> editMatchingHttpCaptureCooky(Predicate<IngressControllerCaptureHTTPCookieBuilder> predicate) {
        int index = -1;
        for (int i=0;i<httpCaptureCookies.size();i++) { 
        if (predicate.test(httpCaptureCookies.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching httpCaptureCookies. No match found.");
        return setNewHttpCaptureCookyLike(index, buildHttpCaptureCooky(index));
    }

    
/**
 * This method has been deprecated, please use method buildHttpCaptureHeaders instead.
 * @return The buildable object.
 */
@Deprecated public IngressControllerCaptureHTTPHeaders getHttpCaptureHeaders() {
        return this.httpCaptureHeaders!=null?this.httpCaptureHeaders.build():null;
    }

    public IngressControllerCaptureHTTPHeaders buildHttpCaptureHeaders() {
        return this.httpCaptureHeaders!=null?this.httpCaptureHeaders.build():null;
    }

    public A withHttpCaptureHeaders(IngressControllerCaptureHTTPHeaders httpCaptureHeaders) {
        _visitables.get("httpCaptureHeaders").remove(this.httpCaptureHeaders);
        if (httpCaptureHeaders!=null){ this.httpCaptureHeaders= new IngressControllerCaptureHTTPHeadersBuilder(httpCaptureHeaders); _visitables.get("httpCaptureHeaders").add(this.httpCaptureHeaders);} return (A) this;
    }

    public Boolean hasHttpCaptureHeaders() {
        return this.httpCaptureHeaders != null;
    }

    public AccessLoggingFluent.HttpCaptureHeadersNested<A> withNewHttpCaptureHeaders() {
        return new HttpCaptureHeadersNestedImpl();
    }

    public AccessLoggingFluent.HttpCaptureHeadersNested<A> withNewHttpCaptureHeadersLike(IngressControllerCaptureHTTPHeaders item) {
        return new HttpCaptureHeadersNestedImpl(item);
    }

    public AccessLoggingFluent.HttpCaptureHeadersNested<A> editHttpCaptureHeaders() {
        return withNewHttpCaptureHeadersLike(getHttpCaptureHeaders());
    }

    public AccessLoggingFluent.HttpCaptureHeadersNested<A> editOrNewHttpCaptureHeaders() {
        return withNewHttpCaptureHeadersLike(getHttpCaptureHeaders() != null ? getHttpCaptureHeaders(): new IngressControllerCaptureHTTPHeadersBuilder().build());
    }

    public AccessLoggingFluent.HttpCaptureHeadersNested<A> editOrNewHttpCaptureHeadersLike(IngressControllerCaptureHTTPHeaders item) {
        return withNewHttpCaptureHeadersLike(getHttpCaptureHeaders() != null ? getHttpCaptureHeaders(): item);
    }

    public String getHttpLogFormat() {
        return this.httpLogFormat;
    }

    public A withHttpLogFormat(String httpLogFormat) {
        this.httpLogFormat=httpLogFormat; return (A) this;
    }

    public Boolean hasHttpLogFormat() {
        return this.httpLogFormat != null;
    }

    public A withNewHttpLogFormat(String arg1) {
        return (A)withHttpLogFormat(new String(arg1));
    }

    public A withNewHttpLogFormat(StringBuilder arg1) {
        return (A)withHttpLogFormat(new String(arg1));
    }

    public A withNewHttpLogFormat(StringBuffer arg1) {
        return (A)withHttpLogFormat(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AccessLoggingFluentImpl that = (AccessLoggingFluentImpl) o;
        if (destination != null ? !destination.equals(that.destination) :that.destination != null) return false;
        if (httpCaptureCookies != null ? !httpCaptureCookies.equals(that.httpCaptureCookies) :that.httpCaptureCookies != null) return false;
        if (httpCaptureHeaders != null ? !httpCaptureHeaders.equals(that.httpCaptureHeaders) :that.httpCaptureHeaders != null) return false;
        if (httpLogFormat != null ? !httpLogFormat.equals(that.httpLogFormat) :that.httpLogFormat != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(destination,  httpCaptureCookies,  httpCaptureHeaders,  httpLogFormat,  super.hashCode());
    }

    public class DestinationNestedImpl<N> extends LoggingDestinationFluentImpl<AccessLoggingFluent.DestinationNested<N>> implements AccessLoggingFluent.DestinationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LoggingDestinationBuilder builder;

        DestinationNestedImpl(LoggingDestination item) {
            this.builder = new LoggingDestinationBuilder(this, item);
        }

        DestinationNestedImpl() {
            this.builder = new LoggingDestinationBuilder(this);
        }

        public N and() {
             return (N) AccessLoggingFluentImpl.this.withDestination(builder.build());
        }

        public N endDestination() {
             return and();
        }
    }


    public class HttpCaptureCookiesNestedImpl<N> extends IngressControllerCaptureHTTPCookieFluentImpl<AccessLoggingFluent.HttpCaptureCookiesNested<N>> implements AccessLoggingFluent.HttpCaptureCookiesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IngressControllerCaptureHTTPCookieBuilder builder;
        private final int index;

        HttpCaptureCookiesNestedImpl(int index,IngressControllerCaptureHTTPCookie item) {
            this.index = index;
            this.builder = new IngressControllerCaptureHTTPCookieBuilder(this, item);
        }

        HttpCaptureCookiesNestedImpl() {
            this.index = -1;
            this.builder = new IngressControllerCaptureHTTPCookieBuilder(this);
        }

        public N and() {
             return (N) AccessLoggingFluentImpl.this.setToHttpCaptureCookies(index,builder.build());
        }

        public N endHttpCaptureCooky() {
             return and();
        }
    }


    public class HttpCaptureHeadersNestedImpl<N> extends IngressControllerCaptureHTTPHeadersFluentImpl<AccessLoggingFluent.HttpCaptureHeadersNested<N>> implements AccessLoggingFluent.HttpCaptureHeadersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IngressControllerCaptureHTTPHeadersBuilder builder;

        HttpCaptureHeadersNestedImpl(IngressControllerCaptureHTTPHeaders item) {
            this.builder = new IngressControllerCaptureHTTPHeadersBuilder(this, item);
        }

        HttpCaptureHeadersNestedImpl() {
            this.builder = new IngressControllerCaptureHTTPHeadersBuilder(this);
        }

        public N and() {
             return (N) AccessLoggingFluentImpl.this.withHttpCaptureHeaders(builder.build());
        }

        public N endHttpCaptureHeaders() {
             return and();
        }
    }


}
