
package io.fabric8.openshift.api.model.operator.v1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.Toleration;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "affinity",
    "failedJobsHistoryLimit",
    "ignoreInvalidImageReferences",
    "keepTagRevisions",
    "keepYoungerThan",
    "keepYoungerThanDuration",
    "nodeSelector",
    "resources",
    "schedule",
    "successfulJobsHistoryLimit",
    "suspend",
    "tolerations"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(io.fabric8.kubernetes.api.model.ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class ImagePrunerSpec implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("affinity")
    private Affinity affinity;
    /**
     * 
     * 
     */
    @JsonProperty("failedJobsHistoryLimit")
    private Integer failedJobsHistoryLimit;
    /**
     * 
     * 
     */
    @JsonProperty("ignoreInvalidImageReferences")
    private Boolean ignoreInvalidImageReferences;
    /**
     * 
     * 
     */
    @JsonProperty("keepTagRevisions")
    private Integer keepTagRevisions;
    /**
     * 
     * 
     */
    @JsonProperty("keepYoungerThan")
    private Long keepYoungerThan;
    /**
     * 
     * 
     */
    @JsonProperty("keepYoungerThanDuration")
    private Duration keepYoungerThanDuration;
    /**
     * 
     * 
     */
    @JsonProperty("nodeSelector")
    private Map<String, String> nodeSelector;
    /**
     * 
     * 
     */
    @JsonProperty("resources")
    private io.fabric8.kubernetes.api.model.ResourceRequirements resources;
    /**
     * 
     * 
     */
    @JsonProperty("schedule")
    private java.lang.String schedule;
    /**
     * 
     * 
     */
    @JsonProperty("successfulJobsHistoryLimit")
    private Integer successfulJobsHistoryLimit;
    /**
     * 
     * 
     */
    @JsonProperty("suspend")
    private Boolean suspend;
    /**
     * 
     * 
     */
    @JsonProperty("tolerations")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<Toleration> tolerations = new ArrayList<Toleration>();
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ImagePrunerSpec() {
    }

    /**
     * 
     * @param suspend
     * @param schedule
     * @param ignoreInvalidImageReferences
     * @param tolerations
     * @param resources
     * @param failedJobsHistoryLimit
     * @param keepYoungerThan
     * @param keepYoungerThanDuration
     * @param keepTagRevisions
     * @param successfulJobsHistoryLimit
     * @param affinity
     * @param nodeSelector
     */
    public ImagePrunerSpec(Affinity affinity, Integer failedJobsHistoryLimit, Boolean ignoreInvalidImageReferences, Integer keepTagRevisions, Long keepYoungerThan, Duration keepYoungerThanDuration, Map<String, String> nodeSelector, io.fabric8.kubernetes.api.model.ResourceRequirements resources, java.lang.String schedule, Integer successfulJobsHistoryLimit, Boolean suspend, List<Toleration> tolerations) {
        this.affinity = affinity;
        this.failedJobsHistoryLimit = failedJobsHistoryLimit;
        this.ignoreInvalidImageReferences = ignoreInvalidImageReferences;
        this.keepTagRevisions = keepTagRevisions;
        this.keepYoungerThan = keepYoungerThan;
        this.keepYoungerThanDuration = keepYoungerThanDuration;
        this.nodeSelector = nodeSelector;
        this.resources = resources;
        this.schedule = schedule;
        this.successfulJobsHistoryLimit = successfulJobsHistoryLimit;
        this.suspend = suspend;
        this.tolerations = tolerations;
    }

    /**
     * 
     * 
     * @return
     *     The affinity
     */
    @JsonProperty("affinity")
    public Affinity getAffinity() {
        return affinity;
    }

    /**
     * 
     * 
     * @param affinity
     *     The affinity
     */
    @JsonProperty("affinity")
    public void setAffinity(Affinity affinity) {
        this.affinity = affinity;
    }

    /**
     * 
     * 
     * @return
     *     The failedJobsHistoryLimit
     */
    @JsonProperty("failedJobsHistoryLimit")
    public Integer getFailedJobsHistoryLimit() {
        return failedJobsHistoryLimit;
    }

    /**
     * 
     * 
     * @param failedJobsHistoryLimit
     *     The failedJobsHistoryLimit
     */
    @JsonProperty("failedJobsHistoryLimit")
    public void setFailedJobsHistoryLimit(Integer failedJobsHistoryLimit) {
        this.failedJobsHistoryLimit = failedJobsHistoryLimit;
    }

    /**
     * 
     * 
     * @return
     *     The ignoreInvalidImageReferences
     */
    @JsonProperty("ignoreInvalidImageReferences")
    public Boolean getIgnoreInvalidImageReferences() {
        return ignoreInvalidImageReferences;
    }

    /**
     * 
     * 
     * @param ignoreInvalidImageReferences
     *     The ignoreInvalidImageReferences
     */
    @JsonProperty("ignoreInvalidImageReferences")
    public void setIgnoreInvalidImageReferences(Boolean ignoreInvalidImageReferences) {
        this.ignoreInvalidImageReferences = ignoreInvalidImageReferences;
    }

    /**
     * 
     * 
     * @return
     *     The keepTagRevisions
     */
    @JsonProperty("keepTagRevisions")
    public Integer getKeepTagRevisions() {
        return keepTagRevisions;
    }

    /**
     * 
     * 
     * @param keepTagRevisions
     *     The keepTagRevisions
     */
    @JsonProperty("keepTagRevisions")
    public void setKeepTagRevisions(Integer keepTagRevisions) {
        this.keepTagRevisions = keepTagRevisions;
    }

    /**
     * 
     * 
     * @return
     *     The keepYoungerThan
     */
    @JsonProperty("keepYoungerThan")
    public Long getKeepYoungerThan() {
        return keepYoungerThan;
    }

    /**
     * 
     * 
     * @param keepYoungerThan
     *     The keepYoungerThan
     */
    @JsonProperty("keepYoungerThan")
    public void setKeepYoungerThan(Long keepYoungerThan) {
        this.keepYoungerThan = keepYoungerThan;
    }

    /**
     * 
     * 
     * @return
     *     The keepYoungerThanDuration
     */
    @JsonProperty("keepYoungerThanDuration")
    public Duration getKeepYoungerThanDuration() {
        return keepYoungerThanDuration;
    }

    /**
     * 
     * 
     * @param keepYoungerThanDuration
     *     The keepYoungerThanDuration
     */
    @JsonProperty("keepYoungerThanDuration")
    public void setKeepYoungerThanDuration(Duration keepYoungerThanDuration) {
        this.keepYoungerThanDuration = keepYoungerThanDuration;
    }

    /**
     * 
     * 
     * @return
     *     The nodeSelector
     */
    @JsonProperty("nodeSelector")
    public Map<String, String> getNodeSelector() {
        return nodeSelector;
    }

    /**
     * 
     * 
     * @param nodeSelector
     *     The nodeSelector
     */
    @JsonProperty("nodeSelector")
    public void setNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    /**
     * 
     * 
     * @return
     *     The resources
     */
    @JsonProperty("resources")
    public io.fabric8.kubernetes.api.model.ResourceRequirements getResources() {
        return resources;
    }

    /**
     * 
     * 
     * @param resources
     *     The resources
     */
    @JsonProperty("resources")
    public void setResources(io.fabric8.kubernetes.api.model.ResourceRequirements resources) {
        this.resources = resources;
    }

    /**
     * 
     * 
     * @return
     *     The schedule
     */
    @JsonProperty("schedule")
    public java.lang.String getSchedule() {
        return schedule;
    }

    /**
     * 
     * 
     * @param schedule
     *     The schedule
     */
    @JsonProperty("schedule")
    public void setSchedule(java.lang.String schedule) {
        this.schedule = schedule;
    }

    /**
     * 
     * 
     * @return
     *     The successfulJobsHistoryLimit
     */
    @JsonProperty("successfulJobsHistoryLimit")
    public Integer getSuccessfulJobsHistoryLimit() {
        return successfulJobsHistoryLimit;
    }

    /**
     * 
     * 
     * @param successfulJobsHistoryLimit
     *     The successfulJobsHistoryLimit
     */
    @JsonProperty("successfulJobsHistoryLimit")
    public void setSuccessfulJobsHistoryLimit(Integer successfulJobsHistoryLimit) {
        this.successfulJobsHistoryLimit = successfulJobsHistoryLimit;
    }

    /**
     * 
     * 
     * @return
     *     The suspend
     */
    @JsonProperty("suspend")
    public Boolean getSuspend() {
        return suspend;
    }

    /**
     * 
     * 
     * @param suspend
     *     The suspend
     */
    @JsonProperty("suspend")
    public void setSuspend(Boolean suspend) {
        this.suspend = suspend;
    }

    /**
     * 
     * 
     * @return
     *     The tolerations
     */
    @JsonProperty("tolerations")
    public List<Toleration> getTolerations() {
        return tolerations;
    }

    /**
     * 
     * 
     * @param tolerations
     *     The tolerations
     */
    @JsonProperty("tolerations")
    public void setTolerations(List<Toleration> tolerations) {
        this.tolerations = tolerations;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
