
package io.fabric8.openshift.api.model.operator.v1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "dnsName",
    "recordTTL",
    "recordType",
    "targets"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class DNSRecordSpec implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("dnsName")
    private String dnsName;
    /**
     * 
     * 
     */
    @JsonProperty("recordTTL")
    private Long recordTTL;
    /**
     * 
     * 
     */
    @JsonProperty("recordType")
    private String recordType;
    /**
     * 
     * 
     */
    @JsonProperty("targets")
    private List<String> targets = new ArrayList<String>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public DNSRecordSpec() {
    }

    /**
     * 
     * @param recordTTL
     * @param recordType
     * @param dnsName
     * @param targets
     */
    public DNSRecordSpec(String dnsName, Long recordTTL, String recordType, List<String> targets) {
        this.dnsName = dnsName;
        this.recordTTL = recordTTL;
        this.recordType = recordType;
        this.targets = targets;
    }

    /**
     * 
     * 
     * @return
     *     The dnsName
     */
    @JsonProperty("dnsName")
    public String getDnsName() {
        return dnsName;
    }

    /**
     * 
     * 
     * @param dnsName
     *     The dnsName
     */
    @JsonProperty("dnsName")
    public void setDnsName(String dnsName) {
        this.dnsName = dnsName;
    }

    /**
     * 
     * 
     * @return
     *     The recordTTL
     */
    @JsonProperty("recordTTL")
    public Long getRecordTTL() {
        return recordTTL;
    }

    /**
     * 
     * 
     * @param recordTTL
     *     The recordTTL
     */
    @JsonProperty("recordTTL")
    public void setRecordTTL(Long recordTTL) {
        this.recordTTL = recordTTL;
    }

    /**
     * 
     * 
     * @return
     *     The recordType
     */
    @JsonProperty("recordType")
    public String getRecordType() {
        return recordType;
    }

    /**
     * 
     * 
     * @param recordType
     *     The recordType
     */
    @JsonProperty("recordType")
    public void setRecordType(String recordType) {
        this.recordType = recordType;
    }

    /**
     * 
     * 
     * @return
     *     The targets
     */
    @JsonProperty("targets")
    public List<String> getTargets() {
        return targets;
    }

    /**
     * 
     * 
     * @param targets
     *     The targets
     */
    @JsonProperty("targets")
    public void setTargets(List<String> targets) {
        this.targets = targets;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
