package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CustomTLSProfileBuilder extends CustomTLSProfileFluentImpl<CustomTLSProfileBuilder> implements VisitableBuilder<CustomTLSProfile,CustomTLSProfileBuilder> {

    CustomTLSProfileFluent<?> fluent;
    Boolean validationEnabled;

    public CustomTLSProfileBuilder() { 
        this(true);
    }


    public CustomTLSProfileBuilder(Boolean validationEnabled) { 
        this(new CustomTLSProfile(), validationEnabled);
    }


    public CustomTLSProfileBuilder(CustomTLSProfileFluent<?> fluent) { 
        this(fluent, true);
    }


    public CustomTLSProfileBuilder(CustomTLSProfileFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new CustomTLSProfile(), validationEnabled);
    }


    public CustomTLSProfileBuilder(CustomTLSProfileFluent<?> fluent,CustomTLSProfile instance) { 
        this(fluent, instance, true);
    }


    public CustomTLSProfileBuilder(CustomTLSProfileFluent<?> fluent,CustomTLSProfile instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withCiphers(instance.getCiphers()); 
        fluent.withMinTLSVersion(instance.getMinTLSVersion()); 
        this.validationEnabled = validationEnabled; 
    }


    public CustomTLSProfileBuilder(CustomTLSProfile instance) { 
        this(instance,true);
    }


    public CustomTLSProfileBuilder(CustomTLSProfile instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withCiphers(instance.getCiphers()); 
        this.withMinTLSVersion(instance.getMinTLSVersion()); 
        this.validationEnabled = validationEnabled; 
    }


    public CustomTLSProfile build() {
        CustomTLSProfile buildable = new CustomTLSProfile(fluent.getCiphers(),fluent.getMinTLSVersion());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CustomTLSProfileBuilder that = (CustomTLSProfileBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
