package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Object;
import java.lang.Deprecated;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy;
import java.lang.StringBuffer;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder;

public class OpenShiftAPIServerSpecFluentImpl<A extends OpenShiftAPIServerSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements OpenShiftAPIServerSpecFluent<A> {

    private String logLevel;
    private String managementState;
    private VisitableBuilder<? extends HasMetadata,?> observedConfig;
    private String operatorLogLevel;
    private VisitableBuilder<? extends HasMetadata,?> unsupportedConfigOverrides;

    public OpenShiftAPIServerSpecFluentImpl() { 
    }


    public OpenShiftAPIServerSpecFluentImpl(OpenShiftAPIServerSpec instance) { 
        this.withLogLevel(instance.getLogLevel()); 
        this.withManagementState(instance.getManagementState()); 
        this.withObservedConfig(instance.getObservedConfig()); 
        this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
        this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
    }


    public String getLogLevel() {
        return this.logLevel;
    }

    public A withLogLevel(String logLevel) {
        this.logLevel=logLevel; return (A) this;
    }

    public Boolean hasLogLevel() {
        return this.logLevel != null;
    }

    public A withNewLogLevel(String arg1) {
        return (A)withLogLevel(new String(arg1));
    }

    public A withNewLogLevel(StringBuilder arg1) {
        return (A)withLogLevel(new String(arg1));
    }

    public A withNewLogLevel(StringBuffer arg1) {
        return (A)withLogLevel(new String(arg1));
    }

    public String getManagementState() {
        return this.managementState;
    }

    public A withManagementState(String managementState) {
        this.managementState=managementState; return (A) this;
    }

    public Boolean hasManagementState() {
        return this.managementState != null;
    }

    public A withNewManagementState(String arg1) {
        return (A)withManagementState(new String(arg1));
    }

    public A withNewManagementState(StringBuilder arg1) {
        return (A)withManagementState(new String(arg1));
    }

    public A withNewManagementState(StringBuffer arg1) {
        return (A)withManagementState(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildObservedConfig instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getObservedConfig() {
        return this.observedConfig!=null?this.observedConfig.build():null;
    }

    public HasMetadata buildObservedConfig() {
        return this.observedConfig!=null?this.observedConfig.build():null;
    }

    public A withObservedConfig(HasMetadata observedConfig) {
        if (observedConfig instanceof ImagePruner){ this.observedConfig= new ImagePrunerBuilder((ImagePruner)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof KubeControllerManager){ this.observedConfig= new KubeControllerManagerBuilder((KubeControllerManager)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof ImageContentSourcePolicy){ this.observedConfig= new ImageContentSourcePolicyBuilder((ImageContentSourcePolicy)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof ServiceCA){ this.observedConfig= new ServiceCABuilder((ServiceCA)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof PersistentVolumeClaim){ this.observedConfig= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof KubeAPIServer){ this.observedConfig= new KubeAPIServerBuilder((KubeAPIServer)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof IngressController){ this.observedConfig= new IngressControllerBuilder((IngressController)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof KubeStorageVersionMigrator){ this.observedConfig= new KubeStorageVersionMigratorBuilder((KubeStorageVersionMigrator)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof Console){ this.observedConfig= new ConsoleBuilder((Console)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof OpenShiftControllerManager){ this.observedConfig= new OpenShiftControllerManagerBuilder((OpenShiftControllerManager)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof Etcd){ this.observedConfig= new EtcdBuilder((Etcd)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof KubeScheduler){ this.observedConfig= new KubeSchedulerBuilder((KubeScheduler)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof Network){ this.observedConfig= new NetworkBuilder((Network)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof ServiceCatalogAPIServer){ this.observedConfig= new ServiceCatalogAPIServerBuilder((ServiceCatalogAPIServer)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof CSISnapshotController){ this.observedConfig= new CSISnapshotControllerBuilder((CSISnapshotController)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof ServiceCatalogControllerManager){ this.observedConfig= new ServiceCatalogControllerManagerBuilder((ServiceCatalogControllerManager)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof DNS){ this.observedConfig= new DNSBuilder((DNS)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof DNSRecord){ this.observedConfig= new DNSRecordBuilder((DNSRecord)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof OpenShiftAPIServer){ this.observedConfig= new OpenShiftAPIServerBuilder((OpenShiftAPIServer)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        if (observedConfig instanceof Authentication){ this.observedConfig= new AuthenticationBuilder((Authentication)observedConfig); _visitables.get("observedConfig").add(this.observedConfig);}
        return (A) this;
    }

    public Boolean hasObservedConfig() {
        return this.observedConfig != null;
    }

    public A withImagePrunerObservedConfig(ImagePruner imagePrunerObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (imagePrunerObservedConfig!=null){ this.observedConfig= new ImagePrunerBuilder(imagePrunerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfig() {
        return new ImagePrunerObservedConfigNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.ImagePrunerObservedConfigNested<A> withNewImagePrunerObservedConfigLike(ImagePruner item) {
        return new ImagePrunerObservedConfigNestedImpl(item);
    }

    public A withKubeControllerManagerObservedConfig(KubeControllerManager kubeControllerManagerObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (kubeControllerManagerObservedConfig!=null){ this.observedConfig= new KubeControllerManagerBuilder(kubeControllerManagerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfig() {
        return new KubeControllerManagerObservedConfigNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.KubeControllerManagerObservedConfigNested<A> withNewKubeControllerManagerObservedConfigLike(KubeControllerManager item) {
        return new KubeControllerManagerObservedConfigNestedImpl(item);
    }

    public A withImageContentSourcePolicyObservedConfig(ImageContentSourcePolicy imageContentSourcePolicyObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (imageContentSourcePolicyObservedConfig!=null){ this.observedConfig= new ImageContentSourcePolicyBuilder(imageContentSourcePolicyObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfig() {
        return new ImageContentSourcePolicyObservedConfigNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.ImageContentSourcePolicyObservedConfigNested<A> withNewImageContentSourcePolicyObservedConfigLike(ImageContentSourcePolicy item) {
        return new ImageContentSourcePolicyObservedConfigNestedImpl(item);
    }

    public A withServiceCAObservedConfig(ServiceCA serviceCAObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (serviceCAObservedConfig!=null){ this.observedConfig= new ServiceCABuilder(serviceCAObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfig() {
        return new ServiceCAObservedConfigNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.ServiceCAObservedConfigNested<A> withNewServiceCAObservedConfigLike(ServiceCA item) {
        return new ServiceCAObservedConfigNestedImpl(item);
    }

    public A withPersistentVolumeClaimObservedConfig(PersistentVolumeClaim persistentVolumeClaimObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (persistentVolumeClaimObservedConfig!=null){ this.observedConfig= new PersistentVolumeClaimBuilder(persistentVolumeClaimObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfig() {
        return new PersistentVolumeClaimObservedConfigNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.PersistentVolumeClaimObservedConfigNested<A> withNewPersistentVolumeClaimObservedConfigLike(PersistentVolumeClaim item) {
        return new PersistentVolumeClaimObservedConfigNestedImpl(item);
    }

    public A withKubeAPIServerObservedConfig(KubeAPIServer kubeAPIServerObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (kubeAPIServerObservedConfig!=null){ this.observedConfig= new KubeAPIServerBuilder(kubeAPIServerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfig() {
        return new KubeAPIServerObservedConfigNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.KubeAPIServerObservedConfigNested<A> withNewKubeAPIServerObservedConfigLike(KubeAPIServer item) {
        return new KubeAPIServerObservedConfigNestedImpl(item);
    }

    public A withIngressControllerObservedConfig(IngressController ingressControllerObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (ingressControllerObservedConfig!=null){ this.observedConfig= new IngressControllerBuilder(ingressControllerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfig() {
        return new IngressControllerObservedConfigNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.IngressControllerObservedConfigNested<A> withNewIngressControllerObservedConfigLike(IngressController item) {
        return new IngressControllerObservedConfigNestedImpl(item);
    }

    public A withKubeStorageVersionMigratorObservedConfig(KubeStorageVersionMigrator kubeStorageVersionMigratorObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (kubeStorageVersionMigratorObservedConfig!=null){ this.observedConfig= new KubeStorageVersionMigratorBuilder(kubeStorageVersionMigratorObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfig() {
        return new KubeStorageVersionMigratorObservedConfigNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.KubeStorageVersionMigratorObservedConfigNested<A> withNewKubeStorageVersionMigratorObservedConfigLike(KubeStorageVersionMigrator item) {
        return new KubeStorageVersionMigratorObservedConfigNestedImpl(item);
    }

    public A withConsoleObservedConfig(Console consoleObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (consoleObservedConfig!=null){ this.observedConfig= new ConsoleBuilder(consoleObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfig() {
        return new ConsoleObservedConfigNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.ConsoleObservedConfigNested<A> withNewConsoleObservedConfigLike(Console item) {
        return new ConsoleObservedConfigNestedImpl(item);
    }

    public A withOpenShiftControllerManagerObservedConfig(OpenShiftControllerManager openShiftControllerManagerObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (openShiftControllerManagerObservedConfig!=null){ this.observedConfig= new OpenShiftControllerManagerBuilder(openShiftControllerManagerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfig() {
        return new OpenShiftControllerManagerObservedConfigNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.OpenShiftControllerManagerObservedConfigNested<A> withNewOpenShiftControllerManagerObservedConfigLike(OpenShiftControllerManager item) {
        return new OpenShiftControllerManagerObservedConfigNestedImpl(item);
    }

    public A withEtcdObservedConfig(Etcd etcdObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (etcdObservedConfig!=null){ this.observedConfig= new EtcdBuilder(etcdObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfig() {
        return new EtcdObservedConfigNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.EtcdObservedConfigNested<A> withNewEtcdObservedConfigLike(Etcd item) {
        return new EtcdObservedConfigNestedImpl(item);
    }

    public A withKubeSchedulerObservedConfig(KubeScheduler kubeSchedulerObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (kubeSchedulerObservedConfig!=null){ this.observedConfig= new KubeSchedulerBuilder(kubeSchedulerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfig() {
        return new KubeSchedulerObservedConfigNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.KubeSchedulerObservedConfigNested<A> withNewKubeSchedulerObservedConfigLike(KubeScheduler item) {
        return new KubeSchedulerObservedConfigNestedImpl(item);
    }

    public A withNetworkObservedConfig(Network networkObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (networkObservedConfig!=null){ this.observedConfig= new NetworkBuilder(networkObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfig() {
        return new NetworkObservedConfigNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.NetworkObservedConfigNested<A> withNewNetworkObservedConfigLike(Network item) {
        return new NetworkObservedConfigNestedImpl(item);
    }

    public A withServiceCatalogAPIServerObservedConfig(ServiceCatalogAPIServer serviceCatalogAPIServerObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (serviceCatalogAPIServerObservedConfig!=null){ this.observedConfig= new ServiceCatalogAPIServerBuilder(serviceCatalogAPIServerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfig() {
        return new ServiceCatalogAPIServerObservedConfigNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.ServiceCatalogAPIServerObservedConfigNested<A> withNewServiceCatalogAPIServerObservedConfigLike(ServiceCatalogAPIServer item) {
        return new ServiceCatalogAPIServerObservedConfigNestedImpl(item);
    }

    public A withCSISnapshotControllerObservedConfig(CSISnapshotController cSISnapshotControllerObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (cSISnapshotControllerObservedConfig!=null){ this.observedConfig= new CSISnapshotControllerBuilder(cSISnapshotControllerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfig() {
        return new CSISnapshotControllerObservedConfigNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.CSISnapshotControllerObservedConfigNested<A> withNewCSISnapshotControllerObservedConfigLike(CSISnapshotController item) {
        return new CSISnapshotControllerObservedConfigNestedImpl(item);
    }

    public A withServiceCatalogControllerManagerObservedConfig(ServiceCatalogControllerManager serviceCatalogControllerManagerObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (serviceCatalogControllerManagerObservedConfig!=null){ this.observedConfig= new ServiceCatalogControllerManagerBuilder(serviceCatalogControllerManagerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfig() {
        return new ServiceCatalogControllerManagerObservedConfigNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<A> withNewServiceCatalogControllerManagerObservedConfigLike(ServiceCatalogControllerManager item) {
        return new ServiceCatalogControllerManagerObservedConfigNestedImpl(item);
    }

    public A withDNSObservedConfig(DNS dNSObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (dNSObservedConfig!=null){ this.observedConfig= new DNSBuilder(dNSObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfig() {
        return new DNSObservedConfigNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.DNSObservedConfigNested<A> withNewDNSObservedConfigLike(DNS item) {
        return new DNSObservedConfigNestedImpl(item);
    }

    public A withDNSRecordObservedConfig(DNSRecord dNSRecordObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (dNSRecordObservedConfig!=null){ this.observedConfig= new DNSRecordBuilder(dNSRecordObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfig() {
        return new DNSRecordObservedConfigNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.DNSRecordObservedConfigNested<A> withNewDNSRecordObservedConfigLike(DNSRecord item) {
        return new DNSRecordObservedConfigNestedImpl(item);
    }

    public A withOpenShiftAPIServerObservedConfig(OpenShiftAPIServer openShiftAPIServerObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (openShiftAPIServerObservedConfig!=null){ this.observedConfig= new OpenShiftAPIServerBuilder(openShiftAPIServerObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfig() {
        return new OpenShiftAPIServerObservedConfigNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.OpenShiftAPIServerObservedConfigNested<A> withNewOpenShiftAPIServerObservedConfigLike(OpenShiftAPIServer item) {
        return new OpenShiftAPIServerObservedConfigNestedImpl(item);
    }

    public A withAuthenticationObservedConfig(Authentication authenticationObservedConfig) {
        _visitables.get("observedConfig").remove(this.observedConfig);
        if (authenticationObservedConfig!=null){ this.observedConfig= new AuthenticationBuilder(authenticationObservedConfig); _visitables.get("observedConfig").add(this.observedConfig);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfig() {
        return new AuthenticationObservedConfigNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.AuthenticationObservedConfigNested<A> withNewAuthenticationObservedConfigLike(Authentication item) {
        return new AuthenticationObservedConfigNestedImpl(item);
    }

    public String getOperatorLogLevel() {
        return this.operatorLogLevel;
    }

    public A withOperatorLogLevel(String operatorLogLevel) {
        this.operatorLogLevel=operatorLogLevel; return (A) this;
    }

    public Boolean hasOperatorLogLevel() {
        return this.operatorLogLevel != null;
    }

    public A withNewOperatorLogLevel(String arg1) {
        return (A)withOperatorLogLevel(new String(arg1));
    }

    public A withNewOperatorLogLevel(StringBuilder arg1) {
        return (A)withOperatorLogLevel(new String(arg1));
    }

    public A withNewOperatorLogLevel(StringBuffer arg1) {
        return (A)withOperatorLogLevel(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildUnsupportedConfigOverrides instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getUnsupportedConfigOverrides() {
        return this.unsupportedConfigOverrides!=null?this.unsupportedConfigOverrides.build():null;
    }

    public HasMetadata buildUnsupportedConfigOverrides() {
        return this.unsupportedConfigOverrides!=null?this.unsupportedConfigOverrides.build():null;
    }

    public A withUnsupportedConfigOverrides(HasMetadata unsupportedConfigOverrides) {
        if (unsupportedConfigOverrides instanceof ImagePruner){ this.unsupportedConfigOverrides= new ImagePrunerBuilder((ImagePruner)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof KubeControllerManager){ this.unsupportedConfigOverrides= new KubeControllerManagerBuilder((KubeControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof ImageContentSourcePolicy){ this.unsupportedConfigOverrides= new ImageContentSourcePolicyBuilder((ImageContentSourcePolicy)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof ServiceCA){ this.unsupportedConfigOverrides= new ServiceCABuilder((ServiceCA)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof PersistentVolumeClaim){ this.unsupportedConfigOverrides= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof KubeAPIServer){ this.unsupportedConfigOverrides= new KubeAPIServerBuilder((KubeAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof IngressController){ this.unsupportedConfigOverrides= new IngressControllerBuilder((IngressController)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof KubeStorageVersionMigrator){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorBuilder((KubeStorageVersionMigrator)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof Console){ this.unsupportedConfigOverrides= new ConsoleBuilder((Console)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof OpenShiftControllerManager){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerBuilder((OpenShiftControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof Etcd){ this.unsupportedConfigOverrides= new EtcdBuilder((Etcd)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof KubeScheduler){ this.unsupportedConfigOverrides= new KubeSchedulerBuilder((KubeScheduler)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof Network){ this.unsupportedConfigOverrides= new NetworkBuilder((Network)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof ServiceCatalogAPIServer){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerBuilder((ServiceCatalogAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof CSISnapshotController){ this.unsupportedConfigOverrides= new CSISnapshotControllerBuilder((CSISnapshotController)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof ServiceCatalogControllerManager){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerBuilder((ServiceCatalogControllerManager)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof DNS){ this.unsupportedConfigOverrides= new DNSBuilder((DNS)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof DNSRecord){ this.unsupportedConfigOverrides= new DNSRecordBuilder((DNSRecord)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof OpenShiftAPIServer){ this.unsupportedConfigOverrides= new OpenShiftAPIServerBuilder((OpenShiftAPIServer)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        if (unsupportedConfigOverrides instanceof Authentication){ this.unsupportedConfigOverrides= new AuthenticationBuilder((Authentication)unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);}
        return (A) this;
    }

    public Boolean hasUnsupportedConfigOverrides() {
        return this.unsupportedConfigOverrides != null;
    }

    public A withImagePrunerUnsupportedConfigOverrides(ImagePruner imagePrunerUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (imagePrunerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ImagePrunerBuilder(imagePrunerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverrides() {
        return new ImagePrunerUnsupportedConfigOverridesNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverridesLike(ImagePruner item) {
        return new ImagePrunerUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withKubeControllerManagerUnsupportedConfigOverrides(KubeControllerManager kubeControllerManagerUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (kubeControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeControllerManagerBuilder(kubeControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverrides() {
        return new KubeControllerManagerUnsupportedConfigOverridesNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverridesLike(KubeControllerManager item) {
        return new KubeControllerManagerUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withImageContentSourcePolicyUnsupportedConfigOverrides(ImageContentSourcePolicy imageContentSourcePolicyUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (imageContentSourcePolicyUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ImageContentSourcePolicyBuilder(imageContentSourcePolicyUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverrides() {
        return new ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverridesLike(ImageContentSourcePolicy item) {
        return new ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withServiceCAUnsupportedConfigOverrides(ServiceCA serviceCAUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (serviceCAUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCABuilder(serviceCAUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverrides() {
        return new ServiceCAUnsupportedConfigOverridesNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverridesLike(ServiceCA item) {
        return new ServiceCAUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withPersistentVolumeClaimUnsupportedConfigOverrides(PersistentVolumeClaim persistentVolumeClaimUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (persistentVolumeClaimUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new PersistentVolumeClaimBuilder(persistentVolumeClaimUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverrides() {
        return new PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverridesLike(PersistentVolumeClaim item) {
        return new PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withKubeAPIServerUnsupportedConfigOverrides(KubeAPIServer kubeAPIServerUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (kubeAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeAPIServerBuilder(kubeAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverrides() {
        return new KubeAPIServerUnsupportedConfigOverridesNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverridesLike(KubeAPIServer item) {
        return new KubeAPIServerUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withIngressControllerUnsupportedConfigOverrides(IngressController ingressControllerUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (ingressControllerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new IngressControllerBuilder(ingressControllerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverrides() {
        return new IngressControllerUnsupportedConfigOverridesNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverridesLike(IngressController item) {
        return new IngressControllerUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withKubeStorageVersionMigratorUnsupportedConfigOverrides(KubeStorageVersionMigrator kubeStorageVersionMigratorUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (kubeStorageVersionMigratorUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeStorageVersionMigratorBuilder(kubeStorageVersionMigratorUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverrides() {
        return new KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverridesLike(KubeStorageVersionMigrator item) {
        return new KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withConsoleUnsupportedConfigOverrides(Console consoleUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (consoleUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ConsoleBuilder(consoleUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverrides() {
        return new ConsoleUnsupportedConfigOverridesNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverridesLike(Console item) {
        return new ConsoleUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withOpenShiftControllerManagerUnsupportedConfigOverrides(OpenShiftControllerManager openShiftControllerManagerUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (openShiftControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftControllerManagerBuilder(openShiftControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverrides() {
        return new OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverridesLike(OpenShiftControllerManager item) {
        return new OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withEtcdUnsupportedConfigOverrides(Etcd etcdUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (etcdUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new EtcdBuilder(etcdUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverrides() {
        return new EtcdUnsupportedConfigOverridesNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverridesLike(Etcd item) {
        return new EtcdUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withKubeSchedulerUnsupportedConfigOverrides(KubeScheduler kubeSchedulerUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (kubeSchedulerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new KubeSchedulerBuilder(kubeSchedulerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverrides() {
        return new KubeSchedulerUnsupportedConfigOverridesNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverridesLike(KubeScheduler item) {
        return new KubeSchedulerUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withNetworkUnsupportedConfigOverrides(Network networkUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (networkUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new NetworkBuilder(networkUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverrides() {
        return new NetworkUnsupportedConfigOverridesNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverridesLike(Network item) {
        return new NetworkUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withServiceCatalogAPIServerUnsupportedConfigOverrides(ServiceCatalogAPIServer serviceCatalogAPIServerUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (serviceCatalogAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogAPIServerBuilder(serviceCatalogAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverrides() {
        return new ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverridesLike(ServiceCatalogAPIServer item) {
        return new ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withCSISnapshotControllerUnsupportedConfigOverrides(CSISnapshotController cSISnapshotControllerUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (cSISnapshotControllerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new CSISnapshotControllerBuilder(cSISnapshotControllerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverrides() {
        return new CSISnapshotControllerUnsupportedConfigOverridesNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverridesLike(CSISnapshotController item) {
        return new CSISnapshotControllerUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withServiceCatalogControllerManagerUnsupportedConfigOverrides(ServiceCatalogControllerManager serviceCatalogControllerManagerUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (serviceCatalogControllerManagerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new ServiceCatalogControllerManagerBuilder(serviceCatalogControllerManagerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverrides() {
        return new ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverridesLike(ServiceCatalogControllerManager item) {
        return new ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withDNSUnsupportedConfigOverrides(DNS dNSUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (dNSUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSBuilder(dNSUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverrides() {
        return new DNSUnsupportedConfigOverridesNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverridesLike(DNS item) {
        return new DNSUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withDNSRecordUnsupportedConfigOverrides(DNSRecord dNSRecordUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (dNSRecordUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new DNSRecordBuilder(dNSRecordUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverrides() {
        return new DNSRecordUnsupportedConfigOverridesNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverridesLike(DNSRecord item) {
        return new DNSRecordUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withOpenShiftAPIServerUnsupportedConfigOverrides(OpenShiftAPIServer openShiftAPIServerUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (openShiftAPIServerUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new OpenShiftAPIServerBuilder(openShiftAPIServerUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverrides() {
        return new OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverridesLike(OpenShiftAPIServer item) {
        return new OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl(item);
    }

    public A withAuthenticationUnsupportedConfigOverrides(Authentication authenticationUnsupportedConfigOverrides) {
        _visitables.get("unsupportedConfigOverrides").remove(this.unsupportedConfigOverrides);
        if (authenticationUnsupportedConfigOverrides!=null){ this.unsupportedConfigOverrides= new AuthenticationBuilder(authenticationUnsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").add(this.unsupportedConfigOverrides);} return (A) this;
    }

    public OpenShiftAPIServerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverrides() {
        return new AuthenticationUnsupportedConfigOverridesNestedImpl();
    }

    public OpenShiftAPIServerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverridesLike(Authentication item) {
        return new AuthenticationUnsupportedConfigOverridesNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OpenShiftAPIServerSpecFluentImpl that = (OpenShiftAPIServerSpecFluentImpl) o;
        if (logLevel != null ? !logLevel.equals(that.logLevel) :that.logLevel != null) return false;
        if (managementState != null ? !managementState.equals(that.managementState) :that.managementState != null) return false;
        if (observedConfig != null ? !observedConfig.equals(that.observedConfig) :that.observedConfig != null) return false;
        if (operatorLogLevel != null ? !operatorLogLevel.equals(that.operatorLogLevel) :that.operatorLogLevel != null) return false;
        if (unsupportedConfigOverrides != null ? !unsupportedConfigOverrides.equals(that.unsupportedConfigOverrides) :that.unsupportedConfigOverrides != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(logLevel,  managementState,  observedConfig,  operatorLogLevel,  unsupportedConfigOverrides,  super.hashCode());
    }

    public class ImagePrunerObservedConfigNestedImpl<N> extends ImagePrunerFluentImpl<OpenShiftAPIServerSpecFluent.ImagePrunerObservedConfigNested<N>> implements OpenShiftAPIServerSpecFluent.ImagePrunerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ImagePrunerBuilder builder;

        ImagePrunerObservedConfigNestedImpl(ImagePruner item) {
            this.builder = new ImagePrunerBuilder(this, item);
        }

        ImagePrunerObservedConfigNestedImpl() {
            this.builder = new ImagePrunerBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withObservedConfig(builder.build());
        }

        public N endImagePrunerObservedConfig() {
             return and();
        }
    }


    public class KubeControllerManagerObservedConfigNestedImpl<N> extends KubeControllerManagerFluentImpl<OpenShiftAPIServerSpecFluent.KubeControllerManagerObservedConfigNested<N>> implements OpenShiftAPIServerSpecFluent.KubeControllerManagerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KubeControllerManagerBuilder builder;

        KubeControllerManagerObservedConfigNestedImpl(KubeControllerManager item) {
            this.builder = new KubeControllerManagerBuilder(this, item);
        }

        KubeControllerManagerObservedConfigNestedImpl() {
            this.builder = new KubeControllerManagerBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withObservedConfig(builder.build());
        }

        public N endKubeControllerManagerObservedConfig() {
             return and();
        }
    }


    public class ImageContentSourcePolicyObservedConfigNestedImpl<N> extends ImageContentSourcePolicyFluentImpl<OpenShiftAPIServerSpecFluent.ImageContentSourcePolicyObservedConfigNested<N>> implements OpenShiftAPIServerSpecFluent.ImageContentSourcePolicyObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ImageContentSourcePolicyBuilder builder;

        ImageContentSourcePolicyObservedConfigNestedImpl(ImageContentSourcePolicy item) {
            this.builder = new ImageContentSourcePolicyBuilder(this, item);
        }

        ImageContentSourcePolicyObservedConfigNestedImpl() {
            this.builder = new ImageContentSourcePolicyBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withObservedConfig(builder.build());
        }

        public N endImageContentSourcePolicyObservedConfig() {
             return and();
        }
    }


    public class ServiceCAObservedConfigNestedImpl<N> extends ServiceCAFluentImpl<OpenShiftAPIServerSpecFluent.ServiceCAObservedConfigNested<N>> implements OpenShiftAPIServerSpecFluent.ServiceCAObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServiceCABuilder builder;

        ServiceCAObservedConfigNestedImpl(ServiceCA item) {
            this.builder = new ServiceCABuilder(this, item);
        }

        ServiceCAObservedConfigNestedImpl() {
            this.builder = new ServiceCABuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withObservedConfig(builder.build());
        }

        public N endServiceCAObservedConfig() {
             return and();
        }
    }


    public class PersistentVolumeClaimObservedConfigNestedImpl<N> extends PersistentVolumeClaimFluentImpl<OpenShiftAPIServerSpecFluent.PersistentVolumeClaimObservedConfigNested<N>> implements OpenShiftAPIServerSpecFluent.PersistentVolumeClaimObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentVolumeClaimBuilder builder;

        PersistentVolumeClaimObservedConfigNestedImpl(PersistentVolumeClaim item) {
            this.builder = new PersistentVolumeClaimBuilder(this, item);
        }

        PersistentVolumeClaimObservedConfigNestedImpl() {
            this.builder = new PersistentVolumeClaimBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withObservedConfig(builder.build());
        }

        public N endPersistentVolumeClaimObservedConfig() {
             return and();
        }
    }


    public class KubeAPIServerObservedConfigNestedImpl<N> extends KubeAPIServerFluentImpl<OpenShiftAPIServerSpecFluent.KubeAPIServerObservedConfigNested<N>> implements OpenShiftAPIServerSpecFluent.KubeAPIServerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KubeAPIServerBuilder builder;

        KubeAPIServerObservedConfigNestedImpl(KubeAPIServer item) {
            this.builder = new KubeAPIServerBuilder(this, item);
        }

        KubeAPIServerObservedConfigNestedImpl() {
            this.builder = new KubeAPIServerBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withObservedConfig(builder.build());
        }

        public N endKubeAPIServerObservedConfig() {
             return and();
        }
    }


    public class IngressControllerObservedConfigNestedImpl<N> extends IngressControllerFluentImpl<OpenShiftAPIServerSpecFluent.IngressControllerObservedConfigNested<N>> implements OpenShiftAPIServerSpecFluent.IngressControllerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IngressControllerBuilder builder;

        IngressControllerObservedConfigNestedImpl(IngressController item) {
            this.builder = new IngressControllerBuilder(this, item);
        }

        IngressControllerObservedConfigNestedImpl() {
            this.builder = new IngressControllerBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withObservedConfig(builder.build());
        }

        public N endIngressControllerObservedConfig() {
             return and();
        }
    }


    public class KubeStorageVersionMigratorObservedConfigNestedImpl<N> extends KubeStorageVersionMigratorFluentImpl<OpenShiftAPIServerSpecFluent.KubeStorageVersionMigratorObservedConfigNested<N>> implements OpenShiftAPIServerSpecFluent.KubeStorageVersionMigratorObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KubeStorageVersionMigratorBuilder builder;

        KubeStorageVersionMigratorObservedConfigNestedImpl(KubeStorageVersionMigrator item) {
            this.builder = new KubeStorageVersionMigratorBuilder(this, item);
        }

        KubeStorageVersionMigratorObservedConfigNestedImpl() {
            this.builder = new KubeStorageVersionMigratorBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withObservedConfig(builder.build());
        }

        public N endKubeStorageVersionMigratorObservedConfig() {
             return and();
        }
    }


    public class ConsoleObservedConfigNestedImpl<N> extends ConsoleFluentImpl<OpenShiftAPIServerSpecFluent.ConsoleObservedConfigNested<N>> implements OpenShiftAPIServerSpecFluent.ConsoleObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConsoleBuilder builder;

        ConsoleObservedConfigNestedImpl(Console item) {
            this.builder = new ConsoleBuilder(this, item);
        }

        ConsoleObservedConfigNestedImpl() {
            this.builder = new ConsoleBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withObservedConfig(builder.build());
        }

        public N endConsoleObservedConfig() {
             return and();
        }
    }


    public class OpenShiftControllerManagerObservedConfigNestedImpl<N> extends OpenShiftControllerManagerFluentImpl<OpenShiftAPIServerSpecFluent.OpenShiftControllerManagerObservedConfigNested<N>> implements OpenShiftAPIServerSpecFluent.OpenShiftControllerManagerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OpenShiftControllerManagerBuilder builder;

        OpenShiftControllerManagerObservedConfigNestedImpl(OpenShiftControllerManager item) {
            this.builder = new OpenShiftControllerManagerBuilder(this, item);
        }

        OpenShiftControllerManagerObservedConfigNestedImpl() {
            this.builder = new OpenShiftControllerManagerBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withObservedConfig(builder.build());
        }

        public N endOpenShiftControllerManagerObservedConfig() {
             return and();
        }
    }


    public class EtcdObservedConfigNestedImpl<N> extends EtcdFluentImpl<OpenShiftAPIServerSpecFluent.EtcdObservedConfigNested<N>> implements OpenShiftAPIServerSpecFluent.EtcdObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EtcdBuilder builder;

        EtcdObservedConfigNestedImpl(Etcd item) {
            this.builder = new EtcdBuilder(this, item);
        }

        EtcdObservedConfigNestedImpl() {
            this.builder = new EtcdBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withObservedConfig(builder.build());
        }

        public N endEtcdObservedConfig() {
             return and();
        }
    }


    public class KubeSchedulerObservedConfigNestedImpl<N> extends KubeSchedulerFluentImpl<OpenShiftAPIServerSpecFluent.KubeSchedulerObservedConfigNested<N>> implements OpenShiftAPIServerSpecFluent.KubeSchedulerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KubeSchedulerBuilder builder;

        KubeSchedulerObservedConfigNestedImpl(KubeScheduler item) {
            this.builder = new KubeSchedulerBuilder(this, item);
        }

        KubeSchedulerObservedConfigNestedImpl() {
            this.builder = new KubeSchedulerBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withObservedConfig(builder.build());
        }

        public N endKubeSchedulerObservedConfig() {
             return and();
        }
    }


    public class NetworkObservedConfigNestedImpl<N> extends NetworkFluentImpl<OpenShiftAPIServerSpecFluent.NetworkObservedConfigNested<N>> implements OpenShiftAPIServerSpecFluent.NetworkObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NetworkBuilder builder;

        NetworkObservedConfigNestedImpl(Network item) {
            this.builder = new NetworkBuilder(this, item);
        }

        NetworkObservedConfigNestedImpl() {
            this.builder = new NetworkBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withObservedConfig(builder.build());
        }

        public N endNetworkObservedConfig() {
             return and();
        }
    }


    public class ServiceCatalogAPIServerObservedConfigNestedImpl<N> extends ServiceCatalogAPIServerFluentImpl<OpenShiftAPIServerSpecFluent.ServiceCatalogAPIServerObservedConfigNested<N>> implements OpenShiftAPIServerSpecFluent.ServiceCatalogAPIServerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServiceCatalogAPIServerBuilder builder;

        ServiceCatalogAPIServerObservedConfigNestedImpl(ServiceCatalogAPIServer item) {
            this.builder = new ServiceCatalogAPIServerBuilder(this, item);
        }

        ServiceCatalogAPIServerObservedConfigNestedImpl() {
            this.builder = new ServiceCatalogAPIServerBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withObservedConfig(builder.build());
        }

        public N endServiceCatalogAPIServerObservedConfig() {
             return and();
        }
    }


    public class CSISnapshotControllerObservedConfigNestedImpl<N> extends CSISnapshotControllerFluentImpl<OpenShiftAPIServerSpecFluent.CSISnapshotControllerObservedConfigNested<N>> implements OpenShiftAPIServerSpecFluent.CSISnapshotControllerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CSISnapshotControllerBuilder builder;

        CSISnapshotControllerObservedConfigNestedImpl(CSISnapshotController item) {
            this.builder = new CSISnapshotControllerBuilder(this, item);
        }

        CSISnapshotControllerObservedConfigNestedImpl() {
            this.builder = new CSISnapshotControllerBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withObservedConfig(builder.build());
        }

        public N endCSISnapshotControllerObservedConfig() {
             return and();
        }
    }


    public class ServiceCatalogControllerManagerObservedConfigNestedImpl<N> extends ServiceCatalogControllerManagerFluentImpl<OpenShiftAPIServerSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<N>> implements OpenShiftAPIServerSpecFluent.ServiceCatalogControllerManagerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServiceCatalogControllerManagerBuilder builder;

        ServiceCatalogControllerManagerObservedConfigNestedImpl(ServiceCatalogControllerManager item) {
            this.builder = new ServiceCatalogControllerManagerBuilder(this, item);
        }

        ServiceCatalogControllerManagerObservedConfigNestedImpl() {
            this.builder = new ServiceCatalogControllerManagerBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withObservedConfig(builder.build());
        }

        public N endServiceCatalogControllerManagerObservedConfig() {
             return and();
        }
    }


    public class DNSObservedConfigNestedImpl<N> extends DNSFluentImpl<OpenShiftAPIServerSpecFluent.DNSObservedConfigNested<N>> implements OpenShiftAPIServerSpecFluent.DNSObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DNSBuilder builder;

        DNSObservedConfigNestedImpl(DNS item) {
            this.builder = new DNSBuilder(this, item);
        }

        DNSObservedConfigNestedImpl() {
            this.builder = new DNSBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withObservedConfig(builder.build());
        }

        public N endDNSObservedConfig() {
             return and();
        }
    }


    public class DNSRecordObservedConfigNestedImpl<N> extends DNSRecordFluentImpl<OpenShiftAPIServerSpecFluent.DNSRecordObservedConfigNested<N>> implements OpenShiftAPIServerSpecFluent.DNSRecordObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DNSRecordBuilder builder;

        DNSRecordObservedConfigNestedImpl(DNSRecord item) {
            this.builder = new DNSRecordBuilder(this, item);
        }

        DNSRecordObservedConfigNestedImpl() {
            this.builder = new DNSRecordBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withObservedConfig(builder.build());
        }

        public N endDNSRecordObservedConfig() {
             return and();
        }
    }


    public class OpenShiftAPIServerObservedConfigNestedImpl<N> extends OpenShiftAPIServerFluentImpl<OpenShiftAPIServerSpecFluent.OpenShiftAPIServerObservedConfigNested<N>> implements OpenShiftAPIServerSpecFluent.OpenShiftAPIServerObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OpenShiftAPIServerBuilder builder;

        OpenShiftAPIServerObservedConfigNestedImpl(OpenShiftAPIServer item) {
            this.builder = new OpenShiftAPIServerBuilder(this, item);
        }

        OpenShiftAPIServerObservedConfigNestedImpl() {
            this.builder = new OpenShiftAPIServerBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withObservedConfig(builder.build());
        }

        public N endOpenShiftAPIServerObservedConfig() {
             return and();
        }
    }


    public class AuthenticationObservedConfigNestedImpl<N> extends AuthenticationFluentImpl<OpenShiftAPIServerSpecFluent.AuthenticationObservedConfigNested<N>> implements OpenShiftAPIServerSpecFluent.AuthenticationObservedConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AuthenticationBuilder builder;

        AuthenticationObservedConfigNestedImpl(Authentication item) {
            this.builder = new AuthenticationBuilder(this, item);
        }

        AuthenticationObservedConfigNestedImpl() {
            this.builder = new AuthenticationBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withObservedConfig(builder.build());
        }

        public N endAuthenticationObservedConfig() {
             return and();
        }
    }


    public class ImagePrunerUnsupportedConfigOverridesNestedImpl<N> extends ImagePrunerFluentImpl<OpenShiftAPIServerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<N>> implements OpenShiftAPIServerSpecFluent.ImagePrunerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ImagePrunerBuilder builder;

        ImagePrunerUnsupportedConfigOverridesNestedImpl(ImagePruner item) {
            this.builder = new ImagePrunerBuilder(this, item);
        }

        ImagePrunerUnsupportedConfigOverridesNestedImpl() {
            this.builder = new ImagePrunerBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
        }

        public N endImagePrunerUnsupportedConfigOverrides() {
             return and();
        }
    }


    public class KubeControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends KubeControllerManagerFluentImpl<OpenShiftAPIServerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<N>> implements OpenShiftAPIServerSpecFluent.KubeControllerManagerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KubeControllerManagerBuilder builder;

        KubeControllerManagerUnsupportedConfigOverridesNestedImpl(KubeControllerManager item) {
            this.builder = new KubeControllerManagerBuilder(this, item);
        }

        KubeControllerManagerUnsupportedConfigOverridesNestedImpl() {
            this.builder = new KubeControllerManagerBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
        }

        public N endKubeControllerManagerUnsupportedConfigOverrides() {
             return and();
        }
    }


    public class ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl<N> extends ImageContentSourcePolicyFluentImpl<OpenShiftAPIServerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>> implements OpenShiftAPIServerSpecFluent.ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ImageContentSourcePolicyBuilder builder;

        ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl(ImageContentSourcePolicy item) {
            this.builder = new ImageContentSourcePolicyBuilder(this, item);
        }

        ImageContentSourcePolicyUnsupportedConfigOverridesNestedImpl() {
            this.builder = new ImageContentSourcePolicyBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
        }

        public N endImageContentSourcePolicyUnsupportedConfigOverrides() {
             return and();
        }
    }


    public class ServiceCAUnsupportedConfigOverridesNestedImpl<N> extends ServiceCAFluentImpl<OpenShiftAPIServerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<N>> implements OpenShiftAPIServerSpecFluent.ServiceCAUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServiceCABuilder builder;

        ServiceCAUnsupportedConfigOverridesNestedImpl(ServiceCA item) {
            this.builder = new ServiceCABuilder(this, item);
        }

        ServiceCAUnsupportedConfigOverridesNestedImpl() {
            this.builder = new ServiceCABuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
        }

        public N endServiceCAUnsupportedConfigOverrides() {
             return and();
        }
    }


    public class PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl<N> extends PersistentVolumeClaimFluentImpl<OpenShiftAPIServerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<N>> implements OpenShiftAPIServerSpecFluent.PersistentVolumeClaimUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PersistentVolumeClaimBuilder builder;

        PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl(PersistentVolumeClaim item) {
            this.builder = new PersistentVolumeClaimBuilder(this, item);
        }

        PersistentVolumeClaimUnsupportedConfigOverridesNestedImpl() {
            this.builder = new PersistentVolumeClaimBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
        }

        public N endPersistentVolumeClaimUnsupportedConfigOverrides() {
             return and();
        }
    }


    public class KubeAPIServerUnsupportedConfigOverridesNestedImpl<N> extends KubeAPIServerFluentImpl<OpenShiftAPIServerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<N>> implements OpenShiftAPIServerSpecFluent.KubeAPIServerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KubeAPIServerBuilder builder;

        KubeAPIServerUnsupportedConfigOverridesNestedImpl(KubeAPIServer item) {
            this.builder = new KubeAPIServerBuilder(this, item);
        }

        KubeAPIServerUnsupportedConfigOverridesNestedImpl() {
            this.builder = new KubeAPIServerBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
        }

        public N endKubeAPIServerUnsupportedConfigOverrides() {
             return and();
        }
    }


    public class IngressControllerUnsupportedConfigOverridesNestedImpl<N> extends IngressControllerFluentImpl<OpenShiftAPIServerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<N>> implements OpenShiftAPIServerSpecFluent.IngressControllerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IngressControllerBuilder builder;

        IngressControllerUnsupportedConfigOverridesNestedImpl(IngressController item) {
            this.builder = new IngressControllerBuilder(this, item);
        }

        IngressControllerUnsupportedConfigOverridesNestedImpl() {
            this.builder = new IngressControllerBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
        }

        public N endIngressControllerUnsupportedConfigOverrides() {
             return and();
        }
    }


    public class KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl<N> extends KubeStorageVersionMigratorFluentImpl<OpenShiftAPIServerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>> implements OpenShiftAPIServerSpecFluent.KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KubeStorageVersionMigratorBuilder builder;

        KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl(KubeStorageVersionMigrator item) {
            this.builder = new KubeStorageVersionMigratorBuilder(this, item);
        }

        KubeStorageVersionMigratorUnsupportedConfigOverridesNestedImpl() {
            this.builder = new KubeStorageVersionMigratorBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
        }

        public N endKubeStorageVersionMigratorUnsupportedConfigOverrides() {
             return and();
        }
    }


    public class ConsoleUnsupportedConfigOverridesNestedImpl<N> extends ConsoleFluentImpl<OpenShiftAPIServerSpecFluent.ConsoleUnsupportedConfigOverridesNested<N>> implements OpenShiftAPIServerSpecFluent.ConsoleUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ConsoleBuilder builder;

        ConsoleUnsupportedConfigOverridesNestedImpl(Console item) {
            this.builder = new ConsoleBuilder(this, item);
        }

        ConsoleUnsupportedConfigOverridesNestedImpl() {
            this.builder = new ConsoleBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
        }

        public N endConsoleUnsupportedConfigOverrides() {
             return and();
        }
    }


    public class OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftControllerManagerFluentImpl<OpenShiftAPIServerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>> implements OpenShiftAPIServerSpecFluent.OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OpenShiftControllerManagerBuilder builder;

        OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl(OpenShiftControllerManager item) {
            this.builder = new OpenShiftControllerManagerBuilder(this, item);
        }

        OpenShiftControllerManagerUnsupportedConfigOverridesNestedImpl() {
            this.builder = new OpenShiftControllerManagerBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
        }

        public N endOpenShiftControllerManagerUnsupportedConfigOverrides() {
             return and();
        }
    }


    public class EtcdUnsupportedConfigOverridesNestedImpl<N> extends EtcdFluentImpl<OpenShiftAPIServerSpecFluent.EtcdUnsupportedConfigOverridesNested<N>> implements OpenShiftAPIServerSpecFluent.EtcdUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EtcdBuilder builder;

        EtcdUnsupportedConfigOverridesNestedImpl(Etcd item) {
            this.builder = new EtcdBuilder(this, item);
        }

        EtcdUnsupportedConfigOverridesNestedImpl() {
            this.builder = new EtcdBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
        }

        public N endEtcdUnsupportedConfigOverrides() {
             return and();
        }
    }


    public class KubeSchedulerUnsupportedConfigOverridesNestedImpl<N> extends KubeSchedulerFluentImpl<OpenShiftAPIServerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<N>> implements OpenShiftAPIServerSpecFluent.KubeSchedulerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KubeSchedulerBuilder builder;

        KubeSchedulerUnsupportedConfigOverridesNestedImpl(KubeScheduler item) {
            this.builder = new KubeSchedulerBuilder(this, item);
        }

        KubeSchedulerUnsupportedConfigOverridesNestedImpl() {
            this.builder = new KubeSchedulerBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
        }

        public N endKubeSchedulerUnsupportedConfigOverrides() {
             return and();
        }
    }


    public class NetworkUnsupportedConfigOverridesNestedImpl<N> extends NetworkFluentImpl<OpenShiftAPIServerSpecFluent.NetworkUnsupportedConfigOverridesNested<N>> implements OpenShiftAPIServerSpecFluent.NetworkUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NetworkBuilder builder;

        NetworkUnsupportedConfigOverridesNestedImpl(Network item) {
            this.builder = new NetworkBuilder(this, item);
        }

        NetworkUnsupportedConfigOverridesNestedImpl() {
            this.builder = new NetworkBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
        }

        public N endNetworkUnsupportedConfigOverrides() {
             return and();
        }
    }


    public class ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogAPIServerFluentImpl<OpenShiftAPIServerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>> implements OpenShiftAPIServerSpecFluent.ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServiceCatalogAPIServerBuilder builder;

        ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl(ServiceCatalogAPIServer item) {
            this.builder = new ServiceCatalogAPIServerBuilder(this, item);
        }

        ServiceCatalogAPIServerUnsupportedConfigOverridesNestedImpl() {
            this.builder = new ServiceCatalogAPIServerBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
        }

        public N endServiceCatalogAPIServerUnsupportedConfigOverrides() {
             return and();
        }
    }


    public class CSISnapshotControllerUnsupportedConfigOverridesNestedImpl<N> extends CSISnapshotControllerFluentImpl<OpenShiftAPIServerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<N>> implements OpenShiftAPIServerSpecFluent.CSISnapshotControllerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CSISnapshotControllerBuilder builder;

        CSISnapshotControllerUnsupportedConfigOverridesNestedImpl(CSISnapshotController item) {
            this.builder = new CSISnapshotControllerBuilder(this, item);
        }

        CSISnapshotControllerUnsupportedConfigOverridesNestedImpl() {
            this.builder = new CSISnapshotControllerBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
        }

        public N endCSISnapshotControllerUnsupportedConfigOverrides() {
             return and();
        }
    }


    public class ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl<N> extends ServiceCatalogControllerManagerFluentImpl<OpenShiftAPIServerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>> implements OpenShiftAPIServerSpecFluent.ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServiceCatalogControllerManagerBuilder builder;

        ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl(ServiceCatalogControllerManager item) {
            this.builder = new ServiceCatalogControllerManagerBuilder(this, item);
        }

        ServiceCatalogControllerManagerUnsupportedConfigOverridesNestedImpl() {
            this.builder = new ServiceCatalogControllerManagerBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
        }

        public N endServiceCatalogControllerManagerUnsupportedConfigOverrides() {
             return and();
        }
    }


    public class DNSUnsupportedConfigOverridesNestedImpl<N> extends DNSFluentImpl<OpenShiftAPIServerSpecFluent.DNSUnsupportedConfigOverridesNested<N>> implements OpenShiftAPIServerSpecFluent.DNSUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DNSBuilder builder;

        DNSUnsupportedConfigOverridesNestedImpl(DNS item) {
            this.builder = new DNSBuilder(this, item);
        }

        DNSUnsupportedConfigOverridesNestedImpl() {
            this.builder = new DNSBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
        }

        public N endDNSUnsupportedConfigOverrides() {
             return and();
        }
    }


    public class DNSRecordUnsupportedConfigOverridesNestedImpl<N> extends DNSRecordFluentImpl<OpenShiftAPIServerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<N>> implements OpenShiftAPIServerSpecFluent.DNSRecordUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final DNSRecordBuilder builder;

        DNSRecordUnsupportedConfigOverridesNestedImpl(DNSRecord item) {
            this.builder = new DNSRecordBuilder(this, item);
        }

        DNSRecordUnsupportedConfigOverridesNestedImpl() {
            this.builder = new DNSRecordBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
        }

        public N endDNSRecordUnsupportedConfigOverrides() {
             return and();
        }
    }


    public class OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl<N> extends OpenShiftAPIServerFluentImpl<OpenShiftAPIServerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<N>> implements OpenShiftAPIServerSpecFluent.OpenShiftAPIServerUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OpenShiftAPIServerBuilder builder;

        OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl(OpenShiftAPIServer item) {
            this.builder = new OpenShiftAPIServerBuilder(this, item);
        }

        OpenShiftAPIServerUnsupportedConfigOverridesNestedImpl() {
            this.builder = new OpenShiftAPIServerBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
        }

        public N endOpenShiftAPIServerUnsupportedConfigOverrides() {
             return and();
        }
    }


    public class AuthenticationUnsupportedConfigOverridesNestedImpl<N> extends AuthenticationFluentImpl<OpenShiftAPIServerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<N>> implements OpenShiftAPIServerSpecFluent.AuthenticationUnsupportedConfigOverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AuthenticationBuilder builder;

        AuthenticationUnsupportedConfigOverridesNestedImpl(Authentication item) {
            this.builder = new AuthenticationBuilder(this, item);
        }

        AuthenticationUnsupportedConfigOverridesNestedImpl() {
            this.builder = new AuthenticationBuilder(this);
        }

        public N and() {
             return (N) OpenShiftAPIServerSpecFluentImpl.this.withUnsupportedConfigOverrides(builder.build());
        }

        public N endAuthenticationUnsupportedConfigOverrides() {
             return and();
        }
    }


}
