package io.fabric8.openshift.api.model.operator.v1;

import java.lang.Integer;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class KuryrConfigFluentImpl<A extends KuryrConfigFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KuryrConfigFluent<A> {

    private Integer controllerProbesPort;
    private Integer daemonProbesPort;
    private Boolean enablePortPoolsPrepopulation;
    private String openStackServiceNetwork;
    private Integer poolBatchPorts;
    private Integer poolMaxPorts;
    private Integer poolMinPorts;

    public KuryrConfigFluentImpl() { 
    }


    public KuryrConfigFluentImpl(KuryrConfig instance) { 
        this.withControllerProbesPort(instance.getControllerProbesPort()); 
        this.withDaemonProbesPort(instance.getDaemonProbesPort()); 
        this.withEnablePortPoolsPrepopulation(instance.getEnablePortPoolsPrepopulation()); 
        this.withOpenStackServiceNetwork(instance.getOpenStackServiceNetwork()); 
        this.withPoolBatchPorts(instance.getPoolBatchPorts()); 
        this.withPoolMaxPorts(instance.getPoolMaxPorts()); 
        this.withPoolMinPorts(instance.getPoolMinPorts()); 
    }


    public Integer getControllerProbesPort() {
        return this.controllerProbesPort;
    }

    public A withControllerProbesPort(Integer controllerProbesPort) {
        this.controllerProbesPort=controllerProbesPort; return (A) this;
    }

    public Boolean hasControllerProbesPort() {
        return this.controllerProbesPort != null;
    }

    public Integer getDaemonProbesPort() {
        return this.daemonProbesPort;
    }

    public A withDaemonProbesPort(Integer daemonProbesPort) {
        this.daemonProbesPort=daemonProbesPort; return (A) this;
    }

    public Boolean hasDaemonProbesPort() {
        return this.daemonProbesPort != null;
    }

    public Boolean isEnablePortPoolsPrepopulation() {
        return this.enablePortPoolsPrepopulation;
    }

    public A withEnablePortPoolsPrepopulation(Boolean enablePortPoolsPrepopulation) {
        this.enablePortPoolsPrepopulation=enablePortPoolsPrepopulation; return (A) this;
    }

    public Boolean hasEnablePortPoolsPrepopulation() {
        return this.enablePortPoolsPrepopulation != null;
    }

    public A withNewEnablePortPoolsPrepopulation(String arg1) {
        return (A)withEnablePortPoolsPrepopulation(new Boolean(arg1));
    }

    public A withNewEnablePortPoolsPrepopulation(boolean arg1) {
        return (A)withEnablePortPoolsPrepopulation(new Boolean(arg1));
    }

    public String getOpenStackServiceNetwork() {
        return this.openStackServiceNetwork;
    }

    public A withOpenStackServiceNetwork(String openStackServiceNetwork) {
        this.openStackServiceNetwork=openStackServiceNetwork; return (A) this;
    }

    public Boolean hasOpenStackServiceNetwork() {
        return this.openStackServiceNetwork != null;
    }

    public A withNewOpenStackServiceNetwork(String arg1) {
        return (A)withOpenStackServiceNetwork(new String(arg1));
    }

    public A withNewOpenStackServiceNetwork(StringBuilder arg1) {
        return (A)withOpenStackServiceNetwork(new String(arg1));
    }

    public A withNewOpenStackServiceNetwork(StringBuffer arg1) {
        return (A)withOpenStackServiceNetwork(new String(arg1));
    }

    public Integer getPoolBatchPorts() {
        return this.poolBatchPorts;
    }

    public A withPoolBatchPorts(Integer poolBatchPorts) {
        this.poolBatchPorts=poolBatchPorts; return (A) this;
    }

    public Boolean hasPoolBatchPorts() {
        return this.poolBatchPorts != null;
    }

    public Integer getPoolMaxPorts() {
        return this.poolMaxPorts;
    }

    public A withPoolMaxPorts(Integer poolMaxPorts) {
        this.poolMaxPorts=poolMaxPorts; return (A) this;
    }

    public Boolean hasPoolMaxPorts() {
        return this.poolMaxPorts != null;
    }

    public Integer getPoolMinPorts() {
        return this.poolMinPorts;
    }

    public A withPoolMinPorts(Integer poolMinPorts) {
        this.poolMinPorts=poolMinPorts; return (A) this;
    }

    public Boolean hasPoolMinPorts() {
        return this.poolMinPorts != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KuryrConfigFluentImpl that = (KuryrConfigFluentImpl) o;
        if (controllerProbesPort != null ? !controllerProbesPort.equals(that.controllerProbesPort) :that.controllerProbesPort != null) return false;
        if (daemonProbesPort != null ? !daemonProbesPort.equals(that.daemonProbesPort) :that.daemonProbesPort != null) return false;
        if (enablePortPoolsPrepopulation != null ? !enablePortPoolsPrepopulation.equals(that.enablePortPoolsPrepopulation) :that.enablePortPoolsPrepopulation != null) return false;
        if (openStackServiceNetwork != null ? !openStackServiceNetwork.equals(that.openStackServiceNetwork) :that.openStackServiceNetwork != null) return false;
        if (poolBatchPorts != null ? !poolBatchPorts.equals(that.poolBatchPorts) :that.poolBatchPorts != null) return false;
        if (poolMaxPorts != null ? !poolMaxPorts.equals(that.poolMaxPorts) :that.poolMaxPorts != null) return false;
        if (poolMinPorts != null ? !poolMinPorts.equals(that.poolMinPorts) :that.poolMinPorts != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(controllerProbesPort,  daemonProbesPort,  enablePortPoolsPrepopulation,  openStackServiceNetwork,  poolBatchPorts,  poolMaxPorts,  poolMinPorts,  super.hashCode());
    }

}
