package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface KubeControllerManagerStatusFluent<A extends KubeControllerManagerStatusFluent<A>> extends Fluent<A> {


    public A addToConditions(int index,OperatorCondition item);
    public A setToConditions(int index,OperatorCondition item);
    public A addToConditions(OperatorCondition... items);
    public A addAllToConditions(Collection<OperatorCondition> items);
    public A removeFromConditions(OperatorCondition... items);
    public A removeAllFromConditions(Collection<OperatorCondition> items);
    public A removeMatchingFromConditions(io.fabric8.kubernetes.api.builder.Predicate<OperatorConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<OperatorCondition> getConditions();
    public List<OperatorCondition> buildConditions();
    public OperatorCondition buildCondition(int index);
    public OperatorCondition buildFirstCondition();
    public OperatorCondition buildLastCondition();
    public OperatorCondition buildMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<OperatorConditionBuilder> predicate);
    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<OperatorConditionBuilder> predicate);
    public A withConditions(List<OperatorCondition> conditions);
    public A withConditions(OperatorCondition... conditions);
    public Boolean hasConditions();
    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type);
    public KubeControllerManagerStatusFluent.ConditionsNested<A> addNewCondition();
    public KubeControllerManagerStatusFluent.ConditionsNested<A> addNewConditionLike(OperatorCondition item);
    public KubeControllerManagerStatusFluent.ConditionsNested<A> setNewConditionLike(int index,OperatorCondition item);
    public KubeControllerManagerStatusFluent.ConditionsNested<A> editCondition(int index);
    public KubeControllerManagerStatusFluent.ConditionsNested<A> editFirstCondition();
    public KubeControllerManagerStatusFluent.ConditionsNested<A> editLastCondition();
    public KubeControllerManagerStatusFluent.ConditionsNested<A> editMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<OperatorConditionBuilder> predicate);
    public A addToGenerations(int index,GenerationStatus item);
    public A setToGenerations(int index,GenerationStatus item);
    public A addToGenerations(GenerationStatus... items);
    public A addAllToGenerations(Collection<GenerationStatus> items);
    public A removeFromGenerations(GenerationStatus... items);
    public A removeAllFromGenerations(Collection<GenerationStatus> items);
    public A removeMatchingFromGenerations(io.fabric8.kubernetes.api.builder.Predicate<GenerationStatusBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildGenerations instead.
 * @return The buildable object.
 */
@Deprecated public List<GenerationStatus> getGenerations();
    public List<GenerationStatus> buildGenerations();
    public GenerationStatus buildGeneration(int index);
    public GenerationStatus buildFirstGeneration();
    public GenerationStatus buildLastGeneration();
    public GenerationStatus buildMatchingGeneration(io.fabric8.kubernetes.api.builder.Predicate<GenerationStatusBuilder> predicate);
    public Boolean hasMatchingGeneration(io.fabric8.kubernetes.api.builder.Predicate<GenerationStatusBuilder> predicate);
    public A withGenerations(List<GenerationStatus> generations);
    public A withGenerations(GenerationStatus... generations);
    public Boolean hasGenerations();
    public KubeControllerManagerStatusFluent.GenerationsNested<A> addNewGeneration();
    public KubeControllerManagerStatusFluent.GenerationsNested<A> addNewGenerationLike(GenerationStatus item);
    public KubeControllerManagerStatusFluent.GenerationsNested<A> setNewGenerationLike(int index,GenerationStatus item);
    public KubeControllerManagerStatusFluent.GenerationsNested<A> editGeneration(int index);
    public KubeControllerManagerStatusFluent.GenerationsNested<A> editFirstGeneration();
    public KubeControllerManagerStatusFluent.GenerationsNested<A> editLastGeneration();
    public KubeControllerManagerStatusFluent.GenerationsNested<A> editMatchingGeneration(io.fabric8.kubernetes.api.builder.Predicate<GenerationStatusBuilder> predicate);
    public Integer getLatestAvailableRevision();
    public A withLatestAvailableRevision(Integer latestAvailableRevision);
    public Boolean hasLatestAvailableRevision();
    public String getLatestAvailableRevisionReason();
    public A withLatestAvailableRevisionReason(String latestAvailableRevisionReason);
    public Boolean hasLatestAvailableRevisionReason();
    public A withNewLatestAvailableRevisionReason(String arg1);
    public A withNewLatestAvailableRevisionReason(StringBuilder arg1);
    public A withNewLatestAvailableRevisionReason(StringBuffer arg1);
    public A addToNodeStatuses(int index,NodeStatus item);
    public A setToNodeStatuses(int index,NodeStatus item);
    public A addToNodeStatuses(NodeStatus... items);
    public A addAllToNodeStatuses(Collection<NodeStatus> items);
    public A removeFromNodeStatuses(NodeStatus... items);
    public A removeAllFromNodeStatuses(Collection<NodeStatus> items);
    public A removeMatchingFromNodeStatuses(io.fabric8.kubernetes.api.builder.Predicate<NodeStatusBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildNodeStatuses instead.
 * @return The buildable object.
 */
@Deprecated public List<NodeStatus> getNodeStatuses();
    public List<NodeStatus> buildNodeStatuses();
    public NodeStatus buildNodeStatus(int index);
    public NodeStatus buildFirstNodeStatus();
    public NodeStatus buildLastNodeStatus();
    public NodeStatus buildMatchingNodeStatus(io.fabric8.kubernetes.api.builder.Predicate<NodeStatusBuilder> predicate);
    public Boolean hasMatchingNodeStatus(io.fabric8.kubernetes.api.builder.Predicate<NodeStatusBuilder> predicate);
    public A withNodeStatuses(List<NodeStatus> nodeStatuses);
    public A withNodeStatuses(NodeStatus... nodeStatuses);
    public Boolean hasNodeStatuses();
    public KubeControllerManagerStatusFluent.NodeStatusesNested<A> addNewNodeStatus();
    public KubeControllerManagerStatusFluent.NodeStatusesNested<A> addNewNodeStatusLike(NodeStatus item);
    public KubeControllerManagerStatusFluent.NodeStatusesNested<A> setNewNodeStatusLike(int index,NodeStatus item);
    public KubeControllerManagerStatusFluent.NodeStatusesNested<A> editNodeStatus(int index);
    public KubeControllerManagerStatusFluent.NodeStatusesNested<A> editFirstNodeStatus();
    public KubeControllerManagerStatusFluent.NodeStatusesNested<A> editLastNodeStatus();
    public KubeControllerManagerStatusFluent.NodeStatusesNested<A> editMatchingNodeStatus(io.fabric8.kubernetes.api.builder.Predicate<NodeStatusBuilder> predicate);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public Integer getReadyReplicas();
    public A withReadyReplicas(Integer readyReplicas);
    public Boolean hasReadyReplicas();
    public String getVersion();
    public A withVersion(String version);
    public Boolean hasVersion();
    public A withNewVersion(String arg1);
    public A withNewVersion(StringBuilder arg1);
    public A withNewVersion(StringBuffer arg1);
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OperatorConditionFluent<KubeControllerManagerStatusFluent.ConditionsNested<N>> {

        public N and();
        public N endCondition();    }


    public interface GenerationsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GenerationStatusFluent<KubeControllerManagerStatusFluent.GenerationsNested<N>> {

        public N and();
        public N endGeneration();    }


    public interface NodeStatusesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NodeStatusFluent<KubeControllerManagerStatusFluent.NodeStatusesNested<N>> {

        public N and();
        public N endNodeStatus();    }


}
