package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CSISnapshotControllerSpecBuilder extends CSISnapshotControllerSpecFluentImpl<CSISnapshotControllerSpecBuilder> implements VisitableBuilder<CSISnapshotControllerSpec,CSISnapshotControllerSpecBuilder> {

    CSISnapshotControllerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public CSISnapshotControllerSpecBuilder() { 
        this(true);
    }


    public CSISnapshotControllerSpecBuilder(Boolean validationEnabled) { 
        this(new CSISnapshotControllerSpec(), validationEnabled);
    }


    public CSISnapshotControllerSpecBuilder(CSISnapshotControllerSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public CSISnapshotControllerSpecBuilder(CSISnapshotControllerSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new CSISnapshotControllerSpec(), validationEnabled);
    }


    public CSISnapshotControllerSpecBuilder(CSISnapshotControllerSpecFluent<?> fluent,CSISnapshotControllerSpec instance) { 
        this(fluent, instance, true);
    }


    public CSISnapshotControllerSpecBuilder(CSISnapshotControllerSpecFluent<?> fluent,CSISnapshotControllerSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withLogLevel(instance.getLogLevel()); 
        fluent.withManagementState(instance.getManagementState()); 
        fluent.withObservedConfig(instance.getObservedConfig()); 
        fluent.withOperatorLogLevel(instance.getOperatorLogLevel()); 
        fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
        this.validationEnabled = validationEnabled; 
    }


    public CSISnapshotControllerSpecBuilder(CSISnapshotControllerSpec instance) { 
        this(instance,true);
    }


    public CSISnapshotControllerSpecBuilder(CSISnapshotControllerSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withLogLevel(instance.getLogLevel()); 
        this.withManagementState(instance.getManagementState()); 
        this.withObservedConfig(instance.getObservedConfig()); 
        this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
        this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
        this.validationEnabled = validationEnabled; 
    }


    public CSISnapshotControllerSpec build() {
        CSISnapshotControllerSpec buildable = new CSISnapshotControllerSpec(fluent.getLogLevel(),fluent.getManagementState(),fluent.getObservedConfig(),fluent.getOperatorLogLevel(),fluent.getUnsupportedConfigOverrides());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CSISnapshotControllerSpecBuilder that = (CSISnapshotControllerSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
