package io.fabric8.openshift.api.model.operator.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class RepositoryDigestMirrorsFluentImpl<A extends RepositoryDigestMirrorsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RepositoryDigestMirrorsFluent<A> {

    private List<String> mirrors = new ArrayList<String>();
    private String source;

    public RepositoryDigestMirrorsFluentImpl() { 
    }


    public RepositoryDigestMirrorsFluentImpl(RepositoryDigestMirrors instance) { 
        this.withMirrors(instance.getMirrors()); 
        this.withSource(instance.getSource()); 
    }


    public A addToMirrors(int index,String item) {
        if (this.mirrors == null) {this.mirrors = new ArrayList<String>();}
        this.mirrors.add(index, item);
        return (A)this;
    }

    public A setToMirrors(int index,String item) {
        if (this.mirrors == null) {this.mirrors = new ArrayList<String>();}
        this.mirrors.set(index, item); return (A)this;
    }

    public A addToMirrors(String... items) {
        if (this.mirrors == null) {this.mirrors = new ArrayList<String>();}
        for (String item : items) {this.mirrors.add(item);} return (A)this;
    }

    public A addAllToMirrors(Collection<String> items) {
        if (this.mirrors == null) {this.mirrors = new ArrayList<String>();}
        for (String item : items) {this.mirrors.add(item);} return (A)this;
    }

    public A removeFromMirrors(String... items) {
        for (String item : items) {if (this.mirrors!= null){ this.mirrors.remove(item);}} return (A)this;
    }

    public A removeAllFromMirrors(Collection<String> items) {
        for (String item : items) {if (this.mirrors!= null){ this.mirrors.remove(item);}} return (A)this;
    }

    public List<String> getMirrors() {
        return this.mirrors;
    }

    public String getMirror(int index) {
        return this.mirrors.get(index);
    }

    public String getFirstMirror() {
        return this.mirrors.get(0);
    }

    public String getLastMirror() {
        return this.mirrors.get(mirrors.size() - 1);
    }

    public String getMatchingMirror(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: mirrors) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingMirror(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: mirrors) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withMirrors(List<String> mirrors) {
        if (this.mirrors != null) { _visitables.get("mirrors").removeAll(this.mirrors);}
        if (mirrors != null) {this.mirrors = new ArrayList<String>(); for (String item : mirrors){this.addToMirrors(item);}} else { this.mirrors = null;} return (A) this;
    }

    public A withMirrors(String... mirrors) {
        if (this.mirrors != null) {this.mirrors.clear();}
        if (mirrors != null) {for (String item :mirrors){ this.addToMirrors(item);}} return (A) this;
    }

    public Boolean hasMirrors() {
        return mirrors != null && !mirrors.isEmpty();
    }

    public A addNewMirror(String arg1) {
        return (A)addToMirrors(new String(arg1));
    }

    public A addNewMirror(StringBuilder arg1) {
        return (A)addToMirrors(new String(arg1));
    }

    public A addNewMirror(StringBuffer arg1) {
        return (A)addToMirrors(new String(arg1));
    }

    public String getSource() {
        return this.source;
    }

    public A withSource(String source) {
        this.source=source; return (A) this;
    }

    public Boolean hasSource() {
        return this.source != null;
    }

    public A withNewSource(String arg1) {
        return (A)withSource(new String(arg1));
    }

    public A withNewSource(StringBuilder arg1) {
        return (A)withSource(new String(arg1));
    }

    public A withNewSource(StringBuffer arg1) {
        return (A)withSource(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RepositoryDigestMirrorsFluentImpl that = (RepositoryDigestMirrorsFluentImpl) o;
        if (mirrors != null ? !mirrors.equals(that.mirrors) :that.mirrors != null) return false;
        if (source != null ? !source.equals(that.source) :that.source != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(mirrors,  source,  super.hashCode());
    }

}
