package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceCatalogControllerManagerBuilder extends ServiceCatalogControllerManagerFluentImpl<ServiceCatalogControllerManagerBuilder> implements VisitableBuilder<ServiceCatalogControllerManager,ServiceCatalogControllerManagerBuilder> {

    ServiceCatalogControllerManagerFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceCatalogControllerManagerBuilder() { 
        this(true);
    }


    public ServiceCatalogControllerManagerBuilder(Boolean validationEnabled) { 
        this(new ServiceCatalogControllerManager(), validationEnabled);
    }


    public ServiceCatalogControllerManagerBuilder(ServiceCatalogControllerManagerFluent<?> fluent) { 
        this(fluent, true);
    }


    public ServiceCatalogControllerManagerBuilder(ServiceCatalogControllerManagerFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ServiceCatalogControllerManager(), validationEnabled);
    }


    public ServiceCatalogControllerManagerBuilder(ServiceCatalogControllerManagerFluent<?> fluent,ServiceCatalogControllerManager instance) { 
        this(fluent, instance, true);
    }


    public ServiceCatalogControllerManagerBuilder(ServiceCatalogControllerManagerFluent<?> fluent,ServiceCatalogControllerManager instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public ServiceCatalogControllerManagerBuilder(ServiceCatalogControllerManager instance) { 
        this(instance,true);
    }


    public ServiceCatalogControllerManagerBuilder(ServiceCatalogControllerManager instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public ServiceCatalogControllerManager build() {
        ServiceCatalogControllerManager buildable = new ServiceCatalogControllerManager(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ServiceCatalogControllerManagerBuilder that = (ServiceCatalogControllerManagerBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
