package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ProviderLoadBalancerParametersFluentImpl<A extends ProviderLoadBalancerParametersFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ProviderLoadBalancerParametersFluent<A> {

    private AWSLoadBalancerParametersBuilder aws;
    private String type;

    public ProviderLoadBalancerParametersFluentImpl() { 
    }


    public ProviderLoadBalancerParametersFluentImpl(ProviderLoadBalancerParameters instance) { 
        this.withAws(instance.getAws()); 
        this.withType(instance.getType()); 
    }


    
/**
 * This method has been deprecated, please use method buildAws instead.
 * @return The buildable object.
 */
@Deprecated public AWSLoadBalancerParameters getAws() {
        return this.aws!=null?this.aws.build():null;
    }

    public AWSLoadBalancerParameters buildAws() {
        return this.aws!=null?this.aws.build():null;
    }

    public A withAws(AWSLoadBalancerParameters aws) {
        _visitables.get("aws").remove(this.aws);
        if (aws!=null){ this.aws= new AWSLoadBalancerParametersBuilder(aws); _visitables.get("aws").add(this.aws);} return (A) this;
    }

    public Boolean hasAws() {
        return this.aws != null;
    }

    public ProviderLoadBalancerParametersFluent.AwsNested<A> withNewAws() {
        return new AwsNestedImpl();
    }

    public ProviderLoadBalancerParametersFluent.AwsNested<A> withNewAwsLike(AWSLoadBalancerParameters item) {
        return new AwsNestedImpl(item);
    }

    public ProviderLoadBalancerParametersFluent.AwsNested<A> editAws() {
        return withNewAwsLike(getAws());
    }

    public ProviderLoadBalancerParametersFluent.AwsNested<A> editOrNewAws() {
        return withNewAwsLike(getAws() != null ? getAws(): new AWSLoadBalancerParametersBuilder().build());
    }

    public ProviderLoadBalancerParametersFluent.AwsNested<A> editOrNewAwsLike(AWSLoadBalancerParameters item) {
        return withNewAwsLike(getAws() != null ? getAws(): item);
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ProviderLoadBalancerParametersFluentImpl that = (ProviderLoadBalancerParametersFluentImpl) o;
        if (aws != null ? !aws.equals(that.aws) :that.aws != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(aws,  type,  super.hashCode());
    }

    public class AwsNestedImpl<N> extends AWSLoadBalancerParametersFluentImpl<ProviderLoadBalancerParametersFluent.AwsNested<N>> implements ProviderLoadBalancerParametersFluent.AwsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AWSLoadBalancerParametersBuilder builder;

        AwsNestedImpl(AWSLoadBalancerParameters item) {
            this.builder = new AWSLoadBalancerParametersBuilder(this, item);
        }

        AwsNestedImpl() {
            this.builder = new AWSLoadBalancerParametersBuilder(this);
        }

        public N and() {
             return (N) ProviderLoadBalancerParametersFluentImpl.this.withAws(builder.build());
        }

        public N endAws() {
             return and();
        }
    }


}
