package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class NodeStatusFluentImpl<A extends NodeStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements NodeStatusFluent<A> {

    private Integer currentRevision;
    private Integer lastFailedRevision;
    private List<String> lastFailedRevisionErrors = new ArrayList<String>();
    private String nodeName;
    private Integer targetRevision;

    public NodeStatusFluentImpl() { 
    }


    public NodeStatusFluentImpl(NodeStatus instance) { 
        this.withCurrentRevision(instance.getCurrentRevision()); 
        this.withLastFailedRevision(instance.getLastFailedRevision()); 
        this.withLastFailedRevisionErrors(instance.getLastFailedRevisionErrors()); 
        this.withNodeName(instance.getNodeName()); 
        this.withTargetRevision(instance.getTargetRevision()); 
    }


    public Integer getCurrentRevision() {
        return this.currentRevision;
    }

    public A withCurrentRevision(Integer currentRevision) {
        this.currentRevision=currentRevision; return (A) this;
    }

    public Boolean hasCurrentRevision() {
        return this.currentRevision != null;
    }

    public Integer getLastFailedRevision() {
        return this.lastFailedRevision;
    }

    public A withLastFailedRevision(Integer lastFailedRevision) {
        this.lastFailedRevision=lastFailedRevision; return (A) this;
    }

    public Boolean hasLastFailedRevision() {
        return this.lastFailedRevision != null;
    }

    public A addToLastFailedRevisionErrors(int index,String item) {
        if (this.lastFailedRevisionErrors == null) {this.lastFailedRevisionErrors = new ArrayList<String>();}
        this.lastFailedRevisionErrors.add(index, item);
        return (A)this;
    }

    public A setToLastFailedRevisionErrors(int index,String item) {
        if (this.lastFailedRevisionErrors == null) {this.lastFailedRevisionErrors = new ArrayList<String>();}
        this.lastFailedRevisionErrors.set(index, item); return (A)this;
    }

    public A addToLastFailedRevisionErrors(String... items) {
        if (this.lastFailedRevisionErrors == null) {this.lastFailedRevisionErrors = new ArrayList<String>();}
        for (String item : items) {this.lastFailedRevisionErrors.add(item);} return (A)this;
    }

    public A addAllToLastFailedRevisionErrors(Collection<String> items) {
        if (this.lastFailedRevisionErrors == null) {this.lastFailedRevisionErrors = new ArrayList<String>();}
        for (String item : items) {this.lastFailedRevisionErrors.add(item);} return (A)this;
    }

    public A removeFromLastFailedRevisionErrors(String... items) {
        for (String item : items) {if (this.lastFailedRevisionErrors!= null){ this.lastFailedRevisionErrors.remove(item);}} return (A)this;
    }

    public A removeAllFromLastFailedRevisionErrors(Collection<String> items) {
        for (String item : items) {if (this.lastFailedRevisionErrors!= null){ this.lastFailedRevisionErrors.remove(item);}} return (A)this;
    }

    public List<String> getLastFailedRevisionErrors() {
        return this.lastFailedRevisionErrors;
    }

    public String getLastFailedRevisionError(int index) {
        return this.lastFailedRevisionErrors.get(index);
    }

    public String getFirstLastFailedRevisionError() {
        return this.lastFailedRevisionErrors.get(0);
    }

    public String getLastLastFailedRevisionError() {
        return this.lastFailedRevisionErrors.get(lastFailedRevisionErrors.size() - 1);
    }

    public String getMatchingLastFailedRevisionError(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: lastFailedRevisionErrors) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingLastFailedRevisionError(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: lastFailedRevisionErrors) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withLastFailedRevisionErrors(List<String> lastFailedRevisionErrors) {
        if (this.lastFailedRevisionErrors != null) { _visitables.get("lastFailedRevisionErrors").removeAll(this.lastFailedRevisionErrors);}
        if (lastFailedRevisionErrors != null) {this.lastFailedRevisionErrors = new ArrayList<String>(); for (String item : lastFailedRevisionErrors){this.addToLastFailedRevisionErrors(item);}} else { this.lastFailedRevisionErrors = null;} return (A) this;
    }

    public A withLastFailedRevisionErrors(String... lastFailedRevisionErrors) {
        if (this.lastFailedRevisionErrors != null) {this.lastFailedRevisionErrors.clear();}
        if (lastFailedRevisionErrors != null) {for (String item :lastFailedRevisionErrors){ this.addToLastFailedRevisionErrors(item);}} return (A) this;
    }

    public Boolean hasLastFailedRevisionErrors() {
        return lastFailedRevisionErrors != null && !lastFailedRevisionErrors.isEmpty();
    }

    public A addNewLastFailedRevisionError(String arg1) {
        return (A)addToLastFailedRevisionErrors(new String(arg1));
    }

    public A addNewLastFailedRevisionError(StringBuilder arg1) {
        return (A)addToLastFailedRevisionErrors(new String(arg1));
    }

    public A addNewLastFailedRevisionError(StringBuffer arg1) {
        return (A)addToLastFailedRevisionErrors(new String(arg1));
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public A withNodeName(String nodeName) {
        this.nodeName=nodeName; return (A) this;
    }

    public Boolean hasNodeName() {
        return this.nodeName != null;
    }

    public A withNewNodeName(String arg1) {
        return (A)withNodeName(new String(arg1));
    }

    public A withNewNodeName(StringBuilder arg1) {
        return (A)withNodeName(new String(arg1));
    }

    public A withNewNodeName(StringBuffer arg1) {
        return (A)withNodeName(new String(arg1));
    }

    public Integer getTargetRevision() {
        return this.targetRevision;
    }

    public A withTargetRevision(Integer targetRevision) {
        this.targetRevision=targetRevision; return (A) this;
    }

    public Boolean hasTargetRevision() {
        return this.targetRevision != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NodeStatusFluentImpl that = (NodeStatusFluentImpl) o;
        if (currentRevision != null ? !currentRevision.equals(that.currentRevision) :that.currentRevision != null) return false;
        if (lastFailedRevision != null ? !lastFailedRevision.equals(that.lastFailedRevision) :that.lastFailedRevision != null) return false;
        if (lastFailedRevisionErrors != null ? !lastFailedRevisionErrors.equals(that.lastFailedRevisionErrors) :that.lastFailedRevisionErrors != null) return false;
        if (nodeName != null ? !nodeName.equals(that.nodeName) :that.nodeName != null) return false;
        if (targetRevision != null ? !targetRevision.equals(that.targetRevision) :that.targetRevision != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(currentRevision,  lastFailedRevision,  lastFailedRevisionErrors,  nodeName,  targetRevision,  super.hashCode());
    }

}
