package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class NodePlacementFluentImpl<A extends NodePlacementFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements NodePlacementFluent<A> {

    private LabelSelectorBuilder nodeSelector;
    private List<Toleration> tolerations = new ArrayList<Toleration>();

    public NodePlacementFluentImpl() { 
    }


    public NodePlacementFluentImpl(NodePlacement instance) { 
        this.withNodeSelector(instance.getNodeSelector()); 
        this.withTolerations(instance.getTolerations()); 
    }


    
/**
 * This method has been deprecated, please use method buildNodeSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getNodeSelector() {
        return this.nodeSelector!=null?this.nodeSelector.build():null;
    }

    public LabelSelector buildNodeSelector() {
        return this.nodeSelector!=null?this.nodeSelector.build():null;
    }

    public A withNodeSelector(LabelSelector nodeSelector) {
        _visitables.get("nodeSelector").remove(this.nodeSelector);
        if (nodeSelector!=null){ this.nodeSelector= new LabelSelectorBuilder(nodeSelector); _visitables.get("nodeSelector").add(this.nodeSelector);} return (A) this;
    }

    public Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public NodePlacementFluent.NodeSelectorNested<A> withNewNodeSelector() {
        return new NodeSelectorNestedImpl();
    }

    public NodePlacementFluent.NodeSelectorNested<A> withNewNodeSelectorLike(LabelSelector item) {
        return new NodeSelectorNestedImpl(item);
    }

    public NodePlacementFluent.NodeSelectorNested<A> editNodeSelector() {
        return withNewNodeSelectorLike(getNodeSelector());
    }

    public NodePlacementFluent.NodeSelectorNested<A> editOrNewNodeSelector() {
        return withNewNodeSelectorLike(getNodeSelector() != null ? getNodeSelector(): new LabelSelectorBuilder().build());
    }

    public NodePlacementFluent.NodeSelectorNested<A> editOrNewNodeSelectorLike(LabelSelector item) {
        return withNewNodeSelectorLike(getNodeSelector() != null ? getNodeSelector(): item);
    }

    public A addToTolerations(int index,Toleration item) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        this.tolerations.add(index, item);
        return (A)this;
    }

    public A setToTolerations(int index,Toleration item) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        this.tolerations.set(index, item); return (A)this;
    }

    public A addToTolerations(Toleration... items) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A removeFromTolerations(Toleration... items) {
        for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public A removeAllFromTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    public Toleration getLastToleration() {
        return this.tolerations.get(tolerations.size() - 1);
    }

    public Toleration getMatchingToleration(io.fabric8.kubernetes.api.builder.Predicate<Toleration> predicate) {
        for (Toleration item: tolerations) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingToleration(io.fabric8.kubernetes.api.builder.Predicate<Toleration> predicate) {
        for (Toleration item: tolerations) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withTolerations(List<Toleration> tolerations) {
        if (this.tolerations != null) { _visitables.get("tolerations").removeAll(this.tolerations);}
        if (tolerations != null) {this.tolerations = new ArrayList<Toleration>(); for (Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
    }

    public A withTolerations(Toleration... tolerations) {
        if (this.tolerations != null) {this.tolerations.clear();}
        if (tolerations != null) {for (Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
    }

    public Boolean hasTolerations() {
        return tolerations != null && !tolerations.isEmpty();
    }

    public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
        return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NodePlacementFluentImpl that = (NodePlacementFluentImpl) o;
        if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
        if (tolerations != null ? !tolerations.equals(that.tolerations) :that.tolerations != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(nodeSelector,  tolerations,  super.hashCode());
    }

    public class NodeSelectorNestedImpl<N> extends LabelSelectorFluentImpl<NodePlacementFluent.NodeSelectorNested<N>> implements NodePlacementFluent.NodeSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorBuilder builder;

        NodeSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        NodeSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        public N and() {
             return (N) NodePlacementFluentImpl.this.withNodeSelector(builder.build());
        }

        public N endNodeSelector() {
             return and();
        }
    }


}
