
package io.fabric8.openshift.api.model.operator.v1;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "request",
    "response"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class IngressControllerCaptureHTTPHeaders implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("request")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<IngressControllerCaptureHTTPHeader> request = new ArrayList<IngressControllerCaptureHTTPHeader>();
    /**
     * 
     * 
     */
    @JsonProperty("response")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<IngressControllerCaptureHTTPHeader> response = new ArrayList<IngressControllerCaptureHTTPHeader>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public IngressControllerCaptureHTTPHeaders() {
    }

    /**
     * 
     * @param request
     * @param response
     */
    public IngressControllerCaptureHTTPHeaders(List<IngressControllerCaptureHTTPHeader> request, List<IngressControllerCaptureHTTPHeader> response) {
        this.request = request;
        this.response = response;
    }

    /**
     * 
     * 
     * @return
     *     The request
     */
    @JsonProperty("request")
    public List<IngressControllerCaptureHTTPHeader> getRequest() {
        return request;
    }

    /**
     * 
     * 
     * @param request
     *     The request
     */
    @JsonProperty("request")
    public void setRequest(List<IngressControllerCaptureHTTPHeader> request) {
        this.request = request;
    }

    /**
     * 
     * 
     * @return
     *     The response
     */
    @JsonProperty("response")
    public List<IngressControllerCaptureHTTPHeader> getResponse() {
        return response;
    }

    /**
     * 
     * 
     * @param response
     *     The response
     */
    @JsonProperty("response")
    public void setResponse(List<IngressControllerCaptureHTTPHeader> response) {
        this.response = response;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
