package io.fabric8.openshift.api.model.operator.v1;

import java.lang.Integer;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class IngressControllerCaptureHTTPHeaderFluentImpl<A extends IngressControllerCaptureHTTPHeaderFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements IngressControllerCaptureHTTPHeaderFluent<A> {

    private Integer maxLength;
    private String name;

    public IngressControllerCaptureHTTPHeaderFluentImpl() { 
    }


    public IngressControllerCaptureHTTPHeaderFluentImpl(IngressControllerCaptureHTTPHeader instance) { 
        this.withMaxLength(instance.getMaxLength()); 
        this.withName(instance.getName()); 
    }


    public Integer getMaxLength() {
        return this.maxLength;
    }

    public A withMaxLength(Integer maxLength) {
        this.maxLength=maxLength; return (A) this;
    }

    public Boolean hasMaxLength() {
        return this.maxLength != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IngressControllerCaptureHTTPHeaderFluentImpl that = (IngressControllerCaptureHTTPHeaderFluentImpl) o;
        if (maxLength != null ? !maxLength.equals(that.maxLength) :that.maxLength != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(maxLength,  name,  super.hashCode());
    }

}
