package io.fabric8.openshift.api.model.operator.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ForwardPluginFluent<A extends ForwardPluginFluent<A>> extends Fluent<A> {


    public A addToUpstreams(int index,String item);
    public A setToUpstreams(int index,String item);
    public A addToUpstreams(String... items);
    public A addAllToUpstreams(Collection<String> items);
    public A removeFromUpstreams(String... items);
    public A removeAllFromUpstreams(Collection<String> items);
    public List<String> getUpstreams();
    public String getUpstream(int index);
    public String getFirstUpstream();
    public String getLastUpstream();
    public String getMatchingUpstream(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingUpstream(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withUpstreams(List<String> upstreams);
    public A withUpstreams(String... upstreams);
    public Boolean hasUpstreams();
    public A addNewUpstream(String arg1);
    public A addNewUpstream(StringBuilder arg1);
    public A addNewUpstream(StringBuffer arg1);
}
