package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface EtcdFluent<A extends EtcdFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public EtcdFluent.MetadataNested<A> withNewMetadata();
    public EtcdFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public EtcdFluent.MetadataNested<A> editMetadata();
    public EtcdFluent.MetadataNested<A> editOrNewMetadata();
    public EtcdFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public EtcdSpec getSpec();
    public EtcdSpec buildSpec();
    public A withSpec(EtcdSpec spec);
    public Boolean hasSpec();
    public EtcdFluent.SpecNested<A> withNewSpec();
    public EtcdFluent.SpecNested<A> withNewSpecLike(EtcdSpec item);
    public EtcdFluent.SpecNested<A> editSpec();
    public EtcdFluent.SpecNested<A> editOrNewSpec();
    public EtcdFluent.SpecNested<A> editOrNewSpecLike(EtcdSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public EtcdStatus getStatus();
    public EtcdStatus buildStatus();
    public A withStatus(EtcdStatus status);
    public Boolean hasStatus();
    public EtcdFluent.StatusNested<A> withNewStatus();
    public EtcdFluent.StatusNested<A> withNewStatusLike(EtcdStatus item);
    public EtcdFluent.StatusNested<A> editStatus();
    public EtcdFluent.StatusNested<A> editOrNewStatus();
    public EtcdFluent.StatusNested<A> editOrNewStatusLike(EtcdStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<EtcdFluent.MetadataNested<N>> {

        public N and();
        public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EtcdSpecFluent<EtcdFluent.SpecNested<N>> {

        public N and();
        public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EtcdStatusFluent<EtcdFluent.StatusNested<N>> {

        public N and();
        public N endStatus();    }


}
