package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DNSRecordSpecBuilder extends DNSRecordSpecFluentImpl<DNSRecordSpecBuilder> implements VisitableBuilder<DNSRecordSpec,DNSRecordSpecBuilder> {

    DNSRecordSpecFluent<?> fluent;
    Boolean validationEnabled;

    public DNSRecordSpecBuilder() { 
        this(true);
    }


    public DNSRecordSpecBuilder(Boolean validationEnabled) { 
        this(new DNSRecordSpec(), validationEnabled);
    }


    public DNSRecordSpecBuilder(DNSRecordSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public DNSRecordSpecBuilder(DNSRecordSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new DNSRecordSpec(), validationEnabled);
    }


    public DNSRecordSpecBuilder(DNSRecordSpecFluent<?> fluent,DNSRecordSpec instance) { 
        this(fluent, instance, true);
    }


    public DNSRecordSpecBuilder(DNSRecordSpecFluent<?> fluent,DNSRecordSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withDnsName(instance.getDnsName()); 
        fluent.withRecordTTL(instance.getRecordTTL()); 
        fluent.withRecordType(instance.getRecordType()); 
        fluent.withTargets(instance.getTargets()); 
        this.validationEnabled = validationEnabled; 
    }


    public DNSRecordSpecBuilder(DNSRecordSpec instance) { 
        this(instance,true);
    }


    public DNSRecordSpecBuilder(DNSRecordSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withDnsName(instance.getDnsName()); 
        this.withRecordTTL(instance.getRecordTTL()); 
        this.withRecordType(instance.getRecordType()); 
        this.withTargets(instance.getTargets()); 
        this.validationEnabled = validationEnabled; 
    }


    public DNSRecordSpec build() {
        DNSRecordSpec buildable = new DNSRecordSpec(fluent.getDnsName(),fluent.getRecordTTL(),fluent.getRecordType(),fluent.getTargets());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DNSRecordSpecBuilder that = (DNSRecordSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
