package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ConsoleListFluent<A extends ConsoleListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Console item);
    public A setToItems(int index,Console item);
    public A addToItems(Console... items);
    public A addAllToItems(Collection<Console> items);
    public A removeFromItems(Console... items);
    public A removeAllFromItems(Collection<Console> items);
    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<ConsoleBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Console> getItems();
    public List<Console> buildItems();
    public Console buildItem(int index);
    public Console buildFirstItem();
    public Console buildLastItem();
    public Console buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ConsoleBuilder> predicate);
    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ConsoleBuilder> predicate);
    public A withItems(List<Console> items);
    public A withItems(Console... items);
    public Boolean hasItems();
    public ConsoleListFluent.ItemsNested<A> addNewItem();
    public ConsoleListFluent.ItemsNested<A> addNewItemLike(Console item);
    public ConsoleListFluent.ItemsNested<A> setNewItemLike(int index,Console item);
    public ConsoleListFluent.ItemsNested<A> editItem(int index);
    public ConsoleListFluent.ItemsNested<A> editFirstItem();
    public ConsoleListFluent.ItemsNested<A> editLastItem();
    public ConsoleListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ConsoleBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConsoleFluent<ConsoleListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
